/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.views.rechnung;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.ui.text.ITextPlugin;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.views.rechnung.Messages;
import ch.elexis.core.ui.views.rechnung.RnActions;
import ch.elexis.data.Fall;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Patient;
import ch.elexis.data.Rechnung;
import ch.elexis.data.RnStatus;
import ch.elexis.data.Zahlung;
import ch.elexis.scripting.CSVWriter;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.Money;
import ch.rgw.tools.Tree;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RnListeExportDialog
extends TitleAreaDialog
implements ITextPlugin.ICallback {
    ArrayList<Rechnung> rnn;
    private Logger log = LoggerFactory.getLogger(RnActions.class);
    private String RnListExportFileName = new SimpleDateFormat("'RnListExport-'yyyyMMddHHmmss'.csv'").format(new Date());
    String RnListExportDirname = CoreHub.localCfg.get("rechnung/RnListExportDirname", null);
    Text tDirName;

    public RnListeExportDialog(Shell shell, Object[] tree) {
        super(shell);
        this.rnn = new ArrayList(tree.length);
        Object[] objectArray = tree;
        int n = tree.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (o instanceof Tree) {
                Tree tr = (Tree)o;
                if (tr.contents instanceof Rechnung) {
                    tr = tr.getParent();
                }
                if (tr.contents instanceof Fall) {
                    tr = tr.getParent();
                }
                if (tr.contents instanceof Patient) {
                    Tree[] treeArray = tr.getChildren().toArray(new Tree[0]);
                    int n3 = treeArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Tree tFall = treeArray[n4];
                        Fall fall = (Fall)tFall.contents;
                        Tree[] treeArray2 = tFall.getChildren().toArray(new Tree[0]);
                        int n5 = treeArray2.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            Tree tRn = treeArray2[n6];
                            Rechnung rn = (Rechnung)tRn.contents;
                            if (!this.rnn.contains(rn)) {
                                this.rnn.add(rn);
                            }
                            ++n6;
                        }
                        ++n4;
                    }
                }
            }
            ++n2;
        }
    }

    protected Control createDialogArea(final Composite parent) {
        Composite ret = new Composite(parent, 0);
        ret.setLayout((Layout)new FillLayout());
        ret.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, true));
        Group cSaveCopy = new Group(ret, 0);
        cSaveCopy.setText(String.format(Messages.RnActions_exportSaveHelp, this.RnListExportFileName));
        cSaveCopy.setLayout((Layout)new GridLayout(2, false));
        Button bSelectFile = new Button((Composite)cSaveCopy, 8);
        bSelectFile.setText(Messages.RnActions_exportListDirName);
        bSelectFile.setLayoutData((Object)SWTHelper.getFillGridData(2, false, 1, false));
        bSelectFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog ddlg = new DirectoryDialog(parent.getShell());
                RnListeExportDialog.this.RnListExportDirname = ddlg.open();
                if (RnListeExportDialog.this.RnListExportDirname == null) {
                    SWTHelper.alert(Messages.RnActions_exportListDirNameMissingCaption, Messages.RnActions_exportListDirNameMissingText);
                } else {
                    CoreHub.localCfg.set("rechnung/RnListExportDirname", RnListeExportDialog.this.RnListExportDirname);
                    RnListeExportDialog.this.tDirName.setText(RnListeExportDialog.this.RnListExportDirname);
                }
            }
        });
        this.tDirName = new Text((Composite)cSaveCopy, 2056);
        this.tDirName.setText(CoreHub.localCfg.get("rechnung/RnListExportDirname", ""));
        this.tDirName.setLayoutData((Object)SWTHelper.getFillGridData(2, true, 1, false));
        return ret;
    }

    public void create() {
        super.create();
        this.getShell().setText(Messages.RnActions_billsList);
        this.setTitle(Messages.RnActions_exportListCaption);
        this.setMessage(Messages.RnActions_exportListMessage);
        this.getShell().setSize(900, 700);
        SWTHelper.center(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), this.getShell());
    }

    protected void okPressed() {
        super.okPressed();
        if (CoreHub.localCfg.get("rechnung/RnListExportDirname_bSaveFileAs", true)) {
            this.CSVWriteTable();
        }
    }

    @Override
    public void save() {
    }

    @Override
    public boolean saveAs() {
        return false;
    }

    public void CSVWriteTable() {
        block21: {
            String pathToSave = String.valueOf(this.RnListExportDirname) + "/" + this.RnListExportFileName;
            CSVWriter csv = null;
            int nrLines = 0;
            try {
                try {
                    csv = new CSVWriter(new FileWriter(pathToSave));
                    String[] header = new String[]{"Aktion?", "Re.Nr", "Re.DatumRn", "Re.DatumVon", "Re.DatumBis", "Re.Garant", "Re.Total", "Re.Offen", "Re.StatusLastUpdate", "Re.Status", "Re.StatusIsActive", "Re.StatusText", "Re.StatusChanges", "Re.Rejecteds", "Re.Outputs", "Re.Payments", "Fall.AbrSystem", "Fall.Bezeichnung", "Fall.Grund", "Pat.Nr", "Pat.Name", "Pat.Vorname", "Pat.GebDat", "Pat.LztKonsDat", "Pat.Balance", "Pat.GetAccountExcess", "Pat.BillSummary.Total.", "Pat.BillSummary.Paid", "Pat.BillSummary.Open"};
                    this.log.debug("csv export started for {} with {} fields for {} invoices", new Object[]{pathToSave, header.length, this.rnn.size()});
                    csv.writeNext(header);
                    ++nrLines;
                    int i = 0;
                    while (i < this.rnn.size()) {
                        List payments;
                        String rnPayment;
                        List outputs;
                        String rnOutput;
                        List rejects;
                        String rnStatus;
                        Rechnung rn = this.rnn.get(i);
                        Fall fall = rn.getFall();
                        Patient p = fall.getPatient();
                        String[] line = new String[header.length];
                        line[0] = "";
                        line[1] = rn.getNr();
                        line[2] = rn.getDatumRn();
                        line[3] = rn.getDatumVon();
                        line[4] = rn.getDatumBis();
                        line[5] = fall.getGarant().getLabel();
                        line[6] = rn.getBetrag().toString();
                        line[7] = rn.getOffenerBetrag().toString();
                        long luTime = rn.getLastUpdate();
                        Date date = new Date(luTime);
                        SimpleDateFormat df2 = new SimpleDateFormat("dd.MM.yyyy");
                        String dateText = df2.format(date);
                        line[8] = dateText.toString();
                        int st = rn.getStatus();
                        line[9] = Integer.toString(st);
                        line[10] = RnStatus.isActive((int)st) ? "True" : "False";
                        line[11] = RnStatus.getStatusText((int)st);
                        List statuschgs = rn.getTrace("Status\u00e4nderung");
                        String a = statuschgs.toString();
                        if (a != null && a.length() > 1) {
                            a = a.replaceAll(", [0-9][0-9]:[0-9][0-9]:[0-9][0-9]", "");
                            a = a.replaceAll(", ", "\n");
                            line[12] = a.substring(1, a.length() - 1);
                        }
                        if (rn.getStatus() == 22 && (rnStatus = (rejects = rn.getTrace("Zur\u00fcckgewiesen")).toString()) != null && rnStatus.length() > 1) {
                            rnStatus = rnStatus.replaceAll(", [0-9][0-9]:[0-9][0-9]:[0-9][0-9]", "");
                            rnStatus = rnStatus.replaceAll(", ", "\n");
                            line[13] = rnStatus.substring(1, rnStatus.length() - 1);
                        }
                        if ((rnOutput = (outputs = rn.getTrace("Ausgegeben")).toString()) != null && rnOutput.length() > 1) {
                            rnOutput = rnOutput.replaceAll(", [0-9][0-9]:[0-9][0-9]:[0-9][0-9]", "");
                            rnOutput = rnOutput.replaceAll(", ", "\n");
                            line[14] = rnOutput.substring(1, rnOutput.length() - 1);
                        }
                        if ((rnPayment = (payments = rn.getTrace("Zahlung")).toString()) != null && rnPayment.length() > 1) {
                            rnPayment = rnPayment.replaceAll(", [0-9][0-9]:[0-9][0-9]:[0-9][0-9]", "");
                            rnPayment = rnPayment.replaceAll(", ", "\n");
                            line[15] = rnPayment.substring(1, rnPayment.length() - 1);
                        }
                        line[16] = fall.getAbrechnungsSystem();
                        line[17] = fall.getBezeichnung();
                        line[18] = fall.getGrund();
                        line[19] = p.getKuerzel();
                        line[20] = p.getName();
                        line[21] = p.getVorname();
                        line[22] = p.getGeburtsdatum();
                        String lkDatum = "p==null";
                        if (p != null) {
                            Konsultation lk = p.getLetzteKons(false);
                            lkDatum = lk != null ? lk.getDatum() : "lk==null";
                        }
                        line[23] = lkDatum;
                        line[24] = p.getBalance();
                        line[25] = p.getAccountExcess().toString();
                        String totalText = "";
                        String paidText = "";
                        String openText = "";
                        if (p != null) {
                            Money total = new Money(0);
                            Money paid = new Money(0);
                            List rechnungen = p.getRechnungen();
                            for (Rechnung rechnung : rechnungen) {
                                if (rechnung.getStatus() == 18) continue;
                                total.addMoney(rechnung.getBetrag());
                                for (Zahlung zahlung : rechnung.getZahlungen()) {
                                    paid.addMoney(zahlung.getBetrag());
                                }
                            }
                            Money open = new Money(total);
                            open.subtractMoney(paid);
                            totalText = total.toString();
                            paidText = paid.toString();
                            openText = open.toString();
                        }
                        line[26] = totalText;
                        line[27] = paidText;
                        line[28] = openText;
                        csv.writeNext(line);
                        ++nrLines;
                        ++i;
                    }
                    csv.close();
                    this.log.debug("{}: Wrote {} lines for {} invoices", new Object[]{pathToSave, nrLines, this.rnn.size()});
                }
                catch (Exception ex) {
                    ExHandler.handle((Throwable)ex);
                    this.log.error("csv exporter error", (Throwable)ex);
                    SWTHelper.showError("Fehler", ex.getMessage());
                    if (csv == null) break block21;
                    try {
                        csv.close();
                    }
                    catch (IOException e) {
                        this.log.error("cannot close csv exporter", (Throwable)e);
                    }
                }
            }
            finally {
                if (csv != null) {
                    try {
                        csv.close();
                    }
                    catch (IOException e) {
                        this.log.error("cannot close csv exporter", (Throwable)e);
                    }
                }
            }
        }
    }
}

