/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.views.rechnung;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.ui.Hub;
import ch.elexis.core.ui.text.ITextPlugin;
import ch.elexis.core.ui.text.TextContainer;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.views.rechnung.Messages;
import ch.elexis.data.Fall;
import ch.elexis.data.Kontakt;
import ch.elexis.data.Patient;
import ch.elexis.data.Rechnung;
import ch.rgw.tools.Money;
import ch.rgw.tools.TimeTool;
import ch.rgw.tools.Tree;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class RnListeDruckDialog
extends TitleAreaDialog
implements ITextPlugin.ICallback {
    ArrayList<Rechnung> rnn = new ArrayList();
    private TextContainer text;

    public RnListeDruckDialog(Shell shell, Object[] tree) {
        super(shell);
        Object[] objectArray = tree;
        int n = tree.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (o instanceof Tree) {
                Tree tr = (Tree)o;
                if (tr.contents instanceof Rechnung) {
                    tr = tr.getParent();
                }
                if (tr.contents instanceof Fall) {
                    tr = tr.getParent();
                }
                if (tr.contents instanceof Patient) {
                    Tree[] treeArray = tr.getChildren().toArray(new Tree[0]);
                    int n3 = treeArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Tree tFall = treeArray[n4];
                        Fall fall = (Fall)tFall.contents;
                        Tree[] treeArray2 = tFall.getChildren().toArray(new Tree[0]);
                        int n5 = treeArray2.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            Tree tRn = treeArray2[n6];
                            Rechnung rn = (Rechnung)tRn.contents;
                            this.rnn.add(rn);
                            if (!this.rnn.contains(rn)) {
                                this.rnn.add(rn);
                            }
                            ++n6;
                        }
                        ++n4;
                    }
                }
            }
            ++n2;
        }
    }

    public RnListeDruckDialog(Shell shell, List<Rechnung> invoiceSelections) {
        super(shell);
        this.rnn.addAll(invoiceSelections);
    }

    protected Control createDialogArea(Composite parent) {
        Composite ret = new Composite(parent, 0);
        this.text = new TextContainer(this.getShell());
        ret.setLayout((Layout)new FillLayout());
        ret.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, true));
        this.text.getPlugin().createContainer(ret, this);
        this.text.getPlugin().showMenu(false);
        this.text.getPlugin().showToolbar(false);
        this.text.createFromTemplateName(null, "Liste", "Allg.", (Kontakt)CoreHub.actUser, Messages.RnActions_bills);
        this.text.getPlugin().insertText("[Titel]", String.valueOf(Messages.RnActions_billsListPrintetAt) + new TimeTool().toString(4) + "\n", 0x1000000);
        String[][] table = new String[this.rnn.size() + 1][];
        Money sum = new Money();
        int i = 0;
        while (i < this.rnn.size()) {
            Rechnung rn = this.rnn.get(i);
            table[i] = new String[3];
            StringBuilder sb = new StringBuilder();
            Fall fall = rn.getFall();
            Patient p = fall.getPatient();
            table[i][0] = rn.getNr();
            sb.append(p.getLabel()).append(" - ").append(fall.getLabel());
            table[i][1] = sb.toString();
            Money betrag = rn.getBetrag();
            sum.addMoney(betrag);
            table[i][2] = betrag.getAmountAsString();
            ++i;
        }
        table[i] = new String[3];
        table[i][0] = "";
        table[i][1] = Messages.RnActions_sum;
        table[i][2] = sum.getAmountAsString();
        this.text.getPlugin().setFont("Helvetica", 0, 9.0f);
        this.text.getPlugin().insertTable("[Liste]", 0, table, new int[]{10, 80, 10});
        this.text.getPlugin().showMenu(true);
        this.text.getPlugin().showToolbar(true);
        return ret;
    }

    public void create() {
        super.create();
        this.getShell().setText(Messages.RnActions_billsList);
        this.setTitle(Messages.RnActions_printListCaption);
        this.setMessage(Messages.RnActions_printListMessage);
        this.getShell().setSize(900, 700);
        SWTHelper.center(Hub.plugin.getWorkbench().getActiveWorkbenchWindow().getShell(), this.getShell());
    }

    protected void okPressed() {
        super.okPressed();
    }

    @Override
    public void save() {
    }

    @Override
    public boolean saveAs() {
        return false;
    }
}

