/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.views.rechnung;

import ch.elexis.admin.AccessControlDefaults;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.ElexisEvent;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.events.ElexisEventListener;
import ch.elexis.core.data.events.ElexisEventListenerImpl;
import ch.elexis.core.data.util.Extensions;
import ch.elexis.core.exceptions.ElexisException;
import ch.elexis.core.model.IDiagnose;
import ch.elexis.core.model.InvoiceState;
import ch.elexis.core.ui.Hub;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.actions.GlobalEventDispatcher;
import ch.elexis.core.ui.actions.IActivationListener;
import ch.elexis.core.ui.events.ElexisUiEventListenerImpl;
import ch.elexis.core.ui.util.LabeledInputField;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.util.WidgetFactory;
import ch.elexis.core.ui.util.viewers.DefaultLabelProvider;
import ch.elexis.core.ui.views.contribution.IViewContribution;
import ch.elexis.core.ui.views.contribution.ViewContributionHelper;
import ch.elexis.core.ui.views.rechnung.Messages;
import ch.elexis.core.ui.views.rechnung.RnDialogs;
import ch.elexis.data.Anwender;
import ch.elexis.data.Fall;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Kontakt;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Query;
import ch.elexis.data.Rechnung;
import ch.elexis.data.RnStatus;
import ch.elexis.data.Verrechnet;
import ch.elexis.data.VerrechnetCopy;
import ch.elexis.data.Zahlung;
import ch.rgw.tools.Money;
import ch.rgw.tools.StringTool;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class RechnungsBlatt
extends Composite
implements IActivationListener {
    private static final String KEY_RECHNUNGSBLATT = "RechnungsBlatt/";
    IViewSite site;
    ListViewer buchungen;
    org.eclipse.swt.widgets.List lbJournal;
    org.eclipse.swt.widgets.List lbOutputs;
    Rechnung actRn;
    ScrolledForm form;
    FormToolkit tk = UiDesk.getToolkit();
    Text tRejects;
    Text tBemerkungen;
    Label rnAdressat;
    ListViewer konsultationenViewer;
    ListViewer stornoViewer;
    private final ExpandableComposite ecBuchungen;
    private final ExpandableComposite ecBemerkungen;
    private final ExpandableComposite ecStatus;
    private final ExpandableComposite ecFehler;
    private final ExpandableComposite ecAusgaben;
    private final ExpandableComposite ecKons;
    private final ExpandableComposite ecStorno;
    private final List<IViewContribution> detailComposites = Extensions.getClasses((String)"ch.elexis.core.ui.ViewContribution", (String)"class", (String)"viewId", (String)"ch.elexis.RechnungsDetailView");
    private static LabeledInputField.IContentProvider openAmountContentProvider = new LabeledInputField.IContentProvider(){

        @Override
        public void displayContent(PersistentObject po, LabeledInputField.InputData ltf) {
            Rechnung invoice = (Rechnung)po;
            Money openAmount = invoice.getOffenerBetrag();
            ltf.setText(openAmount.getAmountAsString());
            if (InvoiceState.CANCELLED.numericValue() == invoice.getStatus()) {
                ltf.setLabel(Messages.RechnungsBlatt_compensateAmount);
            } else {
                ltf.setLabel(Messages.RechnungsBlatt_amountOpen);
            }
        }

        @Override
        public void reloadContent(PersistentObject po, LabeledInputField.InputData ltf) {
            Rechnung invoice = (Rechnung)po;
            if (InvoiceState.CANCELLED.numericValue() == invoice.getStatus()) {
                Money openAmount = invoice.getOffenerBetrag();
                if (openAmount.isZero()) {
                    return;
                }
                if (!CoreHub.acl.request(AccessControlDefaults.ACCOUNTING_BILLMODIFY)) {
                    MessageDialog.openError((Shell)Hub.plugin.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Insufficient rights", (String)"You are not authorized to perform this action");
                    return;
                }
            }
            try {
                RnDialogs.BuchungHinzuDialog comp = new RnDialogs.BuchungHinzuDialog(Hub.plugin.getWorkbench().getActiveWorkbenchWindow().getShell(), invoice, true);
                comp.open();
                ElexisEventDispatcher.update((PersistentObject)invoice);
            }
            catch (ElexisException e) {
                SWTHelper.showError("Buchung kann nicht hinzugef\u00fcgt werden", e.getLocalizedMessage());
            }
        }
    };
    private static final LabeledInputField.InputData[] rndata = new LabeledInputField.InputData[]{new LabeledInputField.InputData(Messages.RechnungsBlatt_billNumber, "RnNummer", LabeledInputField.InputData.Typ.STRING, null), new LabeledInputField.InputData(Messages.RechnungsBlatt_billDate, "RnDatum", LabeledInputField.InputData.Typ.STRING, null), new LabeledInputField.InputData(Messages.RechnungsBlatt_billState, "RnStatus", new LabeledInputField.IContentProvider(){

        @Override
        public void displayContent(PersistentObject po, LabeledInputField.InputData ltf) {
            Rechnung r = (Rechnung)po;
            ltf.setText(RnStatus.getStatusText((int)r.getStatus()));
        }

        @Override
        public void reloadContent(PersistentObject po, LabeledInputField.InputData ltf) {
            if (new RnDialogs.StatusAendernDialog(Hub.plugin.getWorkbench().getActiveWorkbenchWindow().getShell(), (Rechnung)po).open() == 0) {
                ElexisEventDispatcher.update((PersistentObject)po);
            }
        }
    }), new LabeledInputField.InputData(Messages.RechnungsBlatt_treatmentsFrom, "RnDatumVon", LabeledInputField.InputData.Typ.STRING, null), new LabeledInputField.InputData(Messages.RechnungsBlatt_treatmentsUntil, "RnDatumBis", LabeledInputField.InputData.Typ.STRING, null), new LabeledInputField.InputData(Messages.RechnungsBlatt_amountTotal, "Betragx100", LabeledInputField.InputData.Typ.CURRENCY, null), new LabeledInputField.InputData(Messages.RechnungsBlatt_amountOpen, "Betragx100", openAmountContentProvider)};
    private LabeledInputField.AutoForm rnform;
    private final ElexisEventListenerImpl eeli_rn = new ElexisUiEventListenerImpl(Rechnung.class, 55){

        @Override
        public void runInUi(ElexisEvent ev) {
            switch (ev.getType()) {
                case 4: {
                    RechnungsBlatt.this.doSelect((Rechnung)ev.getObject());
                    break;
                }
                case 32: {
                    RechnungsBlatt.this.doSelect(null);
                    break;
                }
                case 2: {
                    if (RechnungsBlatt.this.actRn == null || !RechnungsBlatt.this.actRn.getId().equals(ev.getObject().getId())) break;
                    RechnungsBlatt.this.doSelect(null);
                    break;
                }
                case 16: {
                    RechnungsBlatt.this.doSelect((Rechnung)ev.getObject());
                }
            }
        }
    };
    private final ElexisEventListenerImpl eeli_user = new ElexisUiEventListenerImpl(Anwender.class, 64){

        @Override
        public void runInUi(ElexisEvent ev) {
            RechnungsBlatt.this.display();
        }
    };
    private final ElexisEventListenerImpl eeli_patient = new ElexisUiEventListenerImpl(Patient.class, 48){

        @Override
        public void runInUi(ElexisEvent ev) {
            Patient pat = (Patient)ev.getObject();
            switch (ev.getType()) {
                case 32: {
                    RechnungsBlatt.this.doSelect(null);
                    break;
                }
                case 16: {
                    Patient patient;
                    Fall fall;
                    if (RechnungsBlatt.this.actRn == null || !(fall = RechnungsBlatt.this.actRn.getFall()).exists() || Objects.equals(pat, patient = fall.getPatient())) break;
                    RechnungsBlatt.this.doSelect(null);
                }
            }
        }
    };

    public RechnungsBlatt(Composite parent, IViewSite site) {
        super(parent, 0);
        this.site = site;
        this.setLayout((Layout)new GridLayout());
        this.form = this.tk.createScrolledForm((Composite)this);
        this.form.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, true));
        Composite body = this.form.getBody();
        body.setLayout((Layout)new GridLayout());
        this.rnform = new LabeledInputField.AutoForm(body, rndata, 2, 3);
        LabeledInputField.InputData[] inputDataArray = rndata;
        int n = rndata.length;
        int n2 = 0;
        while (n2 < n) {
            LabeledInputField.InputData li = inputDataArray[n2];
            li.setEditable(false);
            ++n2;
        }
        this.rnform.setLayoutData(SWTHelper.getFillGridData(1, true, 1, false));
        this.rnAdressat = new Label(body, 0);
        this.rnAdressat.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
        ExpansionAdapter ecExpansionListener = new ExpansionAdapter(){

            public void expansionStateChanging(ExpansionEvent e) {
                ExpandableComposite src = (ExpandableComposite)e.getSource();
                RechnungsBlatt.this.saveExpandedState(RechnungsBlatt.KEY_RECHNUNGSBLATT + src.getText(), e.getState());
            }
        };
        this.ecBuchungen = WidgetFactory.createExpandableComposite(this.tk, this.form, Messages.RechnungsBlatt_bookings);
        this.ecBuchungen.addExpansionListener((IExpansionListener)ecExpansionListener);
        this.buchungen = new ListViewer((Composite)this.ecBuchungen, 2560);
        SWTHelper.setGridDataHeight(this.buchungen.getControl(), 4, true);
        this.buchungen.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public Object[] getElements(Object inputElement) {
                Rechnung actRn = (Rechnung)inputElement;
                if (actRn == null) {
                    return new String[]{Messages.RechnungsBlatt_noBillSelected};
                }
                List lz = actRn.getZahlungen();
                return lz.toArray();
            }
        });
        this.tk.adapt(this.buchungen.getControl(), true, true);
        this.ecBuchungen.setClient(this.buchungen.getControl());
        this.buchungen.setLabelProvider((IBaseLabelProvider)new DefaultLabelProvider(){

            @Override
            public String getColumnText(Object element, int columnIndex) {
                return this.getText(element);
            }

            @Override
            public String getText(Object element) {
                if (element instanceof Zahlung) {
                    Zahlung zahlung = (Zahlung)element;
                    StringBuilder sb = new StringBuilder();
                    sb.append(zahlung.getLabel());
                    String bemerkung = zahlung.getBemerkung();
                    if (!StringTool.isNothing((Object)bemerkung)) {
                        sb.append(" (");
                        sb.append(bemerkung);
                        sb.append(")");
                    }
                    return sb.toString();
                }
                return element.toString();
            }
        });
        this.buchungen.setInput(null);
        this.ecBemerkungen = WidgetFactory.createExpandableComposite(this.tk, this.form, Messages.RechnungsBlatt_remarks);
        this.ecBemerkungen.addExpansionListener((IExpansionListener)ecExpansionListener);
        this.tBemerkungen = SWTHelper.createText(this.tk, (Composite)this.ecBemerkungen, 5, 2048);
        this.tBemerkungen.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                if (RechnungsBlatt.this.actRn != null) {
                    RechnungsBlatt.this.actRn.setBemerkung(RechnungsBlatt.this.tBemerkungen.getText());
                }
            }
        });
        this.ecBemerkungen.setClient((Control)this.tBemerkungen);
        this.ecStatus = WidgetFactory.createExpandableComposite(this.tk, this.form, Messages.RechnungsBlatt_sateChangements);
        this.ecStatus.addExpansionListener((IExpansionListener)ecExpansionListener);
        this.lbJournal = new org.eclipse.swt.widgets.List((Composite)this.ecStatus, 2560);
        SWTHelper.setGridDataHeight((Control)this.lbJournal, 4, true);
        this.tk.adapt((Control)this.lbJournal, true, true);
        this.ecStatus.setClient((Control)this.lbJournal);
        this.ecFehler = WidgetFactory.createExpandableComposite(this.tk, this.form, Messages.RechnungsBlatt_errorMessages);
        this.ecFehler.addExpansionListener((IExpansionListener)ecExpansionListener);
        this.tRejects = SWTHelper.createText(this.tk, (Composite)this.ecFehler, 4, 520);
        this.ecFehler.setClient((Control)this.tRejects);
        this.ecAusgaben = WidgetFactory.createExpandableComposite(this.tk, this.form, Messages.RechnungsBlatt_outputs);
        this.ecAusgaben.addExpansionListener((IExpansionListener)ecExpansionListener);
        this.lbOutputs = new org.eclipse.swt.widgets.List((Composite)this.ecAusgaben, 2560);
        this.ecAusgaben.setClient((Control)this.lbOutputs);
        SWTHelper.setGridDataHeight((Control)this.lbOutputs, 4, true);
        this.tk.adapt((Control)this.lbOutputs, true, true);
        this.ecKons = WidgetFactory.createExpandableComposite(this.tk, this.form, Messages.RechnungsBlatt_consultations);
        this.ecKons.addExpansionListener((IExpansionListener)ecExpansionListener);
        this.konsultationenViewer = new ListViewer((Composite)this.ecKons, 2816);
        this.ecKons.setClient((Control)this.konsultationenViewer.getList());
        this.konsultationenViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                List konsultationen;
                ArrayList<Object> elements = new ArrayList<Object>();
                if (RechnungsBlatt.this.actRn != null && (konsultationen = RechnungsBlatt.this.actRn.getKonsultationen()) != null) {
                    for (Konsultation konsultation : konsultationen) {
                        List leistungen;
                        elements.add(konsultation);
                        ArrayList diagnosen = konsultation.getDiagnosen();
                        if (diagnosen != null) {
                            for (IDiagnose diagnose : diagnosen) {
                                elements.add(diagnose);
                            }
                        }
                        if ((leistungen = konsultation.getLeistungen()) == null) continue;
                        for (Verrechnet verrechnet : leistungen) {
                            elements.add(verrechnet);
                        }
                    }
                }
                return elements.toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.konsultationenViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof Konsultation) {
                    Konsultation konsultation = (Konsultation)element;
                    Money sum = new Money(0);
                    List leistungen = konsultation.getLeistungen();
                    if (leistungen != null) {
                        for (Verrechnet verrechnet : leistungen) {
                            int zahl = verrechnet.getZahl();
                            Money preis = verrechnet.getNettoPreis();
                            preis.multiply((double)zahl);
                            sum.addMoney(preis);
                        }
                    }
                    return String.valueOf(konsultation.getLabel()) + " (" + sum.toString() + ")";
                }
                if (element instanceof IDiagnose) {
                    IDiagnose diagnose = (IDiagnose)element;
                    return "  - " + diagnose.getLabel();
                }
                if (element instanceof Verrechnet) {
                    Verrechnet verrechnet = (Verrechnet)element;
                    int zahl = verrechnet.getZahl();
                    Money preis = verrechnet.getNettoPreis();
                    preis.multiply((double)zahl);
                    return "  - " + zahl + " " + verrechnet.getLabel() + " (" + preis.toString() + ")";
                }
                return element.toString();
            }
        });
        this.konsultationenViewer.setInput((Object)this);
        this.ecStorno = WidgetFactory.createExpandableComposite(this.tk, this.form, Messages.RechnungsBlatt_storno);
        this.ecStorno.addExpansionListener((IExpansionListener)ecExpansionListener);
        this.stornoViewer = new ListViewer((Composite)this.ecStorno, 2816);
        this.ecStorno.setClient((Control)this.stornoViewer.getList());
        this.stornoViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                List konsultationen;
                ArrayList<Object> elements = new ArrayList<Object>();
                if (RechnungsBlatt.this.actRn != null && ((konsultationen = RechnungsBlatt.this.actRn.getKonsultationen()) == null || konsultationen.isEmpty())) {
                    HashMap<Konsultation, List<VerrechnetCopy>> elementsMap = new HashMap<Konsultation, List<VerrechnetCopy>>();
                    StringBuilder sbHeadingLabel = new StringBuilder();
                    sbHeadingLabel.append(String.valueOf(Messages.AccountView_bill) + " " + RechnungsBlatt.this.actRn.getDatumRn());
                    sbHeadingLabel.append(Messages.RechnungsBlatt_stornoLabel);
                    Query vcQuery = new Query(VerrechnetCopy.class);
                    vcQuery.add("RechnungId", "=", RechnungsBlatt.this.actRn.getId());
                    List vcList = vcQuery.execute();
                    Money sum = new Money(0);
                    for (VerrechnetCopy vc : vcList) {
                        Money price = vc.getNettoPreis();
                        price.multiply((double)vc.getZahl());
                        sum.addMoney(price);
                        this.addToMap(vc, elementsMap);
                    }
                    Set keys = elementsMap.keySet();
                    for (Konsultation konsultation : keys) {
                        if (konsultation != null) {
                            elements.add(konsultation);
                        } else {
                            elements.add("?");
                        }
                        elements.addAll((Collection)elementsMap.get(konsultation));
                    }
                    sbHeadingLabel.append(sum.toString());
                    elements.add(0, sbHeadingLabel.toString());
                }
                return elements.toArray();
            }

            private void addToMap(VerrechnetCopy copy, HashMap<Konsultation, List<VerrechnetCopy>> elementsMap) {
                String konsId = copy.get("BehandlungId");
                if (konsId != null && !konsId.isEmpty()) {
                    Konsultation kons = Konsultation.load((String)konsId);
                    if (kons != null && kons.exists()) {
                        List<VerrechnetCopy> list = elementsMap.get(kons);
                        if (list == null) {
                            list = new ArrayList<VerrechnetCopy>();
                        }
                        list.add(copy);
                        elementsMap.put(kons, list);
                    } else {
                        List<VerrechnetCopy> list = elementsMap.get(null);
                        if (list == null) {
                            list = new ArrayList<VerrechnetCopy>();
                        }
                        list.add(copy);
                        elementsMap.put(null, list);
                    }
                }
            }
        });
        this.stornoViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof VerrechnetCopy) {
                    VerrechnetCopy vc = (VerrechnetCopy)element;
                    int amount = vc.getZahl();
                    Money price = vc.getNettoPreis();
                    price.multiply((double)amount);
                    return "  - " + amount + " " + vc.getLabel() + " (" + price.toString() + ")";
                }
                if (element instanceof Konsultation) {
                    return "Konsultation " + ((Konsultation)element).getDatum();
                }
                return element.toString();
            }
        });
        this.stornoViewer.setInput((Object)this);
        List<IViewContribution> filtered = ViewContributionHelper.getFilteredAndPositionSortedContributions(this.detailComposites, 0);
        for (IViewContribution ivc : filtered) {
            ExpandableComposite ec = WidgetFactory.createExpandableComposite(this.tk, this.form, ivc.getLocalizedTitle());
            ec.setLayoutData((Object)new GridData(4, 128, true, false));
            ec.addExpansionListener((IExpansionListener)ecExpansionListener);
            Composite mainComposite = new Composite((Composite)ec, 0);
            mainComposite.setLayoutData((Object)new GridData(4, 4, true, true));
            mainComposite.setLayout((Layout)new GridLayout(1, false));
            Composite ret = ivc.initComposite(mainComposite);
            this.tk.adapt(ret);
            ec.setClient((Control)ret);
        }
        GlobalEventDispatcher.addActivationListener(this, site.getPart());
    }

    private void saveExpandedState(String field, boolean state) {
        if (state) {
            CoreHub.userCfg.set("view/expandableComposites/states/" + field, "1");
        } else {
            CoreHub.userCfg.set("view/expandableComposites/states/" + field, "2");
        }
    }

    private void setExpandedState(ExpandableComposite ec, String field) {
        String mode = CoreHub.userCfg.get("view/expandableComposites/setting", "3");
        if (mode.equals("1")) {
            ec.setExpanded(true);
        } else if (mode.equals("2")) {
            ec.setExpanded(false);
        } else {
            String state = CoreHub.userCfg.get("view/expandableComposites/states/" + field, "2");
            if (state.equals("2")) {
                ec.setExpanded(false);
            } else {
                ec.setExpanded(true);
            }
        }
    }

    public void dispose() {
        GlobalEventDispatcher.removeActivationListener(this, this.site.getPart());
        super.dispose();
    }

    @Override
    public void activation(boolean mode) {
    }

    @Override
    public void visible(boolean mode) {
        if (mode) {
            ElexisEventDispatcher.getInstance().addListeners(new ElexisEventListener[]{this.eeli_rn, this.eeli_user, this.eeli_patient});
            Rechnung selected = (Rechnung)ElexisEventDispatcher.getSelected(Rechnung.class);
            if (selected != null) {
                this.doSelect(selected);
            }
        } else {
            ElexisEventDispatcher.getInstance().removeListeners(new ElexisEventListener[]{this.eeli_rn, this.eeli_user, this.eeli_patient});
        }
    }

    private void doSelect(Rechnung rn) {
        this.actRn = rn;
        UiDesk.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                RechnungsBlatt.this.display();
            }
        });
    }

    public void display() {
        this.rnform.reload((PersistentObject)this.actRn);
        this.lbJournal.removeAll();
        this.lbOutputs.removeAll();
        if (this.actRn != null) {
            Kontakt adressat = this.actRn.getFall().getInvoiceRecipient();
            this.rnAdressat.setText(String.valueOf(Messages.RechnungsBlatt_adressee) + (adressat != null ? adressat.getLabel() : ""));
            this.form.setText(this.actRn.getLabel());
            List trace = this.actRn.getTrace("Status\u00e4nderung");
            for (String s : trace) {
                String[] stm = s.split("\\s*:\\s");
                StringBuilder sb = new StringBuilder();
                sb.append(stm[0]).append(" : ").append(RnStatus.getStatusText((int)Integer.parseInt(stm[1])));
                this.lbJournal.add(sb.toString());
            }
            if (this.actRn.getStatus() == InvoiceState.DEFECTIVE.numericValue()) {
                List rejects = this.actRn.getTrace("Zur\u00fcckgewiesen");
                StringBuilder rjj = new StringBuilder();
                for (String r : rejects) {
                    rjj.append(r).append("\n------\n");
                }
                this.tRejects.setText(rjj.toString());
            } else {
                this.tRejects.setText("");
            }
            List outputs = this.actRn.getTrace("Ausgegeben");
            for (String o : outputs) {
                this.lbOutputs.add(o);
            }
            this.tBemerkungen.setText(this.actRn.getBemerkung());
        } else {
            this.rnAdressat.setText("");
            this.tRejects.setText("");
            this.form.setText(null);
        }
        this.buchungen.setInput((Object)this.actRn);
        this.konsultationenViewer.refresh();
        this.stornoViewer.refresh();
        this.detailComposites.forEach(dc -> dc.setDetailObject(this.actRn, null));
        this.setExpandedState(this.ecBuchungen, KEY_RECHNUNGSBLATT + this.ecBuchungen.getText());
        this.setExpandedState(this.ecBemerkungen, KEY_RECHNUNGSBLATT + this.ecBemerkungen.getText());
        this.setExpandedState(this.ecStatus, KEY_RECHNUNGSBLATT + this.ecStatus.getText());
        this.setExpandedState(this.ecFehler, KEY_RECHNUNGSBLATT + this.ecFehler.getText());
        this.setExpandedState(this.ecAusgaben, KEY_RECHNUNGSBLATT + this.ecAusgaben.getText());
        this.setExpandedState(this.ecKons, KEY_RECHNUNGSBLATT + this.ecKons.getText());
        this.setExpandedState(this.ecStorno, KEY_RECHNUNGSBLATT + this.ecStorno.getText());
        this.form.reflow(true);
    }
}

