/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.views.artikel;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.model.article.IArticle;
import ch.elexis.core.services.IStockService;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.util.viewers.DefaultLabelProvider;
import ch.elexis.data.Artikel;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;

public class ArtikelLabelProvider
extends DefaultLabelProvider
implements ITableColorProvider {
    @Override
    public Image getColumnImage(Object element, int columnIndex) {
        if (element instanceof Artikel) {
            return null;
        }
        return Images.IMG_ACHTUNG.getImage();
    }

    @Override
    public String getColumnText(Object element, int columnIndex) {
        if (element instanceof Artikel) {
            Artikel art = (Artikel)element;
            String ret = art.getInternalName();
            Integer amount = CoreHub.getStockService().getCumulatedStockForArticle((IArticle)art);
            if (amount != null) {
                ret = String.valueOf(ret) + " (" + Integer.toString(amount) + ")";
            }
            return ret;
        }
        return super.getColumnText(element, columnIndex);
    }

    public Color getForeground(Object element, int columnIndex) {
        if (element instanceof Artikel) {
            Artikel art = (Artikel)element;
            IStockService.Availability availability = CoreHub.getStockService().getCumulatedAvailabilityForArticle((IArticle)art);
            if (availability != null) {
                switch (availability) {
                    case CRITICAL_STOCK: 
                    case OUT_OF_STOCK: {
                        return UiDesk.getColor("rot");
                    }
                }
                return UiDesk.getColor("blau");
            }
        }
        return null;
    }

    public Color getBackground(Object element, int columnIndex) {
        return null;
    }
}

