/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.services;

import ch.elexis.core.services.ILocalDocumentService;
import ch.elexis.data.Brief;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.LoggerFactory;

@Component(service={})
public class LocalDocumentServiceHolder {
    private static Optional<ILocalDocumentService> localDocumentService;

    @Reference
    public void bind(ILocalDocumentService service) {
        localDocumentService = Optional.ofNullable(service);
        service.registerSaveHandler(Brief.class, new ILocalDocumentService.ISaveHandler(){

            public boolean save(Object documentSource, ILocalDocumentService service) {
                Brief brief = (Brief)documentSource;
                Optional content = service.getContent((Object)brief);
                if (content.isPresent()) {
                    try {
                        brief.save(IOUtils.toByteArray((InputStream)((InputStream)content.get())), brief.getMimeType());
                        return true;
                    }
                    catch (IOException e) {
                        LoggerFactory.getLogger(this.getClass()).error("Error saving document", (Throwable)e);
                    }
                    finally {
                        try {
                            ((InputStream)content.get()).close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                return false;
            }
        });
        service.registerLoadHandler(Brief.class, new ILocalDocumentService.ILoadHandler(){

            public InputStream load(Object documentSource) {
                Brief brief = (Brief)documentSource;
                try {
                    byte[] bytes = brief.loadBinary();
                    if (bytes != null) {
                        return new ByteArrayInputStream(bytes);
                    }
                    LoggerFactory.getLogger(this.getClass()).warn("Document is empty - id: " + brief.getId());
                    return new ByteArrayInputStream(new byte[0]);
                }
                catch (Exception e) {
                    LoggerFactory.getLogger(this.getClass()).error("Error loading document", (Throwable)e);
                    return null;
                }
            }
        });
    }

    public static void unbind(ILocalDocumentService service) {
        localDocumentService = Optional.empty();
    }

    public static Optional<ILocalDocumentService> getService() {
        return localDocumentService;
    }
}

