/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.selectors;

import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.selectors.ActiveControl;
import ch.elexis.core.ui.selectors.ActiveControlListener;
import ch.elexis.core.ui.selectors.ComboField;
import ch.elexis.core.ui.selectors.DateField;
import ch.elexis.core.ui.selectors.FieldDescriptor;
import ch.elexis.core.ui.selectors.IntegerField;
import ch.elexis.core.ui.selectors.Messages;
import ch.elexis.core.ui.selectors.MoneyField;
import ch.elexis.core.ui.selectors.TextField;
import ch.elexis.data.PersistentObject;
import ch.rgw.tools.LimitSizeStack;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.forms.widgets.ColumnLayout;

public class DisplayPanel
extends Composite
implements ActiveControlListener {
    private boolean bCeaseFire;
    private boolean bExclusive;
    private boolean bAutosave = false;
    private LinkedList<ActiveControlListener> listeners = new LinkedList();
    private LimitSizeStack<TraceElement> undoList = new LimitSizeStack(50);
    private Composite cFields;
    private ToolBarManager tActions;
    private ToolBar tb;
    private IAction aClr;
    private PersistentObject actObject;

    public DisplayPanel(Composite parent, FieldDescriptor<? extends PersistentObject>[] fields, int minCols, int maxCols, IAction ... actions) {
        super(parent, 0);
        this.setBackground(parent.getBackground());
        FormLayout layout = new FormLayout();
        layout.marginLeft = 0;
        layout.marginRight = 0;
        this.setLayout((Layout)layout);
        this.tActions = new ToolBarManager(8388928);
        this.aClr = new Action(Messages.SelectorPanel_clearFields){
            {
                this.setImageDescriptor(Images.IMG_CLEAR.getImageDescriptor());
            }

            public void run() {
            }
        };
        this.tActions.add(this.aClr);
        IAction[] iActionArray = actions;
        int n = actions.length;
        int n2 = 0;
        while (n2 < n) {
            IAction ac = iActionArray[n2];
            if (ac != null) {
                this.tActions.add(ac);
            } else {
                this.tActions.add((IContributionItem)new Separator());
            }
            ++n2;
        }
        this.tb = this.tActions.createControl((Composite)this);
        if (parent.getData("TEST_COMP_NAME") != null) {
            int idx = 0;
            while (idx < this.tb.getItemCount()) {
                this.tb.getItem(idx).setData("TEST_COMP_NAME", (Object)(parent.getData("TEST_COMP_NAME") + "_" + idx + "_tbi"));
                ++idx;
            }
        }
        FormData fdActions = new FormData();
        fdActions.top = new FormAttachment(0, 0);
        fdActions.right = new FormAttachment(100, 0);
        this.tb.setLayoutData((Object)fdActions);
        this.cFields = new Composite((Composite)this, 0);
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        this.cFields.setLayoutData((Object)fd);
        ColumnLayout cl = new ColumnLayout();
        cl.minNumColumns = minCols > 0 ? minCols : 1;
        cl.maxNumColumns = maxCols > minCols ? maxCols : minCols + 2;
        this.cFields.setLayout((Layout)cl);
        FieldDescriptor<? extends PersistentObject>[] fieldDescriptorArray = fields;
        int n3 = fields.length;
        int n4 = 0;
        while (n4 < n3) {
            FieldDescriptor<? extends PersistentObject> field = fieldDescriptorArray[n4];
            ActiveControl ac = null;
            switch (field.getFieldType()) {
                case STRING: 
                case HYPERLINK: {
                    ac = new TextField(this.cFields, 0, field.getLabel());
                    break;
                }
                case CURRENCY: {
                    ac = new MoneyField(this.cFields, 0, field.getLabel());
                    break;
                }
                case DATE: {
                    ac = new DateField(this.cFields, 0, field.getLabel());
                    break;
                }
                case COMBO: {
                    ac = new ComboField(this.cFields, 0, field.getLabel(), (String[])field.getExtension());
                    break;
                }
                case INT: {
                    ac = new IntegerField(this.cFields, 0, field.getLabel());
                }
            }
            if (ac != null) {
                ac.setData("fieldName", field.getFieldname());
                ac.setData("hashName", field.getHashname());
                this.addField(ac);
            }
            this.pack();
            ++n4;
        }
    }

    public void setObject(PersistentObject po) {
        this.actObject = po;
        List<ActiveControl> ctls = this.getControls();
        for (ActiveControl ac : ctls) {
            String field = ac.getProperty("fieldName");
            ac.setText(po.get(field));
        }
        this.layout();
    }

    public void setAutosave(boolean doSave) {
        this.bAutosave = doSave;
    }

    public void addField(ActiveControl ac) {
        ac.addListener(this);
    }

    public void addFields(ActiveControl ... activeControls) {
        ActiveControl last = null;
        ActiveControl[] activeControlArray = activeControls;
        int n = activeControls.length;
        int n2 = 0;
        while (n2 < n) {
            ActiveControl ac = activeControlArray[n2];
            ac.addListener(this);
            last = ac;
            ++n2;
        }
        if (this.tb.isReparentable() && last != null) {
            Composite ctl = last.getControllerComposite();
            ctl.setLayout((Layout)new FormLayout());
            this.tb.setParent(ctl);
        }
        this.layout();
    }

    @Override
    public void contentsChanged(ActiveControl ac) {
        if (ac != null) {
            new TraceElement(ac);
        }
        if (!this.bCeaseFire) {
            this.bCeaseFire = true;
            if (this.bAutosave && this.actObject != null && ac != null) {
                String field = ac.getProperty("fieldName");
                this.actObject.set(field, ac.getText());
            }
            for (ActiveControlListener lis : this.listeners) {
                lis.contentsChanged(ac);
            }
            this.bCeaseFire = false;
        }
    }

    @Override
    public void invalidContents(ActiveControl field) {
        this.aClr.setImageDescriptor(Images.IMG_ACHTUNG.getImageDescriptor());
        this.aClr.setToolTipText((String)field.getData("invalidContents"));
    }

    public void addSelectorListener(ActiveControlListener l) {
        this.listeners.add(l);
    }

    public void removeSelectorListener(ActiveControlListener l) {
        this.listeners.remove(l);
    }

    @Override
    public void titleClicked(ActiveControl field) {
        if (!this.bCeaseFire) {
            this.bCeaseFire = true;
            for (ActiveControlListener lis : this.listeners) {
                lis.titleClicked(field);
            }
            this.bCeaseFire = true;
        }
    }

    public List<ActiveControl> getControls() {
        LinkedList<ActiveControl> ret = new LinkedList<ActiveControl>();
        Control[] controlArray = this.cFields.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            if (c instanceof ActiveControl) {
                ActiveControl ac = (ActiveControl)c;
                ret.add(ac);
            }
            ++n2;
        }
        return ret;
    }

    private class TraceElement {
        ActiveControl control;
        String value;

        TraceElement(ActiveControl ac) {
            this.control = ac;
            this.value = ac.getText();
            DisplayPanel.this.undoList.push((Object)this);
        }
    }
}

