/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.exchange.elements;

import ch.elexis.core.model.IPersistentObject;
import ch.elexis.core.ui.exchange.KontaktMatcher;
import ch.elexis.core.ui.exchange.XChangeExporter;
import ch.elexis.core.ui.exchange.elements.AddressElement;
import ch.elexis.core.ui.exchange.elements.ContactRefElement;
import ch.elexis.core.ui.exchange.elements.MedicalElement;
import ch.elexis.core.ui.exchange.elements.Messages;
import ch.elexis.core.ui.exchange.elements.XChangeElement;
import ch.elexis.core.ui.exchange.elements.XidElement;
import ch.elexis.data.Kontakt;
import ch.elexis.data.Organisation;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Person;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.TimeTool;
import java.util.List;

public class ContactElement
extends XChangeElement {
    public static final String XMLNAME = "contact";
    public static final String ATTR_BIRTHDATE = "birthdate";
    public static final String ATTR_FIRSTNAME = "firstname";
    public static final String ATTR_MIDDLENAME = "middlename";
    public static final String ATTR_LASTNAME = "lastname";
    public static final String ATTR_SEX = "sex";
    public static final String ATTR_SALUTATION = "salutation";
    public static final String ATTR_TITLE = "title";
    public static final String ATTR_TYPE = "type";
    public static final String ATTR_SHORTNAME = "shortname";
    public static final String ELEM_XID = "xid";
    public static final String ELEM_ADDRESS = "address";
    public static final String VALUE_PERSON = "person";
    public static final String VALUE_ORGANIZATION = "organization";
    public static final String VALUE_MALE = "male";
    public static final String VALUE_FEMALE = "female";
    public static final String ATTR_REMARK = "remark";

    public void add(AddressElement ae) {
        super.add(ae);
    }

    public void add(ContactRefElement ce) {
        super.add(ce);
    }

    public void add(MedicalElement me) {
        super.add(me);
    }

    public List<AddressElement> getAddresses() {
        return this.getChildren(ELEM_ADDRESS, AddressElement.class);
    }

    public ContactElement asExporter(XChangeExporter parent, Kontakt k) {
        String bemerkung;
        this.asExporter(parent);
        XidElement eXid = new XidElement().asExporter(parent, k);
        this.add(eXid);
        if (k.istPerson()) {
            Person p = Person.load((String)k.getId());
            this.setAttribute(ATTR_TYPE, VALUE_PERSON);
            this.setAttribute(ATTR_LASTNAME, p.getName());
            this.setAttribute(ATTR_FIRSTNAME, p.getVorname());
            if (p.getGeschlecht().equals("m")) {
                this.setAttribute(ATTR_SEX, VALUE_MALE);
            } else {
                this.setAttribute(ATTR_SEX, VALUE_FEMALE);
            }
            String gebdat = p.getGeburtsdatum();
            if (!StringTool.isNothing((Object)gebdat)) {
                this.setAttribute(ATTR_BIRTHDATE, new TimeTool(gebdat).toString(6));
            }
        } else {
            this.setAttribute(ATTR_TYPE, VALUE_ORGANIZATION);
            this.setAttribute(ATTR_LASTNAME, k.getLabel());
        }
        if (!StringTool.isNothing((Object)(bemerkung = k.getBemerkung()))) {
            this.setAttribute(ATTR_REMARK, bemerkung);
        }
        this.add(new AddressElement().asExporter(parent, k.getAnschrift(), "default"));
        parent.getContainer().addMapping(this, (PersistentObject)k);
        return this;
    }

    public List<ContactRefElement> getAssociations() {
        List<? extends XChangeElement> ret = this.getChildren("connection", ContactRefElement.class);
        return ret;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Messages.ContactElement_Name).append(this.getAttr(ATTR_LASTNAME)).append("\n");
        sb.append(Messages.ContactElement_vorname).append(this.getAttr(ATTR_FIRSTNAME));
        String middle = this.getAttr(ATTR_MIDDLENAME);
        if (middle.length() > 0) {
            sb.append(" ").append(middle);
        }
        sb.append(Messages.ContactElement_gebdat);
        TimeTool geb = new TimeTool(this.getAttr(ATTR_BIRTHDATE));
        sb.append(geb.toString(4)).append("\n");
        sb.append("PID: ").append(this.getAttr("id")).append("\n\n");
        List<AddressElement> addresses = this.getAddresses();
        for (AddressElement adr : addresses) {
            sb.append(adr.toString()).append("\n");
        }
        return sb.toString();
    }

    @Override
    public String getXMLName() {
        return XMLNAME;
    }

    public PersistentObject doImport(PersistentObject context) {
        XidElement eXid = this.getXid();
        Object ret = null;
        if (eXid != null) {
            List<IPersistentObject> cands = eXid.findObject();
            if (cands.size() == 0) {
                AddressElement ae = null;
                List<AddressElement> lae = this.getAddresses();
                if (lae.size() > 0) {
                    if (lae.size() == 1) {
                        ae = lae.get(0);
                    } else {
                        for (AddressElement adr : lae) {
                            if (!adr.getAttr("description").equalsIgnoreCase("default")) continue;
                            ae = adr;
                            break;
                        }
                        if (ae == null) {
                            ae = lae.get(0);
                        }
                    }
                }
                String strasse = null;
                String plz = null;
                String ort = null;
                String natel = null;
                if (ae != null) {
                    strasse = ae.getAttr("street");
                    plz = ae.getAttr("zip");
                    ort = ae.getAttr("city");
                }
                if (this.getAttr(ATTR_TYPE).equalsIgnoreCase(VALUE_PERSON)) {
                    String s = this.getAttr(ATTR_SEX).equals(VALUE_MALE) ? "m" : "w";
                    ret = KontaktMatcher.findPerson(this.getAttr(ATTR_LASTNAME), this.getAttr(ATTR_FIRSTNAME), this.getAttr(ATTR_BIRTHDATE), s, strasse, plz, ort, natel, KontaktMatcher.CreateMode.CREATE);
                } else {
                    ret = KontaktMatcher.findOrganisation(this.getAttr(ATTR_LASTNAME), this.getAttr(ATTR_FIRSTNAME), strasse, plz, ort, KontaktMatcher.CreateMode.CREATE);
                }
            } else if (cands.size() == 1) {
                ret = this.getAttr(ATTR_TYPE).equalsIgnoreCase(VALUE_PERSON) ? Person.load((String)cands.get(0).getId()) : Organisation.load((String)cands.get(0).getId());
            }
            MedicalElement me = (MedicalElement)this.getChild("medical", MedicalElement.class);
            me.doImport((PersistentObject)ret);
        }
        return ret;
    }
}

