/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.ui.handler;

import ch.elexis.core.data.events.ElexisEvent;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.exceptions.ElexisException;
import ch.elexis.core.findings.IFinding;
import ch.elexis.core.findings.ui.util.FindingsUiUtil;
import ch.elexis.core.model.IPersistentObject;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.locks.AcquireLockBlockingUi;
import ch.elexis.core.ui.locks.ILockHandler;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

public class FindingDeleteHandler
extends AbstractHandler
implements IHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Object item;
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof StructuredSelection && !((StructuredSelection)selection).isEmpty() && (item = ((StructuredSelection)selection).getFirstElement()) instanceof IFinding) {
            final IFinding iFinding = (IFinding)item;
            AcquireLockBlockingUi.aquireAndRun((IPersistentObject)((IPersistentObject)iFinding), (ILockHandler)new ILockHandler(){

                public void lockFailed() {
                }

                public void lockAcquired() {
                    try {
                        FindingsUiUtil.deleteFinding(iFinding);
                    }
                    catch (ElexisException e) {
                        MessageDialog.openError((Shell)UiDesk.getDisplay().getActiveShell(), (String)"Fehler", (String)e.getMessage());
                    }
                    ElexisEventDispatcher.getInstance().fire(new ElexisEvent[]{new ElexisEvent((IPersistentObject)iFinding, IFinding.class, 2)});
                }
            });
        }
        return null;
    }
}

