/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.data.dto;

import ch.elexis.core.types.DocumentStatus;
import ch.elexis.data.Brief;
import ch.elexis.data.Kontakt;
import ch.elexis.data.dto.AbstractDocumentDTO;
import ch.elexis.data.dto.CategoryDocumentDTO;
import ch.elexis.data.dto.HistoryDocumentDTO;
import ch.rgw.tools.TimeTool;
import java.util.Date;
import org.apache.commons.lang.StringUtils;

public class BriefDocumentDTO
extends AbstractDocumentDTO {
    public BriefDocumentDTO(String storeId) {
        this.setStoreId(storeId);
    }

    public BriefDocumentDTO(Brief brief, String storeId) {
        this(storeId);
        String[] fetch = new String[]{"PatientID", "AbsenderID", "note", "Betreff", "MimeType", "DestID", "Typ"};
        String[] data = new String[fetch.length];
        brief.get(fetch, data);
        this.setId(brief.getId());
        this.setLabel(brief.getLabel());
        this.setPatientId(data[0]);
        this.setAuthorId(data[1]);
        this.setDescription(data[2]);
        this.setTitle(data[3]);
        this.setMimeType(data[4]);
        this.setLastchanged(new Date(Long.valueOf(brief.get("lastupdate"))));
        this.setCreated(new TimeTool(brief.get("Datum")).getTime());
        this.setExtension(this.evaluateExtension(data[4]));
        if (StringUtils.isNotEmpty((String)data[5])) {
            this.setStatus(DocumentStatus.SENT);
            Kontakt kontakt = Kontakt.load(data[5]);
            if (kontakt != null) {
                this.getHistory().add(new HistoryDocumentDTO(this.getLastchanged(), DocumentStatus.SENT, kontakt.getLabel()));
            }
        }
        this.setCategory(new CategoryDocumentDTO(data[6]));
    }
}

