/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.data.service.internal;

import ch.elexis.core.model.ICodeElement;
import ch.elexis.core.model.article.IArticle;
import ch.elexis.core.services.ICodeElementService;
import ch.elexis.core.services.ICodeElementServiceContribution;
import java.util.HashMap;
import java.util.Optional;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.slf4j.LoggerFactory;

@Component
public class CodeElementService
implements ICodeElementService {
    private HashMap<String, ICodeElementServiceContribution> contributions = new HashMap();

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    public void setCodeElementServiceContribution(ICodeElementServiceContribution contribution) {
        ICodeElementServiceContribution previous = this.contributions.put(contribution.getSystem(), contribution);
        if (previous != null) {
            LoggerFactory.getLogger(this.getClass()).warn("Possible ICodeElementServiceContribution collision previous [" + previous + "] new [" + contribution + "]");
        }
    }

    public void unsetCodeElementServiceContribution(ICodeElementServiceContribution store) {
        this.contributions.remove(store.getSystem());
    }

    public Optional<ICodeElement> createFromString(String system, String code, HashMap<Object, Object> context) {
        ICodeElementServiceContribution contribution = this.contributions.get(system);
        if (contribution != null) {
            return contribution.createFromCode(code, context);
        }
        LoggerFactory.getLogger(this.getClass()).warn("No ICodeElementServiceContribution for system [" + system + "] code [" + code + "]");
        return Optional.empty();
    }

    public Optional<IArticle> findArticleByGtin(String gtin) {
        for (ICodeElementServiceContribution contribution : this.contributions.values()) {
            Optional loadFromCode = contribution.createFromCode(gtin, null);
            if (!loadFromCode.isPresent()) continue;
            if (loadFromCode.get() instanceof IArticle) {
                return loadFromCode.map(IArticle.class::cast);
            }
            LoggerFactory.getLogger(this.getClass()).warn("Found article for gtin [{}] but is not castable to IArticle [{}]", (Object)gtin, (Object)((ICodeElement)loadFromCode.get()).getClass().getName());
        }
        return Optional.empty();
    }
}

