/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.data.lock;

import ch.elexis.core.common.InstanceStatus;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.ElexisEvent;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.server.ElexisServerInstanceService;
import ch.elexis.core.data.server.ElexisServerLockService;
import ch.elexis.core.data.status.ElexisStatus;
import ch.elexis.core.lock.ILocalLockService;
import ch.elexis.core.lock.types.LockInfo;
import ch.elexis.core.lock.types.LockRequest;
import ch.elexis.core.lock.types.LockResponse;
import ch.elexis.core.model.IPersistentObject;
import ch.elexis.core.server.IInstanceService;
import ch.elexis.core.server.ILockService;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.User;
import com.eclipsesource.jaxrs.consumer.ConsumerFactory;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import org.eclipse.core.runtime.IProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalLockService
implements ILocalLockService {
    private ILockService ils;
    private IInstanceService iis;
    private InstanceStatus inst;
    private final HashMap<String, Integer> lockCount = new HashMap();
    private final HashMap<String, LockInfo> locks = new HashMap();
    private boolean standalone = false;
    private Logger logger = LoggerFactory.getLogger(LocalLockService.class);
    private static final UUID systemUuid = UUID.randomUUID();
    private Timer timer;

    public LocalLockService() {
        this.ils = new DenyAllLockService();
        this.timer = new Timer();
        this.timer.schedule((TimerTask)new LockRefreshTask(), 10000L, 10000L);
        this.inst = new InstanceStatus();
        this.inst.setState(InstanceStatus.STATE.ACTIVE);
        this.inst.setUuid(this.getSystemUuid());
        this.inst.setVersion(CoreHub.readElexisBuildVersion());
        this.inst.setOperatingSystem(String.valueOf(System.getProperty("os.name")) + "/" + System.getProperty("os.version") + "/" + System.getProperty("os.arch") + "/J" + System.getProperty("java.version"));
    }

    public void reconfigure() {
        String restUrl = System.getProperty("elexisServerUrl");
        if (restUrl != null && restUrl.length() > 0) {
            this.standalone = false;
            this.logger.info("Operating against elexis-server instance on " + restUrl);
            this.ils = new ElexisServerLockService(restUrl);
            this.iis = new ElexisServerInstanceService(restUrl);
            String identId = CoreHub.localCfg.get("station/identId", "");
            String identTxt = CoreHub.localCfg.get("station/identText", "");
            this.inst.setIdentifier(String.valueOf(identTxt) + " [" + identId + "]");
        } else {
            this.standalone = true;
            this.logger.info("Operating in stand-alone mode.");
        }
    }

    public LockResponse releaseAllLocks() {
        if (this.standalone) {
            return LockResponse.OK;
        }
        ArrayList<LockInfo> lockList = new ArrayList<LockInfo>(this.locks.values());
        for (LockInfo lockInfo : lockList) {
            LockRequest lockRequest = new LockRequest(LockRequest.Type.RELEASE, lockInfo);
            LockResponse lr = this.acquireOrReleaseLocks(lockRequest);
            if (lr.isOk()) continue;
            return lr;
        }
        return LockResponse.OK;
    }

    public LockResponse releaseLock(IPersistentObject po) {
        if (po == null) {
            return LockResponse.DENIED(null);
        }
        this.logger.debug("Releasing lock on [" + po + "]");
        return this.releaseLock(po.storeToString());
    }

    public LockResponse releaseLock(LockInfo lockInfo) {
        if (lockInfo.getElementStoreToString() == null) {
            return LockResponse.DENIED(null);
        }
        this.logger.debug("Releasing lock on [" + lockInfo.getElementStoreToString() + "]");
        return this.releaseLock(lockInfo.getElementStoreToString());
    }

    private LockResponse releaseLock(String storeToString) {
        User user = (User)ElexisEventDispatcher.getSelected(User.class);
        LockInfo lil = new LockInfo(storeToString, user.getId(), systemUuid.toString());
        LockRequest lockRequest = new LockRequest(LockRequest.Type.RELEASE, lil);
        return this.acquireOrReleaseLocks(lockRequest);
    }

    public LockResponse acquireLockBlocking(IPersistentObject po, int secTimeout, IProgressMonitor monitor) {
        if (po == null) {
            return LockResponse.DENIED(null);
        }
        if (monitor != null) {
            monitor.beginTask("Acquiring Lock for [" + po.getLabel() + "]", secTimeout * 10 + 1);
        }
        this.logger.debug("Acquiring lock blocking on [" + po + "]");
        String storeToString = po.storeToString();
        LockResponse response = this.acquireLock(storeToString);
        int sleptMilli = 0;
        while (!response.isOk()) {
            if (response.getStatus() == LockResponse.Status.DENIED_PERMANENT) {
                return response;
            }
            try {
                Thread.sleep(100L);
                response = this.acquireLock(storeToString);
                if ((sleptMilli += 100) > secTimeout * 1000) {
                    return response;
                }
                if (monitor == null) continue;
                monitor.worked(1);
                if (!monitor.isCanceled()) continue;
                return LockResponse.DENIED((LockInfo)response.getLockInfo());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return response;
    }

    public LockResponse acquireLock(IPersistentObject po) {
        if (po == null) {
            return LockResponse.DENIED(null);
        }
        this.logger.debug("Acquiring lock on [" + po + "]");
        LockResponse lr = this.acquireLock(po.storeToString());
        if (lr.getStatus() == LockResponse.Status.ERROR) {
            this.logger.warn("LockResponse ERROR");
        }
        return lr;
    }

    private LockResponse acquireLock(String storeToString) {
        if (storeToString == null) {
            return LockResponse.DENIED(null);
        }
        User user = (User)ElexisEventDispatcher.getSelected(User.class);
        LockInfo lockInfo = new LockInfo(storeToString, user.getId(), systemUuid.toString());
        LockRequest lockRequest = new LockRequest(LockRequest.Type.ACQUIRE, lockInfo);
        return this.acquireOrReleaseLocks(lockRequest);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public LockResponse acquireOrReleaseLocks(LockRequest lockRequest) {
        if (this.standalone) {
            return LockResponse.OK((LockInfo)lockRequest.getLockInfo());
        }
        if (this.ils == null) {
            String message = "System not configured for standalone mode, and elexis-server not available!";
            this.logger.error(message);
            ElexisEventDispatcher.fireElexisStatusEvent(new ElexisStatus(4, "ch.elexis.core.data", 0, message, null));
            return new LockResponse(LockResponse.Status.ERROR, lockRequest.getLockInfo());
        }
        LockInfo lockInfo = lockRequest.getLockInfo();
        HashMap<String, LockInfo> hashMap = this.locks;
        synchronized (hashMap) {
            LockResponse lockResponse;
            LockResponse lr;
            block23: {
                PersistentObject po;
                if (LockRequest.Type.ACQUIRE == lockRequest.getRequestType() && this.locks.keySet().contains(lockInfo.getElementId())) {
                    this.incrementLockCount(lockInfo);
                    return LockResponse.OK((LockInfo)lockRequest.getLockInfo());
                }
                if (LockRequest.Type.RELEASE == lockRequest.getRequestType() && this.getCurrentLockCount(lockInfo) > 1) {
                    this.decrementLockCount(lockInfo);
                    return LockResponse.OK((LockInfo)lockRequest.getLockInfo());
                }
                if (LockRequest.Type.RELEASE == lockRequest.getRequestType() && (po = CoreHub.poFactory.createFromString(lockInfo.getElementStoreToString())) != null) {
                    ElexisEventDispatcher.getInstance().fire(new ElexisEvent((Object)po, po.getClass(), 8192, 1));
                }
                if ((lr = this.ils.acquireOrReleaseLocks(lockRequest)).isOk()) break block23;
                LockResponse lockResponse2 = lr;
                if (LockRequest.Type.RELEASE.equals((Object)lockRequest.getRequestType())) {
                    this.decrementLockCount(lockInfo);
                    this.locks.remove(lockInfo.getElementId());
                    PersistentObject po2 = CoreHub.poFactory.createFromString(lockInfo.getElementStoreToString());
                    if (po2 != null) {
                        ElexisEventDispatcher.getInstance().fire(new ElexisEvent(po2, po2.getClass(), 16384));
                    }
                }
                return lockResponse2;
            }
            try {
                if (LockRequest.Type.ACQUIRE == lockRequest.getRequestType()) {
                    this.locks.put(lockInfo.getElementId(), lockInfo);
                    this.incrementLockCount(lockInfo);
                    PersistentObject po = CoreHub.poFactory.createFromString(lockInfo.getElementStoreToString());
                    if (po != null) {
                        ElexisEventDispatcher.getInstance().fire(new ElexisEvent(po, po.getClass(), 4096));
                    }
                }
                lockResponse = lr;
            }
            catch (Exception e) {
                LockResponse lockResponse2;
                try {
                    String message = "Error trying to acquireOrReleaseLocks.";
                    this.logger.error(message);
                    ElexisEventDispatcher.fireElexisStatusEvent(new ElexisStatus(4, "ch.elexis.core.data", 0, message, e));
                    lockResponse2 = new LockResponse(LockResponse.Status.ERROR, lockRequest.getLockInfo());
                }
                catch (Throwable throwable) {
                    if (LockRequest.Type.RELEASE.equals((Object)lockRequest.getRequestType())) {
                        this.decrementLockCount(lockInfo);
                        this.locks.remove(lockInfo.getElementId());
                        PersistentObject po = CoreHub.poFactory.createFromString(lockInfo.getElementStoreToString());
                        if (po != null) {
                            ElexisEventDispatcher.getInstance().fire(new ElexisEvent(po, po.getClass(), 16384));
                        }
                    }
                    throw throwable;
                }
                if (LockRequest.Type.RELEASE.equals((Object)lockRequest.getRequestType())) {
                    this.decrementLockCount(lockInfo);
                    this.locks.remove(lockInfo.getElementId());
                    PersistentObject po = CoreHub.poFactory.createFromString(lockInfo.getElementStoreToString());
                    if (po != null) {
                        ElexisEventDispatcher.getInstance().fire(new ElexisEvent(po, po.getClass(), 16384));
                    }
                }
                return lockResponse2;
            }
            if (LockRequest.Type.RELEASE.equals((Object)lockRequest.getRequestType())) {
                this.decrementLockCount(lockInfo);
                this.locks.remove(lockInfo.getElementId());
                PersistentObject po = CoreHub.poFactory.createFromString(lockInfo.getElementStoreToString());
                if (po != null) {
                    ElexisEventDispatcher.getInstance().fire(new ElexisEvent(po, po.getClass(), 16384));
                }
            }
            return lockResponse;
        }
    }

    private void incrementLockCount(LockInfo lockInfo) {
        Integer count = this.lockCount.get(lockInfo.getElementId());
        if (count == null) {
            count = new Integer(0);
        }
        count = count + 1;
        this.lockCount.put(lockInfo.getElementId(), count);
        this.logger.debug("Increment to " + count + " locks on " + lockInfo.getElementId());
    }

    private void decrementLockCount(LockInfo lockInfo) {
        Integer count = this.lockCount.get(lockInfo.getElementId());
        if (count != null) {
            count = count - 1;
            this.lockCount.put(lockInfo.getElementId(), count);
            this.logger.debug("Decrement to " + count + " locks on " + lockInfo.getElementId());
            if (count < 1) {
                this.lockCount.remove(lockInfo.getElementId());
            }
        }
    }

    private Integer getCurrentLockCount(LockInfo lockInfo) {
        Integer count = this.lockCount.get(lockInfo.getElementId());
        if (count == null) {
            count = new Integer(0);
        }
        this.logger.debug("Got currently " + count + " locks on " + lockInfo.getElementId());
        return count;
    }

    public boolean isLockedLocal(IPersistentObject po) {
        if (po == null) {
            return false;
        }
        if (this.standalone) {
            return true;
        }
        return this.locks.containsKey(po.getId());
    }

    public boolean isLocked(IPersistentObject po) {
        if (po == null) {
            return false;
        }
        this.logger.debug("Checking lock on [" + po + "]");
        User user = (User)ElexisEventDispatcher.getSelected(User.class);
        LockInfo lockInfo = new LockInfo(po.storeToString(), user.getId(), systemUuid.toString());
        LockRequest lockRequest = new LockRequest(LockRequest.Type.INFO, lockInfo);
        return this.isLocked(lockRequest);
    }

    public boolean isLocked(LockRequest lockRequest) {
        if (lockRequest == null || lockRequest.getLockInfo().getElementId() == null) {
            return false;
        }
        if (this.standalone) {
            return true;
        }
        if (this.locks.containsKey(lockRequest.getLockInfo().getElementId())) {
            return true;
        }
        try {
            return this.ils.isLocked(lockRequest);
        }
        catch (Exception e) {
            this.logger.error("Catched exception in isLocked: ", (Throwable)e);
            return false;
        }
    }

    public List<LockInfo> getCopyOfAllHeldLocks() {
        Collection<LockInfo> values = this.locks.values();
        if (values.size() == 0) {
            return Collections.emptyList();
        }
        return new ArrayList<LockInfo>(values);
    }

    public String getSystemUuid() {
        return systemUuid.toString();
    }

    public LockInfo getLockInfo(String storeToString) {
        String elementId = LockInfo.getElementId((String)storeToString);
        LockInfo lockInfo = this.locks.get(elementId);
        return lockInfo;
    }

    public ILocalLockService.Status getStatus() {
        if (this.standalone) {
            return ILocalLockService.Status.STANDALONE;
        }
        if (this.ils == null || this.ils instanceof DenyAllLockService) {
            return ILocalLockService.Status.LOCAL;
        }
        return ILocalLockService.Status.REMOTE;
    }

    public void shutdown() {
        this.timer.cancel();
        if (this.iis != null) {
            this.inst.setState(InstanceStatus.STATE.SHUTTING_DOWN);
            this.iis.updateStatus(this.inst);
        }
    }

    private class DenyAllLockService
    implements ILockService {
        private DenyAllLockService() {
        }

        public LockResponse acquireOrReleaseLocks(LockRequest request) {
            return LockResponse.DENIED((LockInfo)this.getLockInfo(request.getLockInfo().getElementStoreToString()));
        }

        public boolean isLocked(LockRequest request) {
            return false;
        }

        public LockInfo getLockInfo(String storeToString) {
            return new LockInfo(storeToString, "LockService", "DenyAllLockService");
        }
    }

    private class LockRefreshTask
    extends TimerTask {
        private ILockService restService;

        private LockRefreshTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                String restUrl = System.getProperty("elexisServerUrl");
                if (restUrl != null && !restUrl.isEmpty()) {
                    String testRestUrl = String.valueOf(restUrl) + "/elexis/lockservice/lockInfo";
                    if (this.testRestUrl(testRestUrl) && LocalLockService.this.ils instanceof DenyAllLockService && this.restService != null) {
                        LocalLockService.this.ils = this.restService;
                        LocalLockService.this.iis = (IInstanceService)ConsumerFactory.createConsumer((String)restUrl, IInstanceService.class);
                        ElexisEventDispatcher.getInstance().fire(new ElexisEvent(null, ILocalLockService.class, 8));
                    } else if (!this.testRestUrl(testRestUrl) && !(LocalLockService.this.ils instanceof DenyAllLockService)) {
                        this.restService = LocalLockService.this.ils;
                        LocalLockService.this.iis = null;
                        LocalLockService.this.ils = new DenyAllLockService();
                        ElexisEventDispatcher.getInstance().fire(new ElexisEvent(null, ILocalLockService.class, 8));
                    }
                }
                if (LocalLockService.this.standalone) {
                    return;
                }
                if (LocalLockService.this.iis != null) {
                    User u = (User)ElexisEventDispatcher.getSelected(User.class);
                    LocalLockService.this.inst.setActiveUser(u != null ? u.getId() : "NO USER ACTIVE");
                    LocalLockService.this.iis.updateStatus(LocalLockService.this.inst);
                }
                boolean publishUpdate = false;
                HashMap hashMap = LocalLockService.this.locks;
                synchronized (hashMap) {
                    ArrayList lockKeys = new ArrayList();
                    lockKeys.addAll(LocalLockService.this.locks.keySet());
                    for (String key : lockKeys) {
                        boolean success = LocalLockService.this.ils.isLocked(new LockRequest(LockRequest.Type.INFO, (LockInfo)LocalLockService.this.locks.get(key)));
                        if (success) continue;
                        publishUpdate = true;
                        LocalLockService.this.releaseLock(((LockInfo)LocalLockService.this.locks.get(key)).getElementStoreToString());
                    }
                }
                if (publishUpdate) {
                    ElexisEventDispatcher.getInstance().fire(new ElexisEvent(null, LockInfo.class, 8));
                }
            }
            catch (Exception e) {
                LoggerFactory.getLogger(LockRefreshTask.class).error("Execution error", (Throwable)e);
            }
        }

        private boolean testRestUrl(String restUrl) {
            try {
                URL url = new URL(restUrl);
                HttpURLConnection urlConn = (HttpURLConnection)url.openConnection();
                urlConn.connect();
                return urlConn.getResponseCode() >= 200 && urlConn.getResponseCode() < 300;
            }
            catch (IOException e) {
                return false;
            }
        }
    }
}

