/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.data.beans;

import ch.elexis.core.data.beans.base.BeanPersistentObject;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.IPerson;
import ch.elexis.core.model.IUser;
import ch.elexis.core.types.ContactType;
import ch.elexis.core.types.Country;
import ch.elexis.core.types.Gender;
import ch.elexis.data.Kontakt;
import ch.elexis.data.Labor;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.rgw.tools.TimeTool;

public class ContactBean
extends BeanPersistentObject<Kontakt>
implements IContact,
IPerson,
IPatient,
IUser {
    private ContactCache cache = new ContactCache();

    public ContactBean(Kontakt kontakt) {
        super(kontakt);
    }

    public Patient getAsPatientEntity() {
        return (Patient)this.entity;
    }

    public Labor getAsLaboratoryEntity() {
        return (Labor)this.entity;
    }

    @Override
    protected void updateCache() {
        this.cache = new ContactCache();
    }

    public ContactType getContactType() {
        if (this.cache.isOrganization) {
            return ContactType.ORGANIZATION;
        }
        if (this.cache.isPatient || this.cache.isPerson) {
            return ContactType.PERSON;
        }
        return ContactType.UNKNOWN;
    }

    public void setContactType(ContactType type) {
        ContactType old = this.getContactType();
        switch (type) {
            case PERSON: {
                ((Kontakt)this.entity).set("istPerson", "1");
                ((Kontakt)this.entity).set("istOrganisation", "0");
                break;
            }
            case ORGANIZATION: {
                ((Kontakt)this.entity).set("istOrganisation", "1");
                ((Kontakt)this.entity).set("istPerson", "0");
                break;
            }
            case UNKNOWN: {
                ((Kontakt)this.entity).set("istOrganisation", "0");
                ((Kontakt)this.entity).set("istPerson", "0");
                break;
            }
        }
        this.firePropertyChange("contactType", old, type);
    }

    public String getDescription1() {
        return this.cache.description1;
    }

    public void setDescription1(String description) {
        String old = this.getDescription1();
        ((Kontakt)this.entity).set("Bezeichnung1", description);
        this.firePropertyChange("description1", old, description);
    }

    public String getDescription2() {
        return this.cache.description2;
    }

    public void setDescription2(String description) {
        String old = this.getDescription2();
        ((Kontakt)this.entity).set("Bezeichnung2", description);
        this.firePropertyChange("description2", old, description);
    }

    public String getDescription3() {
        return this.cache.description3;
    }

    public void setDescription3(String description) {
        String old = this.getDescription3();
        ((Kontakt)this.entity).set("Bezeichnung3", description);
        this.firePropertyChange("description3", old, description);
    }

    public String getZip() {
        return ((Kontakt)this.entity).get("Plz");
    }

    public void setZip(String zip) {
        String old = this.getZip();
        ((Kontakt)this.entity).set("Plz", zip);
        this.firePropertyChange("zip", old, zip);
    }

    public String getCity() {
        return ((Kontakt)this.entity).get("Ort");
    }

    public void setCity(String city) {
        String old = this.getCity();
        ((Kontakt)this.entity).set("Ort", city);
        this.firePropertyChange("city", old, city);
    }

    public String getStreet() {
        return ((Kontakt)this.entity).get("Strasse");
    }

    public void setStreet(String street) {
        String old = this.getStreet();
        ((Kontakt)this.entity).set("Strasse", street);
        this.firePropertyChange("street", old, street);
    }

    public String getPhone1() {
        return ((Kontakt)this.entity).get("Telefon1");
    }

    public void setPhone1(String phone) {
        String old = this.getPhone1();
        ((Kontakt)this.entity).set("Telefon1", phone);
        this.firePropertyChange("phone1", old, phone);
    }

    public String getPhone2() {
        return ((Kontakt)this.entity).get("Telefon2");
    }

    public void setPhone2(String phone) {
        String old = this.getPhone2();
        ((Kontakt)this.entity).set("Telefon2", phone);
        this.firePropertyChange("phone2", old, phone);
    }

    public String getFax() {
        return ((Kontakt)this.entity).get("Fax");
    }

    public void setFax(String fax) {
        String old = this.getFax();
        ((Kontakt)this.entity).set("Fax", fax);
        this.firePropertyChange("fax", old, fax);
    }

    public String getEmail() {
        return ((Kontakt)this.entity).get("E-Mail");
    }

    public void setEmail(String email) {
        String old = this.getEmail();
        ((Kontakt)this.entity).set("E-Mail", email);
        this.firePropertyChange("email", old, email);
    }

    public String getWebsite() {
        return ((Kontakt)this.entity).get("Website");
    }

    public void setWebsite(String website) {
        String old = this.getWebsite();
        ((Kontakt)this.entity).set("Website", website);
        this.firePropertyChange("website", old, website);
    }

    public String getMobile() {
        return ((Kontakt)this.entity).get("NatelNr");
    }

    public void setMobile(String mobile) {
        String old = this.getMobile();
        ((Kontakt)this.entity).set("NatelNr", mobile);
        this.firePropertyChange("mobile", old, mobile);
    }

    public String getComment() {
        return ((Kontakt)this.entity).getBemerkung();
    }

    public void setComment(String comment) {
        String old = this.getComment();
        ((Kontakt)this.entity).setBemerkung(comment);
        this.firePropertyChange("comment", old, comment);
    }

    public String getId() {
        return ((Kontakt)this.entity).getId();
    }

    public String getLabel() {
        return String.valueOf(this.getDescription1()) + " " + this.getDescription2() + ", " + this.getStreet() + ", " + this.getZip() + " " + this.getCity();
    }

    public boolean isMandator() {
        return this.cache.isMandator;
    }

    public void setMandator(boolean value) {
        boolean old = this.isMandator();
        ((Kontakt)this.entity).set("istMandant", value ? "1" : "0");
        this.firePropertyChange("mandator", old, value);
    }

    public boolean isUser() {
        return this.cache.isUser;
    }

    public void setUser(boolean value) {
        boolean old = this.isUser();
        ((Kontakt)this.entity).set("istAnwender", value ? "1" : "0");
        this.firePropertyChange("user", old, value);
    }

    public boolean isPatient() {
        return this.cache.isPatient;
    }

    public void setPatient(boolean value) {
        boolean old = this.isPatient();
        ((Kontakt)this.entity).set("istPatient", value ? "1" : "0");
        this.firePropertyChange("patient", old, value);
    }

    public String getCode() {
        return this.cache.code;
    }

    public void setCode(String value) {
        String old = this.getCode();
        ((Kontakt)this.entity).set("PatientNr", value);
        this.firePropertyChange("code", old, value);
    }

    public Country getCountry() {
        Country ret;
        String countryVal = ((Kontakt)this.entity).get("Land");
        try {
            ret = Country.fromValue((String)countryVal);
        }
        catch (IllegalArgumentException | NullPointerException e) {
            ret = Country.NDF;
        }
        return ret;
    }

    public void setCountry(Country value) {
        Country old = this.getCountry();
        ((Kontakt)this.entity).set("Land", value.value());
        this.firePropertyChange("country", old, value);
    }

    public boolean isDeleted() {
        return this.cache.isDeleted;
    }

    public void setDeleted(boolean value) {
        boolean old = this.isDeleted();
        ((Kontakt)this.entity).delete();
        this.firePropertyChange("deleted", old, value);
    }

    public TimeTool getDateOfBirth() {
        return this.cache.dateOfBirth;
    }

    public void setDateOfBirth(TimeTool value) {
        TimeTool old = this.getDateOfBirth();
        ((Kontakt)this.entity).set("Geburtsdatum", value.toString(9));
        this.firePropertyChange("dateOfBirth", old, value);
    }

    public Gender getGender() {
        return this.cache.sex;
    }

    public void setGender(Gender value) {
        String vs;
        Gender old = this.getGender();
        switch (value) {
            case MALE: {
                vs = "m";
                break;
            }
            case FEMALE: {
                vs = "w";
                break;
            }
            case UNDEFINED: {
                vs = "u";
                break;
            }
            default: {
                vs = "";
            }
        }
        ((Kontakt)this.entity).set("Geschlecht", vs);
        this.firePropertyChange("gender", old, value);
    }

    public String getTitel() {
        return this.cache.titel;
    }

    public void setTitel(String value) {
        String old = this.getTitel();
        ((Kontakt)this.entity).set("Titel", value);
        this.firePropertyChange("titel", old, value);
    }

    public String getTitelSuffix() {
        return this.cache.titelSuffix;
    }

    public void setTitelSuffix(String value) {
        String old = this.getTitel();
        ((Kontakt)this.entity).set("TitelSuffix", value);
        this.firePropertyChange("titelSuffix", old, value);
    }

    public String getDiagnosen() {
        return null;
    }

    public void setDiagnosen(String value) {
    }

    public String getRisk() {
        return null;
    }

    public void setRisk(String value) {
    }

    public String getFamilyAnamnese() {
        return null;
    }

    public void setFamilyAnamnese(String value) {
    }

    public String getPersonalAnamnese() {
        return null;
    }

    public void setPersonalAnamnese(String value) {
    }

    public String getAllergies() {
        return null;
    }

    public void setAllergies(String value) {
    }

    public String getPatientLabel() {
        return null;
    }

    public String getPatientNr() {
        return this.getCode();
    }

    public void setPatientNr(String value) {
        this.setCode(value);
    }

    public String getUsername() {
        return this.cache.description3;
    }

    public void setUsername(String value) {
        String old = this.getUsername();
        ((Kontakt)this.entity).set("Bezeichnung3", value);
        this.firePropertyChange("username", old, value);
    }

    public String getPassword() {
        return null;
    }

    public void setPassword(String value) {
    }

    public String getFirstName() {
        return this.getDescription2();
    }

    public String getFamilyName() {
        return this.getDescription1();
    }

    private class ContactCache {
        boolean isDeleted;
        boolean isPerson;
        boolean isOrganization;
        boolean isMandator;
        boolean isUser;
        boolean isPatient;
        String code;
        String description1;
        String description2;
        String description3;
        String titel;
        String titelSuffix;
        TimeTool dateOfBirth;
        Gender sex;

        public ContactCache() {
            if (PersistentObject.map("KONTAKT", "PatientNr").startsWith("**ERROR:")) {
                Patient.load("0");
            }
            String[] labels = new String[14];
            ((Kontakt)ContactBean.this.entity).get(new String[]{"deleted", "istPerson", "istOrganisation", "istMandant", "istAnwender", "istPatient", "Bezeichnung1", "Bezeichnung2", "Bezeichnung3", "Geburtsdatum", "Geschlecht", "PatientNr", "Titel", "TitelSuffix"}, labels);
            this.isDeleted = labels[0].equals("1");
            this.isPerson = labels[1].equals("1");
            this.isOrganization = labels[2].equals("1");
            this.isMandator = labels[3].equals("1");
            this.isUser = labels[4].equals("1");
            this.isPatient = labels[5].equals("1");
            this.description1 = labels[6];
            this.description2 = labels[7];
            this.description3 = labels[8];
            this.dateOfBirth = new TimeTool(labels[9]);
            this.sex = this.switchSex(labels[10]);
            this.code = labels[11];
            this.titel = labels[12];
            this.titelSuffix = labels[13];
        }

        private Gender switchSex(String labels) {
            if (labels == null || labels.length() < 1) {
                return Gender.UNKNOWN;
            }
            switch (labels.toLowerCase().charAt(0)) {
                case 'w': {
                    return Gender.FEMALE;
                }
                case 'f': {
                    return Gender.FEMALE;
                }
                case 'u': {
                    return Gender.UNDEFINED;
                }
                case 'm': {
                    return Gender.MALE;
                }
            }
            return Gender.UNKNOWN;
        }
    }
}

