/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.laboratory.controls.util;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.model.IPersistentObject;
import ch.elexis.core.types.LabItemTyp;
import ch.elexis.core.ui.laboratory.controls.LaborResultsComposite;
import ch.elexis.core.ui.laboratory.controls.Messages;
import ch.elexis.core.ui.laboratory.controls.model.LaborItemResults;
import ch.elexis.core.ui.locks.AcquireLockBlockingUi;
import ch.elexis.core.ui.locks.ILockHandler;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Kontakt;
import ch.elexis.data.LabItem;
import ch.elexis.data.LabOrder;
import ch.elexis.data.LabResult;
import ch.elexis.data.Mandant;
import ch.elexis.data.Patient;
import ch.rgw.tools.TimeTool;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.FocusCellHighlighter;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SWTFocusCellManager;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.TreeViewerEditor;
import org.eclipse.jface.viewers.TreeViewerFocusCellManager;
import org.eclipse.jface.viewers.ViewerRow;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class LabResultEditingSupport
extends EditingSupport {
    protected final String SMALLER = "<";
    protected final String BIGGER = ">";
    protected TextCellEditor textCellEditor;
    protected TreeViewerFocusCellManager focusCell;
    private TreeViewerColumn column;
    private LaborResultsComposite composite;

    public LabResultEditingSupport(LaborResultsComposite laborResultsComposite, TreeViewer viewer, TreeViewerColumn column) {
        super((ColumnViewer)viewer);
        this.column = column;
        this.composite = laborResultsComposite;
        this.setUpCellEditor((ColumnViewer)viewer);
        this.addValidator();
    }

    protected void setUpCellEditor(ColumnViewer viewer) {
        this.textCellEditor = new TextCellEditor((Composite)viewer.getControl());
        this.textCellEditor.addListener(new ICellEditorListener(){

            public void editorValueChanged(boolean oldValidState, boolean newValidState) {
                if (newValidState) {
                    LabResultEditingSupport.this.textCellEditor.getControl().setBackground(Display.getCurrent().getSystemColor(1));
                } else {
                    LabResultEditingSupport.this.textCellEditor.getControl().setBackground(Display.getCurrent().getSystemColor(3));
                }
            }

            public void cancelEditor() {
                LabResultEditingSupport.this.textCellEditor.getControl().setBackground(Display.getCurrent().getSystemColor(1));
            }

            public void applyEditorValue() {
                LabResultEditingSupport.this.textCellEditor.getControl().setBackground(Display.getCurrent().getSystemColor(1));
            }
        });
        this.focusCell = new TreeViewerFocusCellManager((TreeViewer)viewer, new FocusCellHighlighter(viewer){});
        ColumnViewerEditorActivationStrategy actSupport = new ColumnViewerEditorActivationStrategy(viewer){

            protected boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
                return event.eventType == 5 || event.eventType == 3 || event.eventType == 1 && event.keyCode == 13 || event.eventType == 1 && event.keyCode == 0x1000050 || event.eventType == 4;
            }
        };
        TreeViewerEditor.create((TreeViewer)((TreeViewer)viewer), (SWTFocusCellManager)this.focusCell, (ColumnViewerEditorActivationStrategy)actSupport, (int)40);
    }

    protected void addValidator() {
        this.textCellEditor.setValidator(new ICellEditorValidator(){

            public String isValid(Object value) {
                IStructuredSelection selection = (IStructuredSelection)LabResultEditingSupport.this.getViewer().getSelection();
                LaborItemResults results = (LaborItemResults)selection.getFirstElement();
                if (results != null && value instanceof String && (results.getLabItem().getTyp() == LabItemTyp.NUMERIC || results.getLabItem().getTyp() == LabItemTyp.ABSOLUTE)) {
                    try {
                        String editedValue = (String)value;
                        if (editedValue.startsWith("<") || editedValue.startsWith(">")) {
                            String nrValue = editedValue.replace("<", "").replace(">", "");
                            editedValue = nrValue.trim();
                        }
                        Float.parseFloat(editedValue);
                    }
                    catch (NumberFormatException e) {
                        return Messages.LaborOrdersComposite_validatorNotNumber;
                    }
                }
                return null;
            }
        });
    }

    protected boolean canEdit(Object element) {
        return element instanceof LaborItemResults;
    }

    protected CellEditor getCellEditor(Object element) {
        if (element instanceof LaborItemResults) {
            LabItem labItem = ((LaborItemResults)element).getLabItem();
            if (labItem.getTyp() == LabItemTyp.DOCUMENT) {
                return null;
            }
            return this.textCellEditor;
        }
        return null;
    }

    protected Object getValue(Object element) {
        return "";
    }

    private TimeTool getDate() {
        return (TimeTool)this.column.getColumn().getData("labresult.date");
    }

    protected void setValue(Object element, final Object value) {
        if (element instanceof LaborItemResults && value != null) {
            LabResult result;
            LabItem labItem = ((LaborItemResults)element).getLabItem();
            if (labItem.getTyp() == LabItemTyp.DOCUMENT) {
                return;
            }
            final LabResult lockResult = result = this.createResult(labItem, LabOrder.getOrCreateManualLabor());
            AcquireLockBlockingUi.aquireAndRun((IPersistentObject)result, (ILockHandler)new ILockHandler(){

                public void lockFailed() {
                }

                public void lockAcquired() {
                    if (lockResult.getItem().getTyp() == LabItemTyp.TEXT) {
                        lockResult.setResult("Text");
                        lockResult.set("Kommentar", value.toString());
                    } else if (lockResult.getItem().getTyp() != LabItemTyp.DOCUMENT) {
                        lockResult.setResult(value.toString());
                    }
                }
            });
            int columnIdx = this.focusCell.getFocusCell().getColumnIndex();
            ViewerRow row = this.focusCell.getFocusCell().getViewerRow();
            ViewerRow nextRow = row.getNeighbor(2, true);
            this.composite.reload();
            if (nextRow != null) {
                this.getViewer().setSelection((ISelection)new StructuredSelection(nextRow.getElement()), true);
                this.getViewer().editElement(nextRow.getElement(), columnIdx);
            }
        }
    }

    private LabResult createResult(LabItem item, Kontakt origin) {
        TimeTool now = new TimeTool();
        Patient patient = ElexisEventDispatcher.getSelectedPatient();
        LabOrder order = new LabOrder(CoreHub.actUser, this.findMandant(patient), patient, item, null, LabOrder.getNextOrderId(), "Eingabe", now);
        LabResult result = order.createResult(origin);
        order.setState(LabOrder.State.DONE);
        result.setTransmissionTime(now);
        result.setObservationTime(this.getDate());
        return result;
    }

    private Mandant findMandant(Patient patient) {
        Mandant mandant;
        Konsultation konsultation = patient.getLastKonsultation();
        if (konsultation != null && konsultation.exists() && (mandant = konsultation.getMandant()) != null && mandant.getId() != null) {
            return mandant;
        }
        mandant = ElexisEventDispatcher.getSelectedMandator();
        return mandant;
    }
}

