/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.laboratory.actions;

import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.l10n.Messages;
import ch.elexis.core.model.IPersistentObject;
import ch.elexis.core.types.LabItemTyp;
import ch.elexis.core.ui.laboratory.controls.LaborOrderViewerItem;
import ch.elexis.core.ui.laboratory.dialogs.EditLabResultDialog;
import ch.elexis.core.ui.locks.AcquireLockBlockingUi;
import ch.elexis.core.ui.locks.ILockHandler;
import ch.elexis.data.LabOrder;
import ch.elexis.data.LabResult;
import ch.rgw.tools.TimeTool;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.StructuredViewer;

public class LaborResultEditDetailAction
extends Action {
    private List<LabResult> results;
    private List<LaborOrderViewerItem> orders;
    private StructuredViewer viewer;

    public LaborResultEditDetailAction(List<?> list, StructuredViewer viewer) {
        super(Messages.LaborResultEditDetailAction_title);
        Object firstObject = list.get(0);
        if (firstObject instanceof LabResult) {
            this.results = list;
        } else if (firstObject instanceof LaborOrderViewerItem) {
            this.orders = list;
        } else {
            throw new IllegalArgumentException("Unknown list type of class " + firstObject.getClass());
        }
        this.viewer = viewer;
    }

    public void run() {
        block4: {
            block3: {
                if (this.results == null) break block3;
                Iterator<LabResult> iterator = this.results.iterator();
                while (iterator.hasNext()) {
                    LabResult result;
                    final LabResult lockingResult = result = iterator.next();
                    AcquireLockBlockingUi.aquireAndRun((IPersistentObject)lockingResult, (ILockHandler)new ILockHandler(){

                        public void lockFailed() {
                        }

                        public void lockAcquired() {
                            EditLabResultDialog dialog = new EditLabResultDialog(LaborResultEditDetailAction.this.viewer.getControl().getShell(), lockingResult);
                            if (dialog.open() == 0) {
                                ElexisEventDispatcher.reload(LabResult.class);
                            }
                        }
                    });
                }
                break block4;
            }
            if (this.orders == null) break block4;
            for (LaborOrderViewerItem orderViewerItem : this.orders) {
                LabResult result = orderViewerItem.getLabResult();
                if (result == null) {
                    result = orderViewerItem.createResult();
                    result.setTransmissionTime(new TimeTool());
                }
                final LabResult lockingResult = result;
                final LaborOrderViewerItem lockingOrder = orderViewerItem;
                AcquireLockBlockingUi.aquireAndRun((IPersistentObject)lockingResult, (ILockHandler)new ILockHandler(){

                    public void lockFailed() {
                    }

                    public void lockAcquired() {
                        EditLabResultDialog dialog = new EditLabResultDialog(LaborResultEditDetailAction.this.viewer.getControl().getShell(), lockingResult);
                        if (dialog.open() == 0) {
                            lockingOrder.setState(LabOrder.State.DONE);
                            ElexisEventDispatcher.reload(LabResult.class);
                        }
                    }
                });
            }
        }
    }

    public boolean isEnabled() {
        block3: {
            block2: {
                if (this.results == null) break block2;
                for (LabResult result : this.results) {
                    if (result.getItem() == null || result.getItem().getTyp() != LabItemTyp.DOCUMENT && result.getItem().getTyp() != LabItemTyp.FORMULA) continue;
                    return false;
                }
                break block3;
            }
            if (this.orders == null) break block3;
            for (LaborOrderViewerItem order : this.orders) {
                LabItemTyp itemTyp;
                if (!order.hasLabItem() || (itemTyp = order.getLabItemTyp()) != LabItemTyp.DOCUMENT && itemTyp != LabItemTyp.FORMULA) continue;
                return false;
            }
        }
        return super.isEnabled();
    }
}

