/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.util;

import ch.elexis.core.findings.ICoding;
import ch.elexis.core.findings.IObservation;
import ch.elexis.core.findings.IObservationLink;
import ch.elexis.core.findings.ObservationComponent;
import ch.elexis.core.findings.codes.CodingSystem;
import ch.elexis.core.findings.util.ModelUtil;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.slf4j.LoggerFactory;

public class FindingsTextUtil {
    public static String getGroupText(IObservation observation, boolean shouldSet) {
        StringBuilder stringBuilder = new StringBuilder();
        if (IObservation.ObservationType.REF.equals((Object)observation.getObservationType())) {
            Optional<ICoding> coding = ModelUtil.getCodeBySystem(observation.getCoding(), CodingSystem.ELEXIS_LOCAL_CODESYSTEM);
            String title = coding.isPresent() ? coding.get().getDisplay() : "";
            stringBuilder.append(String.valueOf(title) + ": ");
            List children = observation.getTargetObseravtions(IObservationLink.ObservationLinkType.REF);
            Collections.reverse(children);
            int i = 0;
            while (i < children.size()) {
                IObservation iObservation;
                if (i > 0) {
                    stringBuilder.append(", ");
                }
                if (IObservation.ObservationType.REF.equals((Object)(iObservation = (IObservation)children.get(i)).getObservationType())) {
                    stringBuilder.append(FindingsTextUtil.getGroupText(iObservation, shouldSet));
                } else if (IObservation.ObservationType.COMP.equals((Object)iObservation.getObservationType())) {
                    stringBuilder.append(FindingsTextUtil.getObservationText(iObservation, shouldSet));
                } else if (IObservation.ObservationType.TEXT.equals((Object)iObservation.getObservationType())) {
                    stringBuilder.append(FindingsTextUtil.getObservationText(iObservation, shouldSet));
                } else if (IObservation.ObservationType.NUMERIC.equals((Object)iObservation.getObservationType())) {
                    stringBuilder.append(FindingsTextUtil.getObservationText(iObservation, shouldSet));
                } else {
                    LoggerFactory.getLogger(FindingsTextUtil.class).warn("Unknown ObservationType " + iObservation.getObservationType());
                }
                ++i;
            }
            if (observation.getComment().isPresent()) {
                stringBuilder.append(" " + (String)observation.getComment().get());
            }
        } else {
            stringBuilder.append(FindingsTextUtil.getObservationText(observation, shouldSet));
        }
        if (shouldSet) {
            observation.setText(stringBuilder.toString());
        }
        return stringBuilder.toString();
    }

    private static String getComponentText(ObservationComponent component, boolean includeUnit) {
        StringBuilder stringBuilder = new StringBuilder();
        IObservation.ObservationType observationType = (IObservation.ObservationType)component.getTypeFromExtension(IObservation.ObservationType.class);
        if (IObservation.ObservationType.TEXT.equals((Object)observationType)) {
            stringBuilder.append(component.getStringValue().orElse(""));
        } else if (IObservation.ObservationType.NUMERIC.equals((Object)observationType)) {
            try {
                stringBuilder.append(component.getNumericValue().isPresent() ? ((BigDecimal)component.getNumericValue().get()).toPlainString() : "");
                if (includeUnit) {
                    stringBuilder.append(" ");
                    stringBuilder.append(component.getNumericValueUnit().orElse(""));
                }
            }
            catch (NumberFormatException e) {
                LoggerFactory.getLogger(FindingsTextUtil.class).warn("number illegal format", (Throwable)e);
            }
        }
        return stringBuilder.toString();
    }

    public static String getObservationText(IObservation observation, boolean shouldSet) {
        String title;
        StringBuilder stringBuilder = new StringBuilder();
        Optional<ICoding> coding = ModelUtil.getCodeBySystem(observation.getCoding(), CodingSystem.ELEXIS_LOCAL_CODESYSTEM);
        String string = title = coding.isPresent() ? coding.get().getDisplay() : "";
        if (IObservation.ObservationType.TEXT.equals((Object)observation.getObservationType())) {
            stringBuilder.append(" ");
            stringBuilder.append(observation.getStringValue().orElse(""));
            if (observation.getComment().isPresent()) {
                stringBuilder.append(" [" + (String)observation.getComment().get() + "]");
            }
        } else if (IObservation.ObservationType.NUMERIC.equals((Object)observation.getObservationType())) {
            try {
                stringBuilder.append(title);
                stringBuilder.append(" ");
                stringBuilder.append(observation.getNumericValue().isPresent() ? ((BigDecimal)observation.getNumericValue().get()).toPlainString() : "");
                if (observation.getNumericValueUnit().isPresent()) {
                    stringBuilder.append(" " + observation.getNumericValueUnit().orElse(""));
                }
                if (observation.getComment().isPresent()) {
                    stringBuilder.append(" [" + (String)observation.getComment().get() + "]");
                }
            }
            catch (NumberFormatException e) {
                LoggerFactory.getLogger(FindingsTextUtil.class).warn("number illegal format", (Throwable)e);
            }
        } else if (IObservation.ObservationType.COMP.equals((Object)observation.getObservationType())) {
            stringBuilder.append(String.valueOf(title) + " ");
            String textSplitter = ", ";
            String dbTextSplitter = observation.getFormat("textSeparator");
            if (!dbTextSplitter.isEmpty()) {
                textSplitter = dbTextSplitter;
            }
            List components = observation.getComponents();
            String exactUnit = ModelUtil.getExactUnitOfComponent(components);
            int i = 0;
            while (i < components.size()) {
                ObservationComponent component = (ObservationComponent)components.get(i);
                if (i > 0) {
                    stringBuilder.append(textSplitter);
                }
                stringBuilder.append(FindingsTextUtil.getComponentText(component, exactUnit == null));
                ++i;
            }
            if (exactUnit != null) {
                stringBuilder.append(" ").append(exactUnit);
            }
            if (observation.getComment().isPresent()) {
                stringBuilder.append(" [" + (String)observation.getComment().get() + "]");
            }
        }
        if (shouldSet) {
            observation.setText(stringBuilder.toString());
        }
        return stringBuilder.toString();
    }
}

