/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.medication.views;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.ElexisEvent;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.events.ElexisEventListener;
import ch.elexis.core.model.prescription.EntryType;
import ch.elexis.core.ui.actions.GlobalEventDispatcher;
import ch.elexis.core.ui.actions.IActivationListener;
import ch.elexis.core.ui.events.ElexisUiEventListenerImpl;
import ch.elexis.core.ui.events.RefreshingPartListener;
import ch.elexis.core.ui.medication.views.MedicationComposite;
import ch.elexis.core.ui.medication.views.ViewerSortOrder;
import ch.elexis.core.ui.views.IRefreshable;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Prescription;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;

public class MedicationView
extends ViewPart
implements IRefreshable,
IActivationListener {
    private MedicationComposite tpc;
    private RefreshingPartListener udpateOnVisible = new RefreshingPartListener((ViewPart)this);
    public static final String PART_ID = "ch.elexis.core.ui.medication.views.MedicationView";
    private ElexisEventListener eeli_pat = new ElexisUiEventListenerImpl(Patient.class){

        public void runInUi(ElexisEvent ev) {
            if (this.isActiveControl((Control)MedicationView.this.tpc)) {
                MedicationView.this.updateUi((Patient)ev.getObject(), false);
            }
        }
    };
    private ElexisEventListener eeli_presc = new ElexisUiEventListenerImpl(Prescription.class, 7){

        public void runInUi(ElexisEvent ev) {
            if (this.isActiveControl((Control)MedicationView.this.tpc)) {
                EntryType entryType;
                PersistentObject prescObj = ev.getObject();
                if (prescObj instanceof Prescription && !MedicationView.this.getMedicationComposite().isShowingHistory() && ((entryType = ((Prescription)prescObj).getEntryType()) == EntryType.RECIPE || entryType == EntryType.SELF_DISPENSED)) {
                    return;
                }
                MedicationView.this.updateUi(ElexisEventDispatcher.getSelectedPatient(), true);
            }
        }
    };

    public void createPartControl(Composite parent) {
        this.tpc = new MedicationComposite(parent, 0, this.getSite());
        this.getSite().setSelectionProvider((ISelectionProvider)this.tpc);
        int sorter = CoreHub.userCfg.get("medicationlist/sortOrder", 1);
        this.tpc.setViewerSortOrder(ViewerSortOrder.getSortOrderPerValue(sorter));
        ElexisEventDispatcher.getInstance().addListeners(new ElexisEventListener[]{this.eeli_pat, this.eeli_presc});
        this.getSite().getPage().addPartListener((IPartListener2)this.udpateOnVisible);
        GlobalEventDispatcher.addActivationListener((IActivationListener)this, (IWorkbenchPart)this);
    }

    public void dispose() {
        this.getSite().getPage().removePartListener((IPartListener2)this.udpateOnVisible);
        ElexisEventDispatcher.getInstance().removeListeners(new ElexisEventListener[]{this.eeli_pat, this.eeli_presc});
        GlobalEventDispatcher.removeActivationListener((IActivationListener)this, (IWorkbenchPart)this);
        super.dispose();
    }

    public void setMedicationTableViewerComparator(ViewerSortOrder order) {
        this.tpc.setViewerSortOrder(order);
        CoreHub.userCfg.set("medicationlist/sortOrder", order.val);
    }

    public void setFocus() {
        this.tpc.setFocus();
        this.refresh();
    }

    private void updateUi(Patient pat, boolean forceUpdate) {
        this.tpc.updateUi(pat, forceUpdate);
    }

    public void refresh() {
        this.eeli_pat.catchElexisEvent(ElexisEvent.createPatientEvent());
    }

    public void resetSelection() {
        this.tpc.resetSelectedMedication();
    }

    public MedicationComposite getMedicationComposite() {
        return this.tpc;
    }

    public void activation(boolean mode) {
        if (!mode && this.tpc != null && !this.tpc.isDisposed()) {
            this.tpc.showMedicationDetailComposite(null);
        }
    }

    public void visible(boolean mode) {
    }
}

