/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.types;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum RelationshipType implements Enumerator
{
    AGENERIC(0, "A_GENERIC", "A_GENERIC"),
    BUSINESS_EMPLOYER(100, "BUSINESS_EMPLOYER", "BUSINESS_EMPLOYER"),
    BUSINESS_EMPLOYEE(101, "BUSINESS_EMPLOYEE", "BUSINESS_EMPLOYEE"),
    FAMILY_PARENT(200, "FAMILY_PARENT", "FAMILY_PARENT"),
    FAMILY_CHILD(210, "FAMILY_CHILD", "FAMILY_CHILD"),
    FAMILY_GUARDIAN(220, "FAMILY_GUARDIAN", "FAMILY_GUARDIAN"),
    FAMILY_ICE(230, "FAMILY_ICE", "FAMILY_ICE"),
    FAMILY_ALTERNATIVE(290, "FAMILY_ALTERNATIVE", "FAMILY_ALTERNATIVE"),
    WELFARE_GENERAL_PRACTITIONER(300, "WELFARE_GENERAL_PRACTITIONER", "WELFARE_GENERAL_PRACTITIONER"),
    WELFARE_PATIENT(301, "WELFARE_PATIENT", "WELFARE_PATIENT"),
    WELFARE_CONSULTANT(310, "WELFARE_CONSULTANT", "WELFARE_CONSULTANT"),
    WELFARE_INSURER(410, "WELFARE_INSURER", "WELFARE_INSURER"),
    WELFARE_INSUREE(411, "WELFARE_INSUREE", "WELFARE_INSUREE");

    public static final int AGENERIC_VALUE = 0;
    public static final int BUSINESS_EMPLOYER_VALUE = 100;
    public static final int BUSINESS_EMPLOYEE_VALUE = 101;
    public static final int FAMILY_PARENT_VALUE = 200;
    public static final int FAMILY_CHILD_VALUE = 210;
    public static final int FAMILY_GUARDIAN_VALUE = 220;
    public static final int FAMILY_ICE_VALUE = 230;
    public static final int FAMILY_ALTERNATIVE_VALUE = 290;
    public static final int WELFARE_GENERAL_PRACTITIONER_VALUE = 300;
    public static final int WELFARE_PATIENT_VALUE = 301;
    public static final int WELFARE_CONSULTANT_VALUE = 310;
    public static final int WELFARE_INSURER_VALUE = 410;
    public static final int WELFARE_INSUREE_VALUE = 411;
    private static final RelationshipType[] VALUES_ARRAY;
    public static final List<RelationshipType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new RelationshipType[]{AGENERIC, BUSINESS_EMPLOYER, BUSINESS_EMPLOYEE, FAMILY_PARENT, FAMILY_CHILD, FAMILY_GUARDIAN, FAMILY_ICE, FAMILY_ALTERNATIVE, WELFARE_GENERAL_PRACTITIONER, WELFARE_PATIENT, WELFARE_CONSULTANT, WELFARE_INSURER, WELFARE_INSUREE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static RelationshipType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            RelationshipType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static RelationshipType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            RelationshipType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static RelationshipType get(int value) {
        switch (value) {
            case 0: {
                return AGENERIC;
            }
            case 100: {
                return BUSINESS_EMPLOYER;
            }
            case 101: {
                return BUSINESS_EMPLOYEE;
            }
            case 200: {
                return FAMILY_PARENT;
            }
            case 210: {
                return FAMILY_CHILD;
            }
            case 220: {
                return FAMILY_GUARDIAN;
            }
            case 230: {
                return FAMILY_ICE;
            }
            case 290: {
                return FAMILY_ALTERNATIVE;
            }
            case 300: {
                return WELFARE_GENERAL_PRACTITIONER;
            }
            case 301: {
                return WELFARE_PATIENT;
            }
            case 310: {
                return WELFARE_CONSULTANT;
            }
            case 410: {
                return WELFARE_INSURER;
            }
            case 411: {
                return WELFARE_INSUREE;
            }
        }
        return null;
    }

    private RelationshipType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

