/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.types;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum DocumentStatus implements Enumerator
{
    NEW(0, "NEW", "NEW"),
    CHANGED(1, "CHANGED", "CHANGED"),
    VALIDATED(2, "VALIDATED", "VALIDATED"),
    SENT(3, "SENT", "SENT"),
    RECIVED(4, "RECIVED", "RECIVED");

    public static final int NEW_VALUE = 0;
    public static final int CHANGED_VALUE = 1;
    public static final int VALIDATED_VALUE = 2;
    public static final int SENT_VALUE = 3;
    public static final int RECIVED_VALUE = 4;
    private static final DocumentStatus[] VALUES_ARRAY;
    public static final List<DocumentStatus> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new DocumentStatus[]{NEW, CHANGED, VALIDATED, SENT, RECIVED};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static DocumentStatus get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            DocumentStatus result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static DocumentStatus getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            DocumentStatus result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static DocumentStatus get(int value) {
        switch (value) {
            case 0: {
                return NEW;
            }
            case 1: {
                return CHANGED;
            }
            case 2: {
                return VALIDATED;
            }
            case 3: {
                return SENT;
            }
            case 4: {
                return RECIVED;
            }
        }
        return null;
    }

    private DocumentStatus(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

