/*
 * Decompiled with CFR 0.152.
 */
package ch.rgw.tools;

import ch.rgw.tools.ExHandler;
import ch.rgw.tools.JdbcLink;
import ch.rgw.tools.Messages;
import ch.rgw.tools.StringTool;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;

public class TimeTool
extends GregorianCalendar {
    private static final long serialVersionUID = 3287264721L;
    public static final String BEGINNING_OF_UNIX_EPOCH = "19700101";
    public static final String END_OF_UNIX_EPOCH = "20380118";
    public static final String[] Monate = new String[]{Messages.TimeTool_january, Messages.TimeTool_february, Messages.TimeTool_march, Messages.TimeTool_april, Messages.TimeTool_may, Messages.TimeTool_june, Messages.TimeTool_july, Messages.TimeTool_august, Messages.TimeTool_september, Messages.TimeTool_october, Messages.TimeTool_november, Messages.TimeTool_december};
    public static final String[] Mon = new String[]{Messages.TimeTool_jan, Messages.TimeTool_feb, Messages.TimeTool_mar, Messages.TimeTool_apr, Messages.TimeTool_may, Messages.TimeTool_jun, Messages.TimeTool_jul, Messages.TimeTool_aug, Messages.TimeTool_sep, Messages.TimeTool_oct, Messages.TimeTool_nov, Messages.TimeTool_dec};
    public static final String[] month_eng = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    public static final String[] wdays = new String[]{Messages.TimeTool_su, Messages.TimeTool_mo, Messages.TimeTool_tu, Messages.TimeTool_we, Messages.TimeTool_th, Messages.TimeTool_fr, Messages.TimeTool_sa};
    public static final String[] Wochentage = new String[]{Messages.TimeTool_sunday, Messages.TimeTool_monday, Messages.TimeTool_tuesday, Messages.TimeTool_wednesday, Messages.TimeTool_thursday, Messages.TimeTool_friday, Messages.TimeTool_saturday};
    public static final int FULL_GER = 0;
    public static final int LARGE_GER = 1;
    public static final int TIME_FULL = 2;
    public static final int TIME_SMALL = 3;
    public static final int DATE_GER = 4;
    public static final int FULL_MYSQL = 5;
    public static final int DATE_MYSQL = 6;
    public static final int FULL_ISO = 5;
    public static final int DATE_ISO = 6;
    public static final int TIME_COMPACT = 8;
    public static final int DATE_COMPACT = 9;
    public static final int FULL = 10;
    public static final int DATE_SIMPLE = 11;
    public static final int WEEKDAY = 12;
    public static final int TIMESTAMP = 13;
    public static final int DATETIME_XML = 14;
    public static final int DATE_GER_SHORT = 15;
    public static final int TIME_COMPACT_FULL = 16;
    private static final SimpleDateFormat full_ger = new SimpleDateFormat("dd.MM.yyyy, HH:mm:ss");
    private static final SimpleDateFormat large_ger = new SimpleDateFormat("dd.MM.yyyy, HH:mm");
    private static final SimpleDateFormat time_full = new SimpleDateFormat("HH:mm:ss");
    private static final SimpleDateFormat time_small = new SimpleDateFormat("HH:mm");
    private static final SimpleDateFormat full_mysql = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final SimpleDateFormat date_mysql = new SimpleDateFormat("yyyy-MM-dd");
    private static final SimpleDateFormat date_ger = new SimpleDateFormat("dd.MM.yyyy");
    private static final SimpleDateFormat date_ger_short = new SimpleDateFormat("dd.MM.yy");
    private static SimpleDateFormat time_compact = new SimpleDateFormat("HHmm");
    private static final SimpleDateFormat time_compact_full = new SimpleDateFormat("HHmmss");
    private static final SimpleDateFormat date_compact = new SimpleDateFormat("yyyyMMdd");
    private static final SimpleDateFormat timestamp = new SimpleDateFormat("yyyyMMddHHmmss");
    private static final SimpleDateFormat datetime_xml = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    private static SimpleDateFormat pref_full = full_ger;
    private static SimpleDateFormat pref_small = date_ger;
    private static boolean wrap = true;
    private static int defaultResolution = 1000;
    private long resolution;
    private static final Map<Integer, SimpleDateFormat> INT_SDF_MAP = TimeTool.initIntSdfMapping();

    public static String Version() {
        return "3.2.3";
    }

    public static int getTimeInSeconds() {
        return (int)(System.currentTimeMillis() / 1000L);
    }

    private static Map<Integer, SimpleDateFormat> initIntSdfMapping() {
        HashMap<Integer, SimpleDateFormat> map = new HashMap<Integer, SimpleDateFormat>();
        map.put(11, pref_small);
        map.put(0, full_ger);
        map.put(1, large_ger);
        map.put(2, time_full);
        map.put(3, time_small);
        map.put(4, date_ger);
        map.put(5, full_mysql);
        map.put(6, date_mysql);
        map.put(10, pref_full);
        map.put(8, time_compact);
        map.put(16, time_compact_full);
        map.put(9, date_compact);
        map.put(14, datetime_xml);
        map.put(13, timestamp);
        map.put(15, date_ger_short);
        return map;
    }

    public static int getMinutesFromTimeString(String in) {
        return TimeTool.getSecondsFromTimeString(in) / 60;
    }

    public static int getSecondsFromTimeString(String in) {
        int[] fld = TimeTool.parseTime(in);
        if (fld == null) {
            return Integer.MAX_VALUE;
        }
        return fld[0] * 3600 + fld[1] * 60 + fld[2];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isValidDateTimeString(String timestring, int timestringformat) {
        SimpleDateFormat sdf = INT_SDF_MAP.get(timestringformat);
        if (sdf == null) {
            return false;
        }
        try {
            SimpleDateFormat simpleDateFormat = sdf;
            synchronized (simpleDateFormat) {
                sdf.setLenient(false);
                sdf.parse(timestring);
            }
        }
        catch (ParseException e) {
            return false;
        }
        return true;
    }

    public TimeTool() {
        this.resolution = defaultResolution;
    }

    public TimeTool(TimeTool other) {
        this.setTimeInMillis(other.getTimeInMillis());
        this.resolution = other.resolution;
    }

    public TimeTool(int t, int res) {
        this.resolution = res != 0 ? (long)res : (long)defaultResolution;
        if (t == 0) {
            this.setTimeInMillis(System.currentTimeMillis());
        } else {
            this.setTimeInMillis((long)t * this.resolution);
        }
    }

    public TimeTool(String pre) {
        this.set(pre);
        this.resolution = defaultResolution;
    }

    public TimeTool(String pre, boolean bFailIfInvalid) throws TimeFormatException {
        boolean formalOK = this.set(pre);
        this.resolution = defaultResolution;
        if (bFailIfInvalid && !formalOK) {
            throw new TimeFormatException("Invalid Time/Date String");
        }
    }

    public TimeTool(long millis) {
        this.setTimeInMillis(millis);
        this.resolution = defaultResolution;
    }

    public TimeTool(Date date) {
        this.setTimeInMillis(date.getTime());
        this.resolution = defaultResolution;
    }

    public TimeTool(LocalDate localDate) {
        Date date = Date.from(localDate.atStartOfDay(ZoneId.systemDefault()).toInstant());
        this.setTimeInMillis(date.getTime());
        this.resolution = defaultResolution;
    }

    public TimeTool(LocalDateTime localDateTime) {
        ZonedDateTime atZone = localDateTime.atZone(ZoneId.systemDefault());
        this.setTimeInMillis(atZone.toInstant().toEpochMilli());
        this.resolution = defaultResolution;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean set(String orig) {
        if (orig == null) {
            return false;
        }
        String s = orig.trim();
        if (StringTool.isNothing(s)) {
            return false;
        }
        try {
            if (s.startsWith("#") || s.startsWith("'") || s.startsWith("\"")) {
                s = s.substring(1, s.length() - 1);
            }
            String trc = " ";
            if (s.indexOf(44) != -1) {
                trc = ",";
            } else if (s.indexOf("T") != -1) {
                trc = "T";
            }
            String[] s1 = s.split(trc);
            if (s1.length != 2) {
                int[] r = TimeTool.parseTime(s);
                if (r != null) {
                    this.set(11, r[0]);
                    this.set(12, r[1]);
                    this.set(13, r[2]);
                    this.set(14, 0);
                    return true;
                }
                r = TimeTool.parseDate(s);
                if (r == null) {
                    if (s.length() != 14) return false;
                    this.set(Integer.parseInt(s.substring(0, 4)), Integer.parseInt(s.substring(4, 6)) - 1, Integer.parseInt(s.substring(6, 8)), Integer.parseInt(s.substring(8, 10)), Integer.parseInt(s.substring(10, 12)), Integer.parseInt(s.substring(12, 14)));
                    this.set(14, 0);
                    return true;
                }
                this.set(r[2], r[1] - 1, r[0], 0, 0, 0);
                this.set(14, 0);
                return true;
            }
            int[] d = TimeTool.parseDate(s1[0]);
            if (d == null) {
                return false;
            }
            int[] t = TimeTool.parseTime(s1[1]);
            if (t == null) {
                return false;
            }
            this.set(d[2], d[1] - 1, d[0], t[0], t[1], t[2]);
            this.set(14, 0);
            return true;
        }
        catch (Exception ex) {
            ExHandler.handle(ex);
            return false;
        }
    }

    public boolean setDate(String dat) {
        int[] d;
        block3: {
            try {
                d = TimeTool.parseDate(dat);
                if (d != null) break block3;
                return false;
            }
            catch (Exception ex) {
                ExHandler.handle(ex);
                return false;
            }
        }
        this.set(1, d[2]);
        this.set(2, d[1] - 1);
        this.set(5, d[0]);
        return true;
    }

    public void setDate(TimeTool o) {
        this.set(1, o.get(1));
        this.set(2, o.get(2));
        this.set(5, o.get(5));
    }

    public void setTime(TimeTool o) {
        this.set(11, o.get(11));
        this.set(12, o.get(12));
        this.set(13, o.get(13));
        this.set(14, 0);
    }

    public static int[] parseDate(String tx) {
        boolean trenner = false;
        String t = tx.trim();
        String[] dat = t.split("-");
        if (dat.length != 3) {
            dat = t.split("\\.");
            if (dat.length != 3) {
                dat = t.split("/");
            }
            trenner = true;
            if (dat.length != 3) {
                if (t.length() == 8) {
                    dat = new String[3];
                    dat[2] = t.substring(0, 4);
                    dat[1] = t.substring(4, 6);
                    dat[0] = t.substring(6, 8);
                } else {
                    return null;
                }
            }
        }
        int[] ret = new int[3];
        ret[1] = 0;
        int s1 = 0;
        int s2 = 0;
        try {
            s1 = Integer.parseInt(dat[0]);
            ret[1] = Integer.parseInt(dat[1]);
            s2 = Integer.parseInt(dat[2]);
        }
        catch (NumberFormatException nex) {
            ExHandler.handle(nex);
            return null;
        }
        if (s1 > 31) {
            ret[0] = s2;
            ret[2] = s1;
        } else if (s2 > 31) {
            ret[0] = s1;
            ret[2] = s2;
        } else if (trenner) {
            ret[0] = s1;
            ret[2] = s2;
        } else {
            ret[0] = s2;
            ret[2] = s1;
        }
        if (ret[2] < 1900) {
            ret[2] = ret[2] + 2000;
            int act = new TimeTool().get(1);
            if (act < ret[2] - 5) {
                ret[2] = ret[2] - 100;
            }
        }
        return ret;
    }

    public static int[] parseTime(String tx) {
        String[] tim;
        String t = tx.trim();
        if (t.endsWith(".0")) {
            t = t.substring(0, t.length() - 2);
        }
        if ((tim = t.split(":")).length < 2) {
            if (t.matches("[0-2][0-9][0-5][0-9]")) {
                tim = new String[]{t.substring(0, 2), t.substring(2)};
            } else if (t.matches("[0-9][0-5][0-9]")) {
                tim = new String[]{t.substring(0, 1), t.substring(1)};
            } else {
                return null;
            }
        }
        int[] ret = new int[]{Integer.parseInt(tim[0]), Integer.parseInt(tim[1]), tim.length > 2 ? Integer.parseInt(tim[2]) : 0};
        return ret;
    }

    public void set(GregorianCalendar gcal) {
        this.setTimeInMillis(gcal.getTime().getTime());
    }

    public void set(TimeTool o) {
        this.setTimeInMillis(o.getTimeInMillis());
        this.setResolution(o.resolution);
    }

    public void setAsUnits(int d) {
        this.setTimeInMillis((long)d * this.resolution);
    }

    public int secondsTo(TimeTool o) {
        if (o == null) {
            return 0;
        }
        long ot = o.getTimeInMillis() / 1000L;
        long mt = this.getTimeInMillis() / 1000L;
        long res = ot - mt;
        return (int)res;
    }

    public int daysTo(TimeTool o) {
        long startToday = this.getTimeAsLong() - (long)this.get(11) * 3600000L;
        long startOther = o.getTimeAsLong() - (long)o.get(11) * 3600000L;
        long diff = startOther - startToday - 1L;
        return (int)(diff / 86400000L);
    }

    public void setResolution(long res) {
        this.resolution = res;
    }

    public long diff(TimeTool o, long res) {
        long mine = this.getTimeInMillis();
        long other = o.getTimeInMillis();
        long diff = mine - other;
        return diff / (res == 0L ? this.resolution : res);
    }

    public boolean isBeforeOrEqual(TimeTool o) {
        return this.diff(o, this.resolution) <= 0L;
    }

    public boolean isBeforeOrEqual(TimeTool o, int res) {
        return this.diff(o, res) <= 0L;
    }

    public boolean isBefore(TimeTool o) {
        return this.diff(o, this.resolution) < 0L;
    }

    public boolean isBefore(TimeTool o, int res) {
        return this.diff(o, res) < 0L;
    }

    public boolean isAfterOrEqual(TimeTool o) {
        return this.diff(o, this.resolution) >= 0L;
    }

    public boolean isAfterOrEqual(TimeTool o, int res) {
        return this.diff(o, res) >= 0L;
    }

    public boolean isAfter(TimeTool o) {
        return this.diff(o, this.resolution) > 0L;
    }

    public boolean isAfter(TimeTool o, int res) {
        return this.diff(o, res) > 0L;
    }

    public boolean isEqual(TimeTool o) {
        return this.diff(o, this.resolution) == 0L;
    }

    public boolean isEqual(TimeTool o, int res) {
        return this.diff(o, res) == 0L;
    }

    public boolean isSameDay(TimeTool o) {
        if (o == null) {
            return false;
        }
        int year1 = this.get(1);
        int month1 = this.get(2);
        int day1 = this.get(5);
        int year2 = o.get(1);
        int month2 = o.get(2);
        int day2 = o.get(5);
        return year1 == year2 && month1 == month2 && day1 == day2;
    }

    public String getDurationToNowString() {
        return this.getDurationToTimeAsString(LocalDateTime.now());
    }

    public String getDurationToTimeAsString(LocalDateTime localDateTime) {
        LocalDateTime date = this.toLocalDateTime();
        LocalDateTime now = localDateTime;
        int years = (int)now.until(date, ChronoUnit.YEARS);
        int weeks = (int)now.until(date, ChronoUnit.WEEKS);
        int months = (int)now.until(date, ChronoUnit.MONTHS);
        int days = (int)now.until(date, ChronoUnit.DAYS);
        if (days == 0) {
            int nowDay = now.getDayOfYear();
            int dateDay = date.getDayOfYear();
            days = dateDay - nowDay;
        }
        if (years != 0 && Math.abs(days) > 56) {
            String format = this.getYearsFormat(years);
            return String.format(format, Math.abs(years));
        }
        if (months != 0 && Math.abs(days) > 63) {
            String format = this.getMonthsFormat(months);
            return String.format(format, Math.abs(months));
        }
        if (weeks != 0 && Math.abs(days) > 14) {
            String format = this.getWeeksFormat(weeks);
            return String.format(format, Math.abs(weeks));
        }
        if (days != 0) {
            String format = this.getDaysFormat(days);
            return String.format(format, Math.abs(days));
        }
        return Messages.TimeTool_today;
    }

    protected String getYearsFormat(int years) {
        if (years < 0) {
            if (years < -1) {
                return Messages.TimeTool_yearsAgoFormat;
            }
            return Messages.TimeTool_yearAgoFormat;
        }
        if (years > 1) {
            return Messages.TimeTool_yearsToFormat;
        }
        return Messages.TimeTool_yearToFormat;
    }

    protected String getMonthsFormat(int months) {
        if (months < 0) {
            if (months < -1) {
                return Messages.TimeTool_monthsAgoFormat;
            }
            return Messages.TimeTool_monthAgoFormat;
        }
        if (months > 1) {
            return Messages.TimeTool_monthsToFormat;
        }
        return Messages.TimeTool_monthToFormat;
    }

    protected String getWeeksFormat(int weeks) {
        if (weeks < 0) {
            if (weeks < -1) {
                return Messages.TimeTool_weeksAgoFormat;
            }
            return Messages.TimeTool_weekAgoFormat;
        }
        if (weeks > 1) {
            return Messages.TimeTool_weeksToFormat;
        }
        return Messages.TimeTool_weekToFormat;
    }

    protected String getDaysFormat(int days) {
        if (days < 0) {
            if (days < -1) {
                return Messages.TimeTool_daysAgoFormat;
            }
            return Messages.TimeTool_dayAgoFormat;
        }
        if (days > 1) {
            return Messages.TimeTool_daysToFormat;
        }
        return Messages.TimeTool_dayToFormat;
    }

    public int getTimeInUnits() {
        return (int)(this.getTimeInMillis() / this.resolution);
    }

    public long getTimeAsLong() {
        return this.getTimeInMillis();
    }

    public void chop(int w) {
        this.set(14, 0);
        if (w > 0) {
            this.set(13, 0);
        }
        if (w > 1) {
            this.set(12, 0);
        }
        if (w > 2) {
            this.set(11, 0);
        }
    }

    public void addUnits(int m) {
        this.add(14, m * (int)this.resolution);
    }

    public void addDays(int d) {
        this.add(6, d);
    }

    public void addMinutes(int m) {
        this.add(12, m);
    }

    public void addHours(int h) {
        this.add(11, h);
    }

    public void addSeconds(int s) {
        this.add(13, s);
    }

    public static void setDefaultResolution(int r) {
        defaultResolution = r;
    }

    public static void setPreferredFormat(String full, String small, String wr) {
        pref_full = new SimpleDateFormat(full);
        pref_small = new SimpleDateFormat(small);
        wrap = wr.equals("1");
    }

    public LocalDate toLocalDate() {
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTimeInMillis(this.getTimeInMillis());
        return gc.toZonedDateTime().toLocalDate();
    }

    public LocalDateTime toLocalDateTime() {
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTimeInMillis(this.getTimeInMillis());
        return gc.toZonedDateTime().toLocalDateTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toDBString(boolean full) {
        String res;
        if (full) {
            SimpleDateFormat simpleDateFormat = pref_full;
            synchronized (simpleDateFormat) {
                res = pref_full.format(this.getTime());
            }
        }
        SimpleDateFormat simpleDateFormat = pref_small;
        synchronized (simpleDateFormat) {
            res = pref_small.format(this.getTime());
        }
        if (wrap) {
            return JdbcLink.wrap(res);
        }
        return res;
    }

    @Override
    public String toString() {
        return Long.toHexString(this.getTimeInMillis());
    }

    public String dump() {
        return this.toString(10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString(int f) {
        if (12 == f) {
            return wdays[this.get(7) - 1];
        }
        SimpleDateFormat sdf = INT_SDF_MAP.get(f);
        if (sdf != null) {
            SimpleDateFormat simpleDateFormat = sdf;
            synchronized (simpleDateFormat) {
                return sdf.format(this.getTime());
            }
        }
        return "00:00";
    }

    @Override
    public int hashCode() {
        return this.toString().hashCode();
    }

    public static int minutesStringToInt(String in) {
        String[] hm = in.split("[:\\.]");
        String h = "0";
        String m = "0";
        if (hm.length == 1) {
            if (hm[0].length() < 3) {
                return 0;
            }
            if (hm[0].length() < 4) {
                hm[0] = "0" + hm[0];
            }
            h = hm[0].substring(0, 2);
            m = hm[0].substring(2, 4);
        } else {
            h = hm[0];
            m = hm[1];
        }
        return Integer.parseInt(h) * 60 + Integer.parseInt(m);
    }

    @Override
    public int compareTo(Calendar arg0) {
        long diff = this.getTimeInMillis() - arg0.getTimeInMillis();
        if (diff < 0L) {
            return -1;
        }
        if (diff > 0L) {
            return 1;
        }
        return 0;
    }

    public static int compare(TimeTool dd, TimeTool dd2) {
        if (dd == null || dd2 == null) {
            if (dd != null) {
                return -1;
            }
            if (dd2 != null) {
                return 1;
            }
            return 0;
        }
        return dd2.compareTo(dd);
    }

    public static enum DAYS {
        MONDAY(2, Messages.TimeTool_monday, Messages.TimeTool_mo),
        TUESDAY(3, Messages.TimeTool_tuesday, Messages.TimeTool_tu),
        WEDNESDAY(4, Messages.TimeTool_wednesday, Messages.TimeTool_we),
        THURSDAY(5, Messages.TimeTool_thursday, Messages.TimeTool_th),
        FRIDAY(6, Messages.TimeTool_friday, Messages.TimeTool_fr),
        SATURDAY(7, Messages.TimeTool_saturday, Messages.TimeTool_sa),
        SUNDAY(1, Messages.TimeTool_sunday, Messages.TimeTool_su);

        public int numericDayValue;
        public String fullName;
        public String abbreviatedName;

        private DAYS(int numericDayValue, String fullName, String abbreviatedName) {
            this.numericDayValue = numericDayValue;
            this.fullName = fullName;
            this.abbreviatedName = abbreviatedName;
        }

        public static DAYS valueOf(String string) {
            return Enum.valueOf(DAYS.class, string);
        }
    }

    public static class TimeFormatException
    extends Exception {
        private static final long serialVersionUID = -7509724431749474725L;

        public TimeFormatException(String msg2) {
            super(msg2);
        }
    }
}

