/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v23.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v23.datatype.CE;
import ca.uhn.hl7v2.model.v23.datatype.ID;
import ca.uhn.hl7v2.model.v23.datatype.ST;
import ca.uhn.hl7v2.model.v23.datatype.TS;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class MFA
extends AbstractSegment {
    public MFA(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(ID.class, true, 1, 3, new Object[]{this.getMessage(), new Integer(180)}, "Record-Level Event Code");
            this.add(ST.class, false, 1, 20, new Object[]{this.getMessage()}, "MFN Control ID");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Event Completion Date/Time");
            this.add(CE.class, true, 1, 60, new Object[]{this.getMessage()}, "Error Return Code and/or Text");
            this.add(CE.class, true, 0, 60, new Object[]{this.getMessage()}, "Primary Key Value");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating MFA - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public ID getRecordLevelEventCode() {
        ID retVal = (ID)this.getTypedField(1, 0);
        return retVal;
    }

    public ID getMfa1_RecordLevelEventCode() {
        ID retVal = (ID)this.getTypedField(1, 0);
        return retVal;
    }

    public ST getMFNControlID() {
        ST retVal = (ST)this.getTypedField(2, 0);
        return retVal;
    }

    public ST getMfa2_MFNControlID() {
        ST retVal = (ST)this.getTypedField(2, 0);
        return retVal;
    }

    public TS getEventCompletionDateTime() {
        TS retVal = (TS)this.getTypedField(3, 0);
        return retVal;
    }

    public TS getMfa3_EventCompletionDateTime() {
        TS retVal = (TS)this.getTypedField(3, 0);
        return retVal;
    }

    public CE getErrorReturnCodeAndOrText() {
        CE retVal = (CE)this.getTypedField(4, 0);
        return retVal;
    }

    public CE getMfa4_ErrorReturnCodeAndOrText() {
        CE retVal = (CE)this.getTypedField(4, 0);
        return retVal;
    }

    public CE[] getPrimaryKeyValue() {
        CE[] retVal = (CE[])this.getTypedField(5, new CE[0]);
        return retVal;
    }

    public CE[] getMfa5_PrimaryKeyValue() {
        CE[] retVal = (CE[])this.getTypedField(5, new CE[0]);
        return retVal;
    }

    public int getPrimaryKeyValueReps() {
        return this.getReps(5);
    }

    public CE getPrimaryKeyValue(int rep) {
        CE retVal = (CE)this.getTypedField(5, rep);
        return retVal;
    }

    public CE getMfa5_PrimaryKeyValue(int rep) {
        CE retVal = (CE)this.getTypedField(5, rep);
        return retVal;
    }

    public int getMfa5_PrimaryKeyValueReps() {
        return this.getReps(5);
    }

    public CE insertPrimaryKeyValue(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(5, rep);
    }

    public CE insertMfa5_PrimaryKeyValue(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(5, rep);
    }

    public CE removePrimaryKeyValue(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(5, rep);
    }

    public CE removeMfa5_PrimaryKeyValue(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(5, rep);
    }

    @Override
    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new ID(this.getMessage(), new Integer(180));
            }
            case 1: {
                return new ST(this.getMessage());
            }
            case 2: {
                return new TS(this.getMessage());
            }
            case 3: {
                return new CE(this.getMessage());
            }
            case 4: {
                return new CE(this.getMessage());
            }
        }
        return null;
    }
}

