/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.stock.service;

import ch.elexis.core.services.IArticleService;
import ch.elexis.core.ui.stock.service.internal.ArticleServiceStore;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={})
public class ArticleServiceHolder {
    private static ArticleServiceStore articleServiceStore;

    @Reference(unbind="-")
    public void bind(ArticleServiceStore service) {
        articleServiceStore = service;
    }

    public static Optional<IArticleService> getService(String storeId) {
        IArticleService articleService = (IArticleService)articleServiceStore.getServices().get(storeId);
        if (articleService != null) {
            return Optional.of(articleService);
        }
        return Optional.empty();
    }

    public static List<String> getStoreIds() {
        ArrayList<String> storeIds = new ArrayList<String>(articleServiceStore.getServices().keySet());
        Collections.sort(storeIds);
        return storeIds;
    }
}

