/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.laboratory.preferences;

import ch.elexis.admin.AccessControlDefaults;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.model.IPersistentObject;
import ch.elexis.core.types.LabItemTyp;
import ch.elexis.core.ui.laboratory.commands.EditLabItemUi;
import ch.elexis.core.ui.laboratory.dialogs.LabItemViewerFilter;
import ch.elexis.core.ui.laboratory.preferences.Messages;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.LabItem;
import ch.elexis.data.LabMapping;
import ch.elexis.data.LabResult;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Query;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerService;

public class LaborPrefs
extends PreferencePage
implements IWorkbenchPreferencePage {
    private TableViewer tableViewer;
    private Table table;
    int sortC = 1;
    private String[] headers = new String[]{Messages.LaborPrefs_name, Messages.LaborPrefs_short, "LOINC", Messages.LaborPrefs_type, Messages.LaborPrefs_unit, Messages.LaborPrefs_refM, Messages.LaborPrefs_refF, Messages.LaborPrefs_sortmode};
    private int[] colwidth = new int[]{16, 6, 6, 6, 6, 16, 16, 16};
    private LabItemViewerFilter viewerFilter;

    public LaborPrefs() {
        super(Messages.LaborPrefs_labTitle);
    }

    protected Control createContents(Composite parent) {
        this.noDefaultAndApplyButton();
        LabListLabelProvider labListLabelProvider = new LabListLabelProvider();
        this.viewerFilter = new LabItemViewerFilter((ILabelProvider)labListLabelProvider);
        Text filterTxt = new Text(parent, 896);
        filterTxt.setMessage("filter");
        filterTxt.addModifyListener(e -> {
            if (filterTxt.getText().length() > 1) {
                this.viewerFilter.setSearchText(filterTxt.getText());
                this.tableViewer.refresh();
            } else {
                this.viewerFilter.setSearchText("");
                this.tableViewer.refresh();
            }
        });
        filterTxt.setLayoutData((Object)new GridData(4, 2, true, false));
        Composite tableComposite = new Composite(parent, 0);
        tableComposite.setLayoutData((Object)new GridData());
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        tableComposite.setLayout((Layout)tableColumnLayout);
        this.tableViewer = new TableViewer(tableComposite, 67584);
        this.table = this.tableViewer.getTable();
        this.tableViewer.setLabelProvider((IBaseLabelProvider)labListLabelProvider);
        this.tableViewer.addFilter((ViewerFilter)this.viewerFilter);
        int i = 0;
        while (i < this.headers.length) {
            TableColumn tc = new TableColumn(this.table, 16384);
            tc.setText(this.headers[i]);
            tableColumnLayout.setColumnData((Widget)tc, (ColumnLayoutData)new ColumnWeightData(this.colwidth[i], true));
            tc.setData((Object)i);
            tc.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    LaborPrefs.this.sortC = (Integer)((TableColumn)e.getSource()).getData();
                    LaborPrefs.this.tableViewer.refresh(true);
                }
            });
            ++i;
        }
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        this.table.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        this.tableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return LabItem.getLabItems().toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection sel = LaborPrefs.this.tableViewer.getStructuredSelection();
                Object o = sel.getFirstElement();
                if (o instanceof LabItem) {
                    LabItem li = (LabItem)o;
                    EditLabItemUi.executeWithParams((PersistentObject)li);
                    LaborPrefs.this.tableViewer.refresh((Object)li);
                }
            }
        });
        this.tableViewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                LabItem li1 = (LabItem)e1;
                LabItem li2 = (LabItem)e2;
                String s1 = "";
                String s2 = "";
                switch (LaborPrefs.this.sortC) {
                    case 1: {
                        s1 = li1.getKuerzel();
                        s2 = li2.getKuerzel();
                        break;
                    }
                    case 3: {
                        s1 = li1.getTyp().toString();
                        s2 = li2.getTyp().toString();
                        break;
                    }
                    case 7: {
                        s1 = li1.getGroup();
                        s2 = li2.getGroup();
                        break;
                    }
                    default: {
                        s1 = li1.getName();
                        s2 = li2.getName();
                    }
                }
                int res = s1.compareToIgnoreCase(s2);
                if (res == 0) {
                    try {
                        Integer no1 = Integer.parseInt(li1.getPrio());
                        Integer no2 = Integer.parseInt(li2.getPrio());
                        return no1.compareTo(no2);
                    }
                    catch (NumberFormatException nfe) {
                        return li1.getPrio().compareToIgnoreCase(li2.getPrio());
                    }
                }
                return res;
            }
        });
        int operations = 1;
        Transfer[] transferTypes = new Transfer[]{TextTransfer.getInstance()};
        this.tableViewer.addDragSupport(operations, transferTypes, (DragSourceListener)new DragSourceAdapter(){

            public void dragSetData(DragSourceEvent event) {
                IStructuredSelection selection = (IStructuredSelection)LaborPrefs.this.tableViewer.getSelection();
                LabItem labItem = (LabItem)selection.getFirstElement();
                if (TextTransfer.getInstance().isSupportedType(event.dataType)) {
                    event.data = String.valueOf(labItem.getKuerzel()) + "," + labItem.getName() + "," + labItem.getId();
                }
            }
        });
        this.tableViewer.setInput((Object)this);
        return tableComposite;
    }

    protected void contributeButtons(Composite parent) {
        Button bImportMapping;
        ++((GridLayout)parent.getLayout()).numColumns;
        Button bMappingFrom2_1_7 = new Button(parent, 8);
        bMappingFrom2_1_7.setText(Messages.LaborPrefs_mappingFrom2_1_7);
        bMappingFrom2_1_7.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getService(IHandlerService.class);
                    handlerService.executeCommand("ch.elexis.mapping.2_1_7.create", null);
                }
                catch (Exception ex) {
                    throw new RuntimeException("ch.elexis.mapping.2_1_7.create", ex);
                }
                LaborPrefs.this.tableViewer.refresh();
            }
        });
        if (CoreHub.acl.request(AccessControlDefaults.LABITEM_MERGE)) {
            ++((GridLayout)parent.getLayout()).numColumns;
            bImportMapping = new Button(parent, 8);
            bImportMapping.setText(Messages.LaborPrefs_mergeLabItems);
            bImportMapping.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    try {
                        IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getService(IHandlerService.class);
                        handlerService.executeCommand("ch.elexis.labitem.merge", null);
                    }
                    catch (Exception ex) {
                        throw new RuntimeException("ch.elexis.labitem.merge", ex);
                    }
                    LaborPrefs.this.tableViewer.refresh();
                }
            });
        }
        ++((GridLayout)parent.getLayout()).numColumns;
        bImportMapping = new Button(parent, 8);
        bImportMapping.setText(Messages.LaborPrefs_importLabMapping);
        bImportMapping.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getService(IHandlerService.class);
                    handlerService.executeCommand("ch.elexis.labmapping.import", null);
                }
                catch (Exception ex) {
                    throw new RuntimeException("ch.elexis.labmapping.import", ex);
                }
                LaborPrefs.this.tableViewer.refresh();
            }
        });
        ++((GridLayout)parent.getLayout()).numColumns;
        Button bNewItem = new Button(parent, 8);
        bNewItem.setText(Messages.LaborPrefs_labValue);
        bNewItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getService(IHandlerService.class);
                    handlerService.executeCommand("ch.elexis.labitem.create", null);
                }
                catch (Exception ex) {
                    throw new RuntimeException("ch.elexis.labitem.create", ex);
                }
                LaborPrefs.this.tableViewer.refresh();
            }
        });
        ++((GridLayout)parent.getLayout()).numColumns;
        Button bDelItem = new Button(parent, 8);
        bDelItem.setText(Messages.LaborPrefs_deleteItem);
        bDelItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection sel = (IStructuredSelection)LaborPrefs.this.tableViewer.getSelection();
                Object o = sel.getFirstElement();
                if (o instanceof LabItem) {
                    LabItem li = (LabItem)o;
                    if (MessageDialog.openQuestion((Shell)LaborPrefs.this.getShell(), (String)Messages.LaborPrefs_deleteItem, (String)MessageFormat.format(Messages.LaborPrefs_deleteReallyItem, li.getLabel()))) {
                        if (LaborPrefs.this.deleteResults(li)) {
                            LaborPrefs.this.deleteMappings(li);
                            li.delete();
                            LaborPrefs.this.tableViewer.remove((Object)li);
                        } else {
                            MessageDialog.openWarning((Shell)LaborPrefs.this.getShell(), (String)Messages.LaborPrefs_deleteItem, (String)Messages.LaborPrefs_deleteFail);
                        }
                    }
                }
            }
        });
        ++((GridLayout)parent.getLayout()).numColumns;
        Button bDelAllItems = new Button(parent, 8);
        bDelAllItems.setText(Messages.LaborPrefs_deleteAllItems);
        bDelAllItems.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (SWTHelper.askYesNo((String)Messages.LaborPrefs_deleteReallyAllItems, (String)Messages.LaborPrefs_deleteAllExplain)) {
                    Query qbli = new Query(LabItem.class);
                    List items = qbli.execute();
                    boolean success = true;
                    for (LabItem li : items) {
                        if (LaborPrefs.this.deleteResults(li)) {
                            LaborPrefs.this.deleteMappings(li);
                            li.delete();
                            continue;
                        }
                        success = false;
                    }
                    if (!success) {
                        MessageDialog.openWarning((Shell)LaborPrefs.this.getShell(), (String)Messages.LaborPrefs_deleteAllItems, (String)Messages.LaborPrefs_deleteFail);
                    }
                    LaborPrefs.this.tableViewer.refresh();
                }
            }
        });
        if (!CoreHub.acl.request(AccessControlDefaults.DELETE_LABITEMS)) {
            bDelAllItems.setEnabled(false);
        }
    }

    private boolean deleteResults(LabItem li) {
        boolean ret = true;
        Query qbe = new Query(LabResult.class);
        qbe.add("ItemID", "=", li.getId());
        List list = qbe.execute();
        for (LabResult po : list) {
            if (CoreHub.getLocalLockService().acquireLock((IPersistentObject)po).isOk()) {
                po.delete();
                CoreHub.getLocalLockService().releaseLock((IPersistentObject)po);
                continue;
            }
            ret = false;
        }
        return ret;
    }

    private void deleteMappings(LabItem li) {
        Query qbe = new Query(LabMapping.class);
        qbe.add("labitemid", "=", li.getId());
        List list = qbe.execute();
        for (LabMapping po : list) {
            po.delete();
        }
    }

    public void init(IWorkbench workbench) {
    }

    public Point computeSize() {
        return new Point(350, 350);
    }

    static class LabListLabelProvider
    extends ColumnLabelProvider
    implements ITableLabelProvider {
        LabListLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            LabItem li = (LabItem)element;
            String[] values = li.get(true, new String[]{"titel", "kuerzel", "loinccode", "Einheit", "RefMann", "RefFrauOrTx", "Gruppe", "prio"});
            String name = values[0];
            String kuerzel = values[1];
            String loinccode = values[2];
            String einheit = values[3];
            String refM = values[4];
            String refF = values[5].split("##")[0];
            String groupPrio = String.valueOf(values[6]) + " - " + values[7];
            switch (columnIndex) {
                case 0: {
                    return name;
                }
                case 1: {
                    return kuerzel;
                }
                case 2: {
                    return loinccode;
                }
                case 3: {
                    LabItemTyp typ = li.getTyp();
                    if (typ == LabItemTyp.NUMERIC) {
                        return Messages.LaborPrefs_numeric;
                    }
                    if (typ == LabItemTyp.TEXT) {
                        return Messages.LaborPrefs_alpha;
                    }
                    if (typ == LabItemTyp.FORMULA) {
                        return Messages.LaborPrefs_formula;
                    }
                    if (typ == LabItemTyp.DOCUMENT) {
                        return Messages.LaborPrefs_document;
                    }
                    return Messages.LaborPrefs_absolute;
                }
                case 4: {
                    return einheit;
                }
                case 5: {
                    return refM;
                }
                case 6: {
                    return refF;
                }
                case 7: {
                    return groupPrio;
                }
            }
            return "?col?";
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public Color getBackground(Object element) {
            LabItem li = (LabItem)element;
            if (li.isVisible()) {
                return Display.getCurrent().getSystemColor(1);
            }
            return Display.getCurrent().getSystemColor(15);
        }
    }
}

