/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.laboratory.controls.util;

import ch.elexis.core.model.IPersistentObject;
import ch.elexis.core.types.LabItemTyp;
import ch.elexis.core.ui.laboratory.controls.LaborOrderViewerItem;
import ch.elexis.core.ui.laboratory.controls.Messages;
import ch.elexis.core.ui.locks.AcquireLockBlockingUi;
import ch.elexis.core.ui.locks.ILockHandler;
import ch.elexis.data.Kontakt;
import ch.elexis.data.LabOrder;
import ch.elexis.data.LabResult;
import ch.rgw.tools.TimeTool;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.FocusCellHighlighter;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SWTFocusCellManager;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerEditor;
import org.eclipse.jface.viewers.TableViewerFocusCellManager;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.ViewerRow;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class LabOrderEditingSupport
extends EditingSupport {
    protected final String SMALLER = "<";
    protected final String BIGGER = ">";
    protected TextCellEditor textCellEditor;
    protected TableViewerFocusCellManager focusCell;

    public LabOrderEditingSupport(ColumnViewer viewer) {
        super(viewer);
        this.setUpCellEditor(viewer);
        this.addValidator();
    }

    protected void addValidator() {
        this.textCellEditor.setValidator(new ICellEditorValidator(){

            public String isValid(Object value) {
                IStructuredSelection selection = (IStructuredSelection)LabOrderEditingSupport.this.getViewer().getSelection();
                LaborOrderViewerItem viewerItem = (LaborOrderViewerItem)selection.getFirstElement();
                if (viewerItem != null && value instanceof String && (viewerItem.getLabItemTyp() == LabItemTyp.NUMERIC || viewerItem.getLabItemTyp() == LabItemTyp.ABSOLUTE)) {
                    try {
                        String editedValue = (String)value;
                        if (editedValue.startsWith("<") || editedValue.startsWith(">")) {
                            String nrValue = editedValue.replace("<", "").replace(">", "");
                            editedValue = nrValue.trim();
                        }
                        Float.parseFloat(editedValue);
                    }
                    catch (NumberFormatException e) {
                        return Messages.LaborOrdersComposite_validatorNotNumber;
                    }
                }
                return null;
            }
        });
    }

    protected void setUpCellEditor(ColumnViewer viewer) {
        this.textCellEditor = new TextCellEditor((Composite)viewer.getControl());
        this.textCellEditor.addListener(new ICellEditorListener(){

            public void editorValueChanged(boolean oldValidState, boolean newValidState) {
                if (newValidState) {
                    LabOrderEditingSupport.this.textCellEditor.getControl().setBackground(Display.getCurrent().getSystemColor(1));
                } else {
                    LabOrderEditingSupport.this.textCellEditor.getControl().setBackground(Display.getCurrent().getSystemColor(3));
                }
            }

            public void cancelEditor() {
                LabOrderEditingSupport.this.textCellEditor.getControl().setBackground(Display.getCurrent().getSystemColor(1));
            }

            public void applyEditorValue() {
                LabOrderEditingSupport.this.textCellEditor.getControl().setBackground(Display.getCurrent().getSystemColor(1));
            }
        });
        this.focusCell = new TableViewerFocusCellManager((TableViewer)viewer, new FocusCellHighlighter(viewer){});
        ColumnViewerEditorActivationStrategy actSupport = new ColumnViewerEditorActivationStrategy(viewer){

            protected boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
                return event.eventType == 5 || event.eventType == 3 || event.eventType == 1 && event.keyCode == 13 || event.eventType == 1 && event.keyCode == 0x1000050 || event.eventType == 4;
            }
        };
        TableViewerEditor.create((TableViewer)((TableViewer)viewer), (SWTFocusCellManager)this.focusCell, (ColumnViewerEditorActivationStrategy)actSupport, (int)40);
    }

    protected boolean canEdit(Object element) {
        return element instanceof LaborOrderViewerItem && ((LaborOrderViewerItem)element).getLabItemTyp() != LabItemTyp.FORMULA;
    }

    protected CellEditor getCellEditor(Object element) {
        if (element instanceof LaborOrderViewerItem) {
            LaborOrderViewerItem viewerItem = (LaborOrderViewerItem)element;
            if (viewerItem.getLabItemTyp() == LabItemTyp.DOCUMENT) {
                return null;
            }
            return this.textCellEditor;
        }
        return null;
    }

    protected Object getValue(Object element) {
        if (element instanceof LaborOrderViewerItem) {
            LaborOrderViewerItem viewerItem = (LaborOrderViewerItem)element;
            if (viewerItem.getLabItemTyp() == LabItemTyp.DOCUMENT) {
                return "Doc";
            }
            if (viewerItem.getLabItemTyp() == LabItemTyp.TEXT) {
                LabResult result = viewerItem.getLabResult();
                if (result != null) {
                    return result.getComment();
                }
            } else {
                LabResult result = viewerItem.getLabResult();
                if (result != null) {
                    return result.getResult();
                }
            }
        }
        return "";
    }

    protected void setValue(Object element, final Object value) {
        final LaborOrderViewerItem viewerItem = this.getSelectedItem();
        if (viewerItem instanceof LaborOrderViewerItem && value != null) {
            LabResult result = viewerItem.getLabResult();
            if (result == null) {
                result = this.createResult(viewerItem, LabOrder.getOrCreateManualLabor());
            }
            final LabResult lockResult = result;
            AcquireLockBlockingUi.aquireAndRun((IPersistentObject)result, (ILockHandler)new ILockHandler(){

                public void lockFailed() {
                }

                public void lockAcquired() {
                    if (lockResult.getItem().getTyp() == LabItemTyp.TEXT) {
                        lockResult.setResult("Text");
                        lockResult.set("Kommentar", value.toString());
                        viewerItem.setState(LabOrder.State.DONE);
                    } else if (lockResult.getItem().getTyp() != LabItemTyp.DOCUMENT) {
                        lockResult.setResult(value.toString());
                        viewerItem.setState(LabOrder.State.DONE);
                    }
                }
            });
            int columnIdx = this.focusCell.getFocusCell().getColumnIndex();
            ViewerRow row = this.focusCell.getFocusCell().getViewerRow();
            ViewerRow nextRow = row.getNeighbor(2, true);
            viewerItem.refreshResultString();
            if (nextRow != null) {
                this.getViewer().setSelection((ISelection)new StructuredSelection(nextRow.getElement()), true);
                this.getViewer().editElement(nextRow.getElement(), columnIdx);
            }
        }
    }

    private LaborOrderViewerItem getSelectedItem() {
        ISelection selection = this.getViewer().getSelection();
        if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
            return (LaborOrderViewerItem)((IStructuredSelection)selection).getFirstElement();
        }
        return null;
    }

    private LabResult createResult(LaborOrderViewerItem viewerItem, Kontakt origin) {
        LabResult result = viewerItem.createResult(origin);
        result.setTransmissionTime(new TimeTool());
        return result;
    }
}

