/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.views.rechnung;

import ch.elexis.core.data.events.ElexisEvent;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.events.ElexisEventListener;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.actions.GlobalActions;
import ch.elexis.core.ui.actions.GlobalEventDispatcher;
import ch.elexis.core.ui.actions.IActivationListener;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.util.ViewMenus;
import ch.elexis.core.ui.views.rechnung.Messages;
import ch.elexis.data.Patient;
import ch.elexis.data.Rechnung;
import ch.elexis.data.RnStatus;
import ch.elexis.data.Zahlung;
import ch.rgw.tools.Money;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.ISaveablePart2;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.part.ViewPart;

public class BillSummary
extends ViewPart
implements IActivationListener,
ElexisEventListener,
ISaveablePart2 {
    public static final String ID = "ch.elexis.views.rechnung.BillSummary";
    private static final String COMMAND_COPY = "org.eclipse.ui.edit.copy";
    private FormToolkit tk;
    private Form form;
    private Label totalLabel;
    private Label paidLabel;
    private Label openLabel;
    private TableViewer billsViewer;
    private Patient actPatient;
    private Action exportToClipboardAction;
    private static final int NUMBER = 0;
    private static final int DATE = 1;
    private static final int AMOUNT = 2;
    private static final int AMOUNT_DUE = 3;
    private static final int STATUS = 4;
    private static final int GARANT = 5;
    private static boolean bReverse = true;
    private static final String[] COLUMN_TEXT = new String[]{Messages.BillSummary_number, Messages.BillSummary_date, Messages.BillSummary_amount, Messages.BillSummary_open, Messages.BillSummary_state, Messages.BillSummary_receiver};
    private static final int[] COLUMN_WIDTH = new int[]{80, 80, 80, 80, 80, 80};
    private final ElexisEvent eetmpl = new ElexisEvent(null, Patient.class, 48);

    private List<Rechnung> getRechnungen(Patient patient) {
        List rechnungen = patient.getRechnungen();
        Collections.sort(rechnungen, new Comparator<Rechnung>(){

            @Override
            public int compare(Rechnung r1, Rechnung r2) {
                if (r1 == null && r2 == null) {
                    return 0;
                }
                if (r1 == null) {
                    return bReverse ? -1 : 1;
                }
                if (r2 == null) {
                    return bReverse ? 1 : -1;
                }
                try {
                    Integer number1 = new Integer(r1.getNr());
                    Integer number2 = new Integer(r2.getNr());
                    return bReverse ? number2.compareTo(number1) : number1.compareTo(number2);
                }
                catch (NumberFormatException ex) {
                    return 0;
                }
            }

            @Override
            public boolean equals(Object obj) {
                return this == obj;
            }
        });
        return rechnungen;
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        this.tk = UiDesk.getToolkit();
        this.form = this.tk.createForm(parent);
        this.form.getBody().setLayout((Layout)new GridLayout(1, false));
        Composite generalArea = this.tk.createComposite(this.form.getBody());
        generalArea.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
        generalArea.setLayout((Layout)new GridLayout(2, false));
        this.tk.createLabel(generalArea, Messages.BillSummary_total);
        this.totalLabel = this.tk.createLabel(generalArea, "");
        this.totalLabel.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
        this.tk.createLabel(generalArea, Messages.BillSummary_paid);
        this.paidLabel = this.tk.createLabel(generalArea, "");
        this.paidLabel.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
        this.tk.createLabel(generalArea, Messages.BillSummary_open2);
        this.openLabel = this.tk.createLabel(generalArea, "");
        this.openLabel.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
        this.billsViewer = new TableViewer(this.form.getBody(), 65540);
        Table table = this.billsViewer.getTable();
        table.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, true));
        this.tk.adapt((Composite)table);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableColumn[] tc = new TableColumn[COLUMN_TEXT.length];
        int i = 0;
        while (i < COLUMN_TEXT.length) {
            tc[i] = new TableColumn(table, 0);
            tc[i].setText(COLUMN_TEXT[i]);
            tc[i].setWidth(COLUMN_WIDTH[i]);
            ++i;
        }
        SortListener sortListener = new SortListener();
        tc[1].addSelectionListener((SelectionListener)sortListener);
        this.billsViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (BillSummary.this.actPatient == null) {
                    return new Object[]{Messages.BillSummary_NoPatientSelected};
                }
                return BillSummary.this.getRechnungen(BillSummary.this.actPatient).toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.billsViewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public void addListener(ILabelProviderListener listener) {
            }

            public void removeListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public String getColumnText(Object element, int columnIndex) {
                if (!(element instanceof Rechnung)) {
                    return "";
                }
                Rechnung rechnung = (Rechnung)element;
                String text = "";
                switch (columnIndex) {
                    case 0: {
                        text = rechnung.get("RnNummer");
                        break;
                    }
                    case 1: {
                        text = rechnung.get("RnDatum");
                        break;
                    }
                    case 2: {
                        text = rechnung.getBetrag().toString();
                        break;
                    }
                    case 3: {
                        text = rechnung.getOffenerBetrag().toString();
                        break;
                    }
                    case 4: {
                        text = RnStatus.getStatusText((int)rechnung.getStatus());
                        break;
                    }
                    case 5: {
                        text = rechnung.getFall().getGarant().getLabel();
                    }
                }
                return text;
            }

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }
        });
        this.billsViewer.setInput((Object)this.getViewSite());
        this.makeActions();
        ViewMenus menu = new ViewMenus(this.getViewSite());
        menu.createMenu(new IAction[]{this.exportToClipboardAction});
        GlobalEventDispatcher.addActivationListener(this, (IWorkbenchPart)this);
        this.billsViewer.addSelectionChangedListener((ISelectionChangedListener)GlobalEventDispatcher.getInstance().getDefaultListener());
    }

    public void setFocus() {
        this.billsViewer.getControl().setFocus();
    }

    public void dispose() {
        GlobalEventDispatcher.removeActivationListener(this, (IWorkbenchPart)this);
        this.billsViewer.removeSelectionChangedListener((ISelectionChangedListener)GlobalEventDispatcher.getInstance().getDefaultListener());
        super.dispose();
    }

    private void setPatient(Patient patient) {
        this.actPatient = patient;
        String title = "";
        title = this.actPatient != null ? this.actPatient.getLabel() : Messages.BillSummary_NoPatientSelected;
        this.form.setText(title);
        this.setGeneralText();
        this.billsViewer.refresh();
        this.form.layout();
    }

    private void setGeneralText() {
        if (this.totalLabel.isDisposed() || this.paidLabel.isDisposed() || this.openLabel.isDisposed()) {
            return;
        }
        String totalText = "";
        String paidText = "";
        String openText = "";
        if (this.actPatient != null) {
            Money total = new Money(0);
            Money paid = new Money(0);
            List rechnungen = this.actPatient.getRechnungen();
            for (Rechnung rechnung : rechnungen) {
                if (rechnung.getStatus() == 18) continue;
                total.addMoney(rechnung.getBetrag());
                for (Zahlung zahlung : rechnung.getZahlungen()) {
                    paid.addMoney(zahlung.getBetrag());
                }
            }
            Money open = new Money(total);
            open.subtractMoney(paid);
            totalText = total.toString();
            paidText = paid.toString();
            openText = open.toString();
        }
        this.totalLabel.setText(totalText);
        this.paidLabel.setText(paidText);
        this.openLabel.setText(openText);
    }

    @Override
    public void activation(boolean mode) {
    }

    @Override
    public void visible(boolean mode) {
        if (mode) {
            ElexisEventDispatcher.getInstance().addListeners(new ElexisEventListener[]{this});
            Patient patient = ElexisEventDispatcher.getSelectedPatient();
            this.setPatient(patient);
        } else {
            ElexisEventDispatcher.getInstance().removeListeners(new ElexisEventListener[]{this});
            this.setPatient(null);
        }
    }

    public int promptToSaveOnClose() {
        return GlobalActions.fixLayoutAction.isChecked() ? 2 : 1;
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return true;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        return true;
    }

    private void makeActions() {
        this.exportToClipboardAction = new Action(Messages.BillSummary_exportToClipboard){
            {
                this.setToolTipText(Messages.BillSummary_SummaryToClipboard);
            }

            public void run() {
                BillSummary.this.exportToClipboard();
            }
        };
        this.exportToClipboardAction.setActionDefinitionId(COMMAND_COPY);
        GlobalActions.registerActionHandler(this, (IAction)this.exportToClipboardAction);
    }

    private void exportToClipboard() {
        String clipboardText = "";
        String lineSeparator = System.getProperty("line.separator");
        if (this.actPatient != null) {
            List<Rechnung> rechnungen = this.getRechnungen(this.actPatient);
            StringBuffer sbTable = new StringBuffer();
            StringBuffer sbHeader = new StringBuffer();
            sbHeader.append(COLUMN_TEXT[0]);
            sbHeader.append("\t");
            sbHeader.append(COLUMN_TEXT[1]);
            sbHeader.append("\t");
            sbHeader.append(COLUMN_TEXT[2]);
            sbHeader.append("\t");
            sbHeader.append(COLUMN_TEXT[3]);
            sbHeader.append("\t");
            sbHeader.append(COLUMN_TEXT[4]);
            sbHeader.append("\t");
            sbHeader.append(COLUMN_TEXT[5]);
            sbHeader.append(lineSeparator);
            sbTable.append(sbHeader);
            for (Rechnung rechnung : rechnungen) {
                StringBuffer sbLine = new StringBuffer();
                sbLine.append(rechnung.get("RnNummer"));
                sbLine.append("\t");
                sbLine.append(rechnung.get("RnDatum"));
                sbLine.append("\t");
                sbLine.append(rechnung.getBetrag().toString());
                sbLine.append("\t");
                sbLine.append(rechnung.getOffenerBetrag().toString());
                sbLine.append("\t");
                sbLine.append(RnStatus.getStatusText((int)rechnung.getStatus()));
                sbLine.append("\t");
                sbLine.append(rechnung.getFall().getGarant().getLabel());
                sbLine.append(lineSeparator);
                sbTable.append(sbLine);
            }
            clipboardText = sbTable.toString();
        } else {
            clipboardText = Messages.BillSummary_noBillsAvailable;
        }
        Clipboard clipboard = new Clipboard(UiDesk.getDisplay());
        TextTransfer textTransfer = TextTransfer.getInstance();
        Transfer[] transfers = new Transfer[]{textTransfer};
        Object[] data = new Object[]{clipboardText};
        clipboard.setContents(data, transfers);
        clipboard.dispose();
    }

    public void catchElexisEvent(final ElexisEvent ev) {
        UiDesk.asyncExec(new Runnable(){

            @Override
            public void run() {
                if (ev.getType() == 16) {
                    BillSummary.this.setPatient((Patient)ev.getObject());
                } else if (ev.getType() == 32) {
                    BillSummary.this.setPatient(null);
                }
            }
        });
    }

    public ElexisEvent getElexisEventFilter() {
        return this.eetmpl;
    }

    class SortListener
    extends SelectionAdapter {
        SortListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            bReverse = !bReverse;
            BillSummary.this.billsViewer.refresh();
        }
    }
}

