/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.views;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.ElexisEvent;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.events.ElexisEventListener;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.actions.GlobalActions;
import ch.elexis.core.ui.actions.GlobalEventDispatcher;
import ch.elexis.core.ui.actions.IActivationListener;
import ch.elexis.core.ui.dialogs.DocumentSelectDialog;
import ch.elexis.core.ui.dialogs.SelectFallDialog;
import ch.elexis.core.ui.events.ElexisUiEventListenerImpl;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.locks.LockRequestingAction;
import ch.elexis.core.ui.services.LocalDocumentServiceHolder;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.util.ViewMenus;
import ch.elexis.core.ui.util.viewers.CommonViewer;
import ch.elexis.core.ui.util.viewers.DefaultContentProvider;
import ch.elexis.core.ui.util.viewers.DefaultControlFieldProvider;
import ch.elexis.core.ui.util.viewers.DefaultLabelProvider;
import ch.elexis.core.ui.util.viewers.SimpleWidgetProvider;
import ch.elexis.core.ui.util.viewers.ViewerConfigurer;
import ch.elexis.core.ui.views.Messages;
import ch.elexis.core.ui.views.TextView;
import ch.elexis.data.Brief;
import ch.elexis.data.Fall;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Kontakt;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Person;
import ch.elexis.data.Query;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.TimeTool;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.ISaveablePart2;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.part.ViewPart;

public class BriefAuswahl
extends ViewPart
implements ElexisEventListener,
IActivationListener,
ISaveablePart2 {
    public static final String ID = "ch.elexis.BriefAuswahlView";
    private final FormToolkit tk;
    private Form form;
    private Action briefNeuAction;
    private Action briefLadenAction;
    private Action editNameAction;
    private Action startLocalEditAction;
    private Action endLocalEditAction;
    private Action cancelLocalEditAction;
    private Action deleteAction;
    private ViewMenus menus;
    private ArrayList<sPage> pages = new ArrayList();
    CTabFolder ctab;
    private ElexisEventListener updateListener = new ElexisUiEventListenerImpl(Brief.class, 8){

        @Override
        public void runInUi(ElexisEvent ev) {
            BriefAuswahl.this.relabel();
        }
    };
    private static ElexisEvent template = new ElexisEvent(null, Patient.class, 48);

    public BriefAuswahl() {
        this.tk = UiDesk.getToolkit();
    }

    public void createPartControl(Composite parent) {
        StringBuilder sb = new StringBuilder();
        sb.append(Messages.BriefAuswahlAllLetters).append("Allg.").append(",").append("AUF-Zeugnis").append(",").append("Rezept").append(",").append("Labor");
        String cats = CoreHub.globalCfg.get("dokumente/kategorien", sb.toString());
        parent.setLayout((Layout)new GridLayout());
        this.form = this.tk.createForm(parent);
        this.form.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, true));
        this.form.setBackground(parent.getBackground());
        GridLayout slimLayout = new GridLayout();
        slimLayout.marginHeight = 0;
        slimLayout.marginWidth = 0;
        Composite body = this.form.getBody();
        body.setLayout((Layout)slimLayout);
        body.setBackground(parent.getBackground());
        this.ctab = new CTabFolder(body, 1024);
        this.ctab.setLayout((Layout)slimLayout);
        this.ctab.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, true));
        this.ctab.setBackground(parent.getBackground());
        this.makeActions();
        this.menus = new ViewMenus(this.getViewSite());
        String[] stringArray = cats.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String cat = stringArray[n2];
            CTabItem ct = new CTabItem(this.ctab, 0);
            ct.setText(cat);
            sPage page = new sPage((Composite)this.ctab, cat);
            this.pages.add(page);
            if (CoreHub.localCfg.get("briefe/Textmodul_Edit_Local", false)) {
                this.menus.createViewerContextMenu(page.cv.getViewerWidget(), new IAction[]{this.editNameAction, this.deleteAction, this.startLocalEditAction, this.endLocalEditAction, this.cancelLocalEditAction});
            } else {
                this.menus.createViewerContextMenu(page.cv.getViewerWidget(), new IAction[]{this.editNameAction, this.deleteAction});
            }
            ct.setData((Object)page.cv);
            ct.setControl((Control)page);
            page.cv.addDoubleClickListener(new CommonViewer.DoubleClickListener(){

                @Override
                public void doubleClicked(PersistentObject obj, CommonViewer cv) {
                    BriefAuswahl.this.briefLadenAction.run();
                }
            });
            ++n2;
        }
        this.ctab.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BriefAuswahl.this.relabel();
            }
        });
        GlobalEventDispatcher.addActivationListener(this, (IWorkbenchPart)this);
        this.menus.createMenu(new IAction[]{this.briefNeuAction, this.briefLadenAction, this.editNameAction, this.deleteAction});
        this.menus.createToolbar(new IAction[]{this.briefNeuAction, this.briefLadenAction, this.deleteAction});
        this.ctab.setSelection(0);
        this.relabel();
    }

    public void dispose() {
        ElexisEventDispatcher.getInstance().removeListeners(new ElexisEventListener[]{this});
        GlobalEventDispatcher.removeActivationListener(this, (IWorkbenchPart)this);
        for (sPage page : this.pages) {
            page.getCommonViewer().getConfigurer().getContentProvider().stopListening();
        }
    }

    public void setFocus() {
    }

    public void relabel() {
        UiDesk.asyncExec(new Runnable(){

            @Override
            public void run() {
                Patient pat = (Patient)ElexisEventDispatcher.getSelected(Patient.class);
                if (BriefAuswahl.this.form != null && !BriefAuswahl.this.form.isDisposed()) {
                    if (pat == null) {
                        BriefAuswahl.this.form.setText(Messages.BriefAuswahlNoPatientSelected);
                    } else {
                        BriefAuswahl.this.form.setText(pat.getLabel());
                        CTabItem sel = BriefAuswahl.this.ctab.getSelection();
                        if (sel != null) {
                            CommonViewer cv = (CommonViewer)sel.getData();
                            cv.notify(CommonViewer.Message.update);
                        }
                    }
                }
            }
        });
    }

    private void makeActions() {
        this.briefNeuAction = new Action(Messages.BriefAuswahlNewButtonText){

            public void run() {
                Konsultation selectedKonsultation;
                Patient pat = ElexisEventDispatcher.getSelectedPatient();
                if (pat == null) {
                    MessageDialog.openInformation((Shell)UiDesk.getTopShell(), (String)Messages.BriefAuswahlNoPatientSelected, (String)Messages.BriefAuswahlNoPatientSelected);
                    return;
                }
                Fall selectedFall = (Fall)ElexisEventDispatcher.getSelected(Fall.class);
                if (selectedFall == null) {
                    SelectFallDialog sfd = new SelectFallDialog(UiDesk.getTopShell());
                    sfd.open();
                    if (sfd.result != null) {
                        ElexisEventDispatcher.fireSelectionEvent((PersistentObject)sfd.result);
                    } else {
                        MessageDialog.openInformation((Shell)UiDesk.getTopShell(), (String)Messages.TextView_NoCaseSelected, (String)Messages.TextView_SaveNotPossibleNoCaseAndKonsSelected);
                        return;
                    }
                }
                if ((selectedKonsultation = (Konsultation)ElexisEventDispatcher.getSelected(Konsultation.class)) == null) {
                    Konsultation k = pat.getLetzteKons(false);
                    if (k == null) {
                        k = ((Fall)ElexisEventDispatcher.getSelected(Fall.class)).neueKonsultation();
                        k.setMandant(CoreHub.actMandant);
                    }
                    ElexisEventDispatcher.fireSelectionEvent((PersistentObject)k);
                }
                TextView tv = null;
                try {
                    DocumentSelectDialog bs = new DocumentSelectDialog(BriefAuswahl.this.getViewSite().getShell(), (Person)CoreHub.actMandant, 1);
                    if (bs.open() == 0) {
                        tv = (TextView)BriefAuswahl.this.getSite().getPage().showView("ch.elexis.TextView");
                        Kontakt address = null;
                        if (DocumentSelectDialog.getDontAskForAddresseeForThisTemplate(bs.getSelectedDocument())) {
                            address = Kontakt.load((String)"-1");
                        }
                        tv.createDocument(bs.getSelectedDocument(), bs.getBetreff(), address);
                        tv.setName();
                        CTabItem sel = BriefAuswahl.this.ctab.getSelection();
                        if (sel != null) {
                            CommonViewer cv = (CommonViewer)sel.getData();
                            cv.notify(CommonViewer.Message.update_keeplabels);
                        }
                    }
                }
                catch (Exception ex) {
                    ExHandler.handle((Throwable)ex);
                }
            }
        };
        this.briefLadenAction = new Action(Messages.BriefAuswahlOpenButtonText){

            public void run() {
                block20: {
                    try {
                        CTabItem sel = BriefAuswahl.this.ctab.getSelection();
                        if (sel == null) break block20;
                        CommonViewer cv = (CommonViewer)sel.getData();
                        Object[] o = cv.getSelection();
                        if (o != null && o.length > 0) {
                            Brief brief = (Brief)o[0];
                            if (CoreHub.localCfg.get("briefe/Textmodul_Edit_Local", false)) {
                                BriefAuswahl.this.startLocalEditAction.run();
                            } else {
                                TextView tv = (TextView)BriefAuswahl.this.getViewSite().getPage().showView("ch.elexis.TextView");
                                if (brief.getMimeType().equalsIgnoreCase("pdf")) {
                                    try {
                                        File temp = File.createTempFile("letter_", ".pdf");
                                        temp.deleteOnExit();
                                        Throwable throwable = null;
                                        Object var8_12 = null;
                                        try (FileOutputStream fos = new FileOutputStream(temp);){
                                            fos.write(brief.loadBinary());
                                        }
                                        catch (Throwable throwable2) {
                                            if (throwable == null) {
                                                throwable = throwable2;
                                            } else if (throwable != throwable2) {
                                                throwable.addSuppressed(throwable2);
                                            }
                                            throw throwable;
                                        }
                                        Program.launch((String)temp.getAbsolutePath());
                                    }
                                    catch (IOException e) {
                                        ExHandler.handle((Throwable)e);
                                        SWTHelper.alert(Messages.BriefAuswahlErrorHeading, Messages.BriefAuswahlCouldNotLoadText);
                                    }
                                } else if (!tv.openDocument(brief)) {
                                    SWTHelper.alert(Messages.BriefAuswahlErrorHeading, Messages.BriefAuswahlCouldNotLoadText);
                                }
                            }
                        } else {
                            TextView tv = (TextView)BriefAuswahl.this.getViewSite().getPage().showView("ch.elexis.TextView");
                            tv.createDocument(null, null);
                        }
                        cv.notify(CommonViewer.Message.update);
                    }
                    catch (PartInitException e) {
                        ExHandler.handle((Throwable)e);
                    }
                }
            }
        };
        this.deleteAction = new LockRequestingAction<Brief>(Messages.BriefAuswahlDeleteButtonText){

            @Override
            public void doRun(Brief brief) {
                if (brief != null && SWTHelper.askYesNo(Messages.BriefAuswahlDeleteConfirmHeading, Messages.BriefAuswahlDeleteConfirmText)) {
                    brief.delete();
                    CTabItem sel = BriefAuswahl.this.ctab.getSelection();
                    CommonViewer cv = (CommonViewer)sel.getData();
                    cv.notify(CommonViewer.Message.update);
                }
            }

            @Override
            public Brief getTargetedObject() {
                CommonViewer cv;
                Object[] o;
                CTabItem sel = BriefAuswahl.this.ctab.getSelection();
                if (sel != null && (o = (cv = (CommonViewer)sel.getData()).getSelection()) != null && o.length > 0 && o[0] instanceof Brief) {
                    return (Brief)o[0];
                }
                return null;
            }
        };
        this.editNameAction = new LockRequestingAction<Brief>(Messages.BriefAuswahlRenameButtonText){

            @Override
            public void doRun(Brief brief) {
                if (brief != null) {
                    InputDialog id = new InputDialog(BriefAuswahl.this.getViewSite().getShell(), Messages.BriefAuswahlNewSubjectHeading, Messages.BriefAuswahlNewSubjectText, brief.getBetreff(), null);
                    if (id.open() == 0) {
                        brief.setBetreff(id.getValue());
                    }
                    CTabItem sel = BriefAuswahl.this.ctab.getSelection();
                    CommonViewer cv = (CommonViewer)sel.getData();
                    cv.notify(CommonViewer.Message.update);
                }
            }

            @Override
            public Brief getTargetedObject() {
                CommonViewer cv;
                Object[] o;
                CTabItem sel = BriefAuswahl.this.ctab.getSelection();
                if (sel != null && (o = (cv = (CommonViewer)sel.getData()).getSelection()) != null && o.length > 0 && o[0] instanceof Brief) {
                    return (Brief)o[0];
                }
                return null;
            }
        };
        this.startLocalEditAction = new Action(){

            public ImageDescriptor getImageDescriptor() {
                return Images.IMG_EDIT.getImageDescriptor();
            }

            public String getText() {
                return Messages.BriefAuswahl_actionlocaledittext;
            }

            public void run() {
                Brief brief = BriefAuswahl.this.getSelectedBrief();
                if (brief != null) {
                    ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
                    Command command = commandService.getCommand("ch.elexis.core.ui.command.startEditLocalDocument");
                    ((IEclipseContext)PlatformUI.getWorkbench().getService(IEclipseContext.class)).set(command.getId().concat(".selection"), (Object)new StructuredSelection((Object)brief));
                    try {
                        command.executeWithChecks(new ExecutionEvent(command, Collections.EMPTY_MAP, (Object)this, null));
                    }
                    catch (ExecutionException | NotEnabledException | NotHandledException | NotDefinedException e) {
                        MessageDialog.openError((Shell)BriefAuswahl.this.getSite().getShell(), (String)Messages.BriefAuswahl_errorttile, (String)Messages.BriefAuswahl_erroreditmessage);
                    }
                    BriefAuswahl.this.refreshSelectedViewer();
                }
            }
        };
        this.endLocalEditAction = new Action(){

            public ImageDescriptor getImageDescriptor() {
                return Images.IMG_EDIT_DONE.getImageDescriptor();
            }

            public String getText() {
                return Messages.BriefAuswahl_actionlocaleditstopmessage;
            }

            public void run() {
                Brief brief = BriefAuswahl.this.getSelectedBrief();
                if (brief != null) {
                    ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
                    Command command = commandService.getCommand("ch.elexis.core.ui.command.endLocalDocument");
                    ((IEclipseContext)PlatformUI.getWorkbench().getService(IEclipseContext.class)).set(command.getId().concat(".selection"), (Object)new StructuredSelection((Object)brief));
                    try {
                        command.executeWithChecks(new ExecutionEvent(command, Collections.EMPTY_MAP, (Object)this, null));
                    }
                    catch (ExecutionException | NotEnabledException | NotHandledException | NotDefinedException e) {
                        MessageDialog.openError((Shell)BriefAuswahl.this.getSite().getShell(), (String)Messages.BriefAuswahl_errortitle, (String)Messages.BriefAuswahl_errorlocaleditendmessage);
                    }
                }
                BriefAuswahl.this.refreshSelectedViewer();
            }
        };
        this.cancelLocalEditAction = new Action(){

            public ImageDescriptor getImageDescriptor() {
                return Images.IMG_EDIT_ABORT.getImageDescriptor();
            }

            public String getText() {
                return Messages.BriefAuswahl_actionlocaleditabortmessage;
            }

            public void run() {
                Brief brief = BriefAuswahl.this.getSelectedBrief();
                if (brief != null) {
                    ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
                    Command command = commandService.getCommand("ch.elexis.core.ui.command.abortLocalDocument");
                    ((IEclipseContext)PlatformUI.getWorkbench().getService(IEclipseContext.class)).set(command.getId().concat(".selection"), (Object)new StructuredSelection((Object)brief));
                    try {
                        command.executeWithChecks(new ExecutionEvent(command, Collections.EMPTY_MAP, (Object)this, null));
                    }
                    catch (ExecutionException | NotEnabledException | NotHandledException | NotDefinedException e) {
                        MessageDialog.openError((Shell)BriefAuswahl.this.getSite().getShell(), (String)Messages.BriefAuswahl_errortitle, (String)Messages.BriefAuswahl_errorlocaleditabortmessage);
                    }
                }
                BriefAuswahl.this.refreshSelectedViewer();
            }
        };
        this.briefLadenAction.setImageDescriptor(Images.IMG_DOCUMENT_TEXT.getImageDescriptor());
        this.briefLadenAction.setToolTipText(Messages.BriefAuswahlOpenLetterForEdit);
        this.briefNeuAction.setImageDescriptor(Images.IMG_DOCUMENT_ADD.getImageDescriptor());
        this.briefNeuAction.setToolTipText(Messages.BriefAuswahlCreateNewDocument);
        this.editNameAction.setImageDescriptor(Images.IMG_DOCUMENT_WRITE.getImageDescriptor());
        this.editNameAction.setToolTipText(Messages.BriefAuswahlRenameDocument);
        this.deleteAction.setImageDescriptor(Images.IMG_DOCUMENT_REMOVE.getImageDescriptor());
        this.deleteAction.setToolTipText(Messages.BriefAuswahlDeleteDocument);
    }

    public Brief getSelectedBrief() {
        CommonViewer cv;
        Object[] o;
        CTabItem sel = this.ctab.getSelection();
        if (sel != null && (o = (cv = (CommonViewer)sel.getData()).getSelection()) != null && o.length > 0 && o[0] instanceof Brief) {
            return (Brief)o[0];
        }
        return null;
    }

    public void refreshSelectedViewer() {
        CTabItem sel = this.ctab.getSelection();
        if (sel != null) {
            CommonViewer cv = (CommonViewer)sel.getData();
            cv.notify(CommonViewer.Message.update);
        }
    }

    @Override
    public void activation(boolean mode) {
    }

    @Override
    public void visible(boolean mode) {
        if (mode) {
            ElexisEventDispatcher.getInstance().addListeners(new ElexisEventListener[]{this});
            ElexisEventDispatcher.getInstance().addListeners(new ElexisEventListener[]{this.updateListener});
            this.relabel();
        } else {
            ElexisEventDispatcher.getInstance().removeListeners(new ElexisEventListener[]{this});
            ElexisEventDispatcher.getInstance().removeListeners(new ElexisEventListener[]{this.updateListener});
        }
    }

    public int promptToSaveOnClose() {
        return GlobalActions.fixLayoutAction.isChecked() ? 2 : 1;
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return true;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        return true;
    }

    public void catchElexisEvent(ElexisEvent ev) {
        this.relabel();
    }

    public ElexisEvent getElexisEventFilter() {
        return template;
    }

    class sPage
    extends Composite {
        private TableViewer tableViewer;
        private LetterViewerComparator comparator;
        private final CommonViewer cv;
        private final ViewerConfigurer vc;

        public CommonViewer getCommonViewer() {
            return this.cv;
        }

        sPage(Composite parent, final String cat) {
            super(parent, 0);
            this.setLayout((Layout)new GridLayout());
            this.cv = new CommonViewer();
            this.vc = new ViewerConfigurer(new DefaultContentProvider(this.cv, Brief.class, new String[]{"Datum"}, true){

                @Override
                public Object[] getElements(Object inputElement) {
                    Patient actPat = (Patient)ElexisEventDispatcher.getSelected(Patient.class);
                    if (actPat != null) {
                        Query qbe = new Query(Brief.class);
                        qbe.add("PatientID", "=", actPat.getId());
                        if (cat.equals(Messages.BriefAuswahlAllLetters2)) {
                            qbe.add("Typ", "<>", "Vorlagen");
                        } else {
                            qbe.add("Typ", "=", cat);
                        }
                        this.cv.getConfigurer().getControlFieldProvider().setQuery((Query<? extends PersistentObject>)qbe);
                        List list = qbe.execute();
                        return list.toArray();
                    }
                    return new Brief[0];
                }
            }, new DefaultLabelProvider(), new DefaultControlFieldProvider(this.cv, new String[]{"Betreff=Titel"}), new ViewerConfigurer.DefaultButtonProvider(), new SimpleWidgetProvider(2, 66048, this.cv));
            this.cv.create(this.vc, this, 0, BriefAuswahl.this.getViewSite());
            this.tableViewer = (TableViewer)this.cv.getViewerWidget();
            this.tableViewer.getTable().setHeaderVisible(true);
            this.createColumns();
            this.comparator = new LetterViewerComparator();
            this.tableViewer.setComparator((ViewerComparator)this.comparator);
            if (CoreHub.localCfg.get("briefe/rename_with_f2", false)) {
                this.tableViewer.getTable().addKeyListener(new KeyListener(){

                    public void keyPressed(KeyEvent e) {
                    }

                    public void keyReleased(KeyEvent e) {
                        if (e.keyCode == 0x100000B) {
                            BriefAuswahl.this.editNameAction.run();
                        }
                    }
                });
            }
            this.vc.getContentProvider().startListening();
            Button bLoad = BriefAuswahl.this.tk.createButton((Composite)this, Messages.BriefAuswahlLoadButtonText, 8);
            bLoad.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    BriefAuswahl.this.briefLadenAction.run();
                }
            });
            bLoad.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
        }

        private void createColumns() {
            TableViewerColumn col = new TableViewerColumn(this.tableViewer, 0);
            col.getColumn().setText(Messages.BriefAuswahlColumnDate);
            col.getColumn().setWidth(100);
            col.getColumn().addSelectionListener((SelectionListener)this.getSelectionAdapter(col.getColumn(), 0));
            col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                public String getText(Object element) {
                    Brief b = (Brief)element;
                    return b.getDatum();
                }
            });
            col = new TableViewerColumn(this.tableViewer, 0);
            col.getColumn().setText(Messages.BriefAuswahlColumnTitle);
            col.getColumn().setWidth(300);
            col.getColumn().addSelectionListener((SelectionListener)this.getSelectionAdapter(col.getColumn(), 1));
            col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                public String getText(Object element) {
                    Brief b = (Brief)element;
                    return b.getBetreff();
                }

                public Image getImage(Object element) {
                    if (LocalDocumentServiceHolder.getService().isPresent() && LocalDocumentServiceHolder.getService().get().contains(element)) {
                        return Images.IMG_EDIT.getImage();
                    }
                    return super.getImage(element);
                }
            });
        }

        private SelectionAdapter getSelectionAdapter(final TableColumn column, final int index) {
            SelectionAdapter selectionAdapter = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    sPage.this.comparator.setColumn(index);
                    sPage.this.tableViewer.getTable().setSortDirection(sPage.this.comparator.getDirection());
                    sPage.this.tableViewer.getTable().setSortColumn(column);
                    sPage.this.tableViewer.refresh();
                }
            };
            return selectionAdapter;
        }

        class LetterViewerComparator
        extends ViewerComparator {
            private int propertyIndex = 0;
            private boolean direction = true;
            private TimeTool time1 = new TimeTool();
            private TimeTool time2 = new TimeTool();

            public int getDirection() {
                return this.direction ? 1024 : 128;
            }

            public void setColumn(int column) {
                if (column == this.propertyIndex) {
                    this.direction = !this.direction;
                } else {
                    this.propertyIndex = column;
                    this.direction = true;
                }
            }

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof Brief && e2 instanceof Brief) {
                    Brief b1 = (Brief)e1;
                    Brief b2 = (Brief)e2;
                    int rc = 0;
                    switch (this.propertyIndex) {
                        case 0: {
                            this.time1.set(b1.getDatum());
                            this.time2.set(b2.getDatum());
                            rc = this.time1.compareTo((Calendar)this.time2);
                            break;
                        }
                        case 1: {
                            rc = b1.getBetreff().compareTo(b2.getBetreff());
                            break;
                        }
                        default: {
                            rc = 0;
                        }
                    }
                    if (this.direction) {
                        rc = -rc;
                    }
                    return rc;
                }
                return 0;
            }
        }
    }
}

