/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.util;

import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;

public class DelegatingSelectionProvider
implements ISelectionProvider {
    private final ListenerList selectionListeners = new ListenerList();
    private final ListenerList postSelectionListeners = new ListenerList();
    private ISelectionProvider delegate;
    private ISelectionChangedListener selectionListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            if (event.getSelectionProvider() == DelegatingSelectionProvider.this.delegate) {
                DelegatingSelectionProvider.this.fireSelectionChanged(event.getSelection());
            }
        }
    };
    private ISelectionChangedListener postSelectionListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            if (event.getSelectionProvider() == DelegatingSelectionProvider.this.delegate) {
                DelegatingSelectionProvider.this.firePostSelectionChanged(event.getSelection());
            }
        }
    };

    public void setSelectionProviderDelegate(ISelectionProvider newDelegate) {
        if (this.delegate == newDelegate) {
            return;
        }
        if (this.delegate != null) {
            this.delegate.removeSelectionChangedListener(this.selectionListener);
            if (this.delegate instanceof IPostSelectionProvider) {
                ((IPostSelectionProvider)this.delegate).removePostSelectionChangedListener(this.postSelectionListener);
            }
        }
        this.delegate = newDelegate;
        if (newDelegate != null) {
            newDelegate.addSelectionChangedListener(this.selectionListener);
            if (newDelegate instanceof IPostSelectionProvider) {
                ((IPostSelectionProvider)newDelegate).addPostSelectionChangedListener(this.postSelectionListener);
            }
            this.fireSelectionChanged(newDelegate.getSelection());
            this.firePostSelectionChanged(newDelegate.getSelection());
        }
    }

    protected void fireSelectionChanged(ISelection selection) {
        this.fireSelectionChanged(this.selectionListeners, selection);
    }

    protected void firePostSelectionChanged(ISelection selection) {
        this.fireSelectionChanged(this.postSelectionListeners, selection);
    }

    private void fireSelectionChanged(ListenerList list, ISelection selection) {
        SelectionChangedEvent event = new SelectionChangedEvent(this.delegate, selection);
        Object[] listeners = list.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ISelectionChangedListener listener = (ISelectionChangedListener)listeners[i];
            listener.selectionChanged(event);
            ++i;
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.add((Object)listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.remove((Object)listener);
    }

    public void addPostSelectionChangedListener(ISelectionChangedListener listener) {
        this.postSelectionListeners.add((Object)listener);
    }

    public void removePostSelectionChangedListener(ISelectionChangedListener listener) {
        this.postSelectionListeners.remove((Object)listener);
    }

    public ISelection getSelection() {
        return this.delegate == null ? null : this.delegate.getSelection();
    }

    public void setSelection(ISelection selection) {
        if (this.delegate != null) {
            this.delegate.setSelection(selection);
        }
    }
}

