/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.preferences;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.interfaces.ShutdownJob;
import ch.elexis.core.ui.Hub;
import ch.elexis.core.ui.preferences.Messages;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.NamedBlob;
import ch.rgw.io.FileTool;
import ch.rgw.io.InMemorySettings;
import ch.rgw.io.Settings;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.StringTool;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class UserPreferences
extends PreferencePage
implements IWorkbenchPreferencePage {
    Button bLoad;
    Button bSave;
    Button bWorkspaceLoad;
    Button bWorkspaceSave;
    Combo cbUserSave;
    Combo cbWSSave;
    Combo cbUserLoad;
    Combo cbWSLoad;
    String[] userPrefs;
    String[] WSPrefs;

    public UserPreferences() {
        this.noDefaultAndApplyButton();
    }

    protected Control createContents(Composite parent) {
        final String layoutfile = String.valueOf(Platform.getInstanceLocation().getURL().getPath()) + File.separator + ".metadata" + File.separator + ".plugins" + File.separator + "org.eclipse.ui.workbench" + File.separator + "workbench.xml";
        Composite ret = new Composite(parent, 0);
        GridLayout gl = new GridLayout(2, false);
        gl.verticalSpacing = 10;
        ret.setLayout((Layout)gl);
        ret.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, true));
        Label desc = new Label(ret, 64);
        desc.setText(String.valueOf(Messages.UserPreferences_Explanation1) + Messages.UserPreferences_Explanation2 + Messages.UserPreferences_Explanation3);
        desc.setLayoutData((Object)SWTHelper.getFillGridData(2, true, 1, false));
        List userBlobs = NamedBlob.findFromPrefix((String)"UserCfg:");
        this.userPrefs = new String[userBlobs.size()];
        int i = 0;
        while (i < this.userPrefs.length) {
            this.userPrefs[i] = ((NamedBlob)userBlobs.get(i)).getId().split(":")[1];
            ++i;
        }
        List wsBlobs = NamedBlob.findFromPrefix((String)"Workspace:");
        this.WSPrefs = new String[wsBlobs.size()];
        int i2 = 0;
        while (i2 < this.WSPrefs.length) {
            this.WSPrefs[i2] = ((NamedBlob)wsBlobs.get(i2)).getId().split(":")[1];
            ++i2;
        }
        this.bLoad = new Button(ret, 8);
        this.bLoad.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
        this.bLoad.setText(Messages.UserPreferences_LoadSettingsfrom);
        this.bLoad.setLayoutData((Object)new GridData(4));
        this.bLoad.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                String name = UserPreferences.this.cbUserLoad.getText();
                if (StringTool.isNothing((Object)name)) {
                    SWTHelper.showInfo(Messages.UserPreferences_NoNameGiven, Messages.UserPreferences_PleaseEnterName);
                } else if (NamedBlob.exists((String)(String.valueOf(Messages.UserPreferences_14) + name))) {
                    NamedBlob blob = NamedBlob.load((String)("UserCfg:" + name));
                    InMemorySettings ims = new InMemorySettings(blob.getHashtable());
                    CoreHub.userCfg.overlay((Settings)ims, 1);
                } else {
                    SWTHelper.showError(Messages.UserPreferences_KonfigNotFound, MessageFormat.format(Messages.UserPreferences_ConfigWasNotFound, name));
                }
            }
        });
        this.cbUserLoad = new Combo(ret, 12);
        this.cbUserLoad.setItems(this.userPrefs);
        this.cbUserLoad.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
        this.bSave = new Button(ret, 8);
        this.bSave.setText(Messages.UserPreferences_SaveSettingsTo);
        this.bSave.setLayoutData((Object)new GridData(4));
        this.bSave.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                String name = UserPreferences.this.cbUserSave.getText();
                if (StringTool.isNothing((Object)name)) {
                    SWTHelper.showInfo(Messages.UserPreferences_NoNameGiven, Messages.UserPreferences_PleaseEnterName2);
                } else {
                    NamedBlob blob = NamedBlob.load((String)("UserCfg:" + name));
                    InMemorySettings ims = new InMemorySettings();
                    ims.overlay(CoreHub.userCfg, 1);
                    blob.put(ims.getNode());
                    SWTHelper.showInfo(Messages.UserPreferences_ConfigSaved, MessageFormat.format(Messages.UserPreferences_ConfigWasSaved, name));
                    UserPreferences.this.cbUserSave.setText("");
                }
            }
        });
        this.cbUserSave = new Combo(ret, 4);
        this.cbUserSave.setLayoutData((Object)new GridData(768));
        this.cbUserSave.setItems(this.userPrefs);
        this.bWorkspaceLoad = new Button(ret, 8);
        this.bWorkspaceLoad.setText(Messages.UserPreferences_LoadDeskSettingsFrom);
        this.bWorkspaceLoad.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                String name = UserPreferences.this.cbWSLoad.getText();
                if (StringTool.isNothing((Object)name)) {
                    SWTHelper.showInfo(Messages.UserPreferences_NoNameGiven, Messages.UserPreferences_PleaseEnterName3);
                } else if (NamedBlob.exists((String)("Workspace:" + name))) {
                    NamedBlob blob = NamedBlob.load((String)("Workspace:" + name));
                    InMemorySettings ims = new InMemorySettings(blob.getHashtable());
                    final String newloc = ims.get("perspectivelayout", null);
                    if (newloc != null) {
                        ShutdownJob job = new ShutdownJob(){

                            public void doit() {
                                try {
                                    File file = new File(layoutfile);
                                    FileTool.copyFile((File)file, (File)new File(String.valueOf(layoutfile) + ".bak"), (int)0);
                                    file.delete();
                                    FileWriter fout = new FileWriter(file);
                                    fout.write(newloc);
                                    fout.close();
                                }
                                catch (Exception ex) {
                                    ExHandler.handle((Throwable)ex);
                                }
                            }
                        };
                        Hub.addShutdownJob(job);
                        SWTHelper.showInfo(Messages.UserPreferences_ConfigLoaded, Messages.UserPreferences_ConfigActiveNextTime);
                    }
                } else {
                    SWTHelper.showError(Messages.UserPreferences_ConfigNotFound, String.valueOf(Messages.UserPreferences_3) + name + Messages.UserPreferences_4);
                }
            }
        });
        this.bWorkspaceLoad.setLayoutData((Object)new GridData(4));
        this.cbWSLoad = new Combo(ret, 12);
        this.cbWSLoad.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
        this.cbWSLoad.setItems(this.WSPrefs);
        this.bWorkspaceSave = new Button(ret, 8);
        this.bWorkspaceSave.setText(Messages.UserPreferences_WorkspaceSettingsSaveTo);
        this.bWorkspaceSave.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                String name = UserPreferences.this.cbWSSave.getText();
                if (StringTool.isNothing((Object)name)) {
                    SWTHelper.showInfo(Messages.UserPreferences_NoNameGiven, Messages.UserPreferences_PleaseEnterName4);
                } else {
                    try {
                        int x;
                        File file = new File(layoutfile);
                        FileReader reader = new FileReader(file);
                        StringBuilder sb = new StringBuilder(1000);
                        char[] load = new char[4096];
                        while ((x = reader.read(load)) != -1) {
                            sb.append(load, 0, x);
                        }
                        reader.close();
                        NamedBlob blob = NamedBlob.load((String)("Workspace:" + name));
                        InMemorySettings ims = new InMemorySettings();
                        ims.set("perspectivelayout", sb.toString());
                        blob.put(ims.getNode());
                    }
                    catch (Exception ex) {
                        ExHandler.handle((Throwable)ex);
                    }
                }
            }
        });
        this.bWorkspaceSave.setLayoutData((Object)new GridData(4));
        this.cbWSSave = new Combo(ret, 4);
        this.cbWSSave.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
        this.cbWSSave.setItems(this.WSPrefs);
        return ret;
    }

    public void init(IWorkbench workbench) {
    }
}

