/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.exchange.elements;

import ch.elexis.core.data.interfaces.IVerrechenbar;
import ch.elexis.core.data.service.CodeElementServiceHolder;
import ch.elexis.core.model.IPersistentObject;
import ch.elexis.core.services.ICodeElementService;
import ch.elexis.core.ui.exchange.XChangeContainer;
import ch.elexis.core.ui.exchange.XChangeExporter;
import ch.elexis.core.ui.exchange.elements.XChangeElement;
import ch.elexis.core.ui.exchange.elements.XidElement;
import ch.elexis.data.Eigenleistung;
import ch.elexis.data.dto.CodeElementDTO;
import ch.rgw.tools.TimeTool;
import java.util.List;
import java.util.Optional;
import org.jdom.Element;

public class ServiceElement
extends XChangeElement {
    private static final long serialVersionUID = 6382517263003793221L;
    public static final String XMLNAME = "service";
    public static final String ATTR_NAME = "name";
    public static final String ATTR_CONTRACT_NAME = "contractName";
    public static final String ATTR_CONTRACT_CODE = "contractCode";
    public static final String ATTR_MINUTES = "minutes";
    public static final String ATTR_COST = "cost";
    public static final String ATTR_PRICE = "price";
    public static final String ELEMENT_XID = "xid";

    public ServiceElement asExporter(XChangeExporter p, IVerrechenbar iv) {
        this.asExporter(p);
        this.setAttribute(ATTR_NAME, iv.getText());
        this.setAttribute(ATTR_CONTRACT_CODE, iv.getCode());
        this.setAttribute(ATTR_CONTRACT_NAME, iv.getCodeSystemName());
        this.setAttribute(ATTR_MINUTES, Integer.toString(iv.getMinutes()));
        this.setAttribute(ATTR_COST, iv.getKosten(new TimeTool()).getCentsAsString());
        this.setAttribute(ATTR_PRICE, Integer.toString(iv.getTP(new TimeTool(), null)));
        this.add(new XidElement().asExporter(p, iv));
        return this;
    }

    public ServiceElement asExporter(XChangeExporter sender, CodeElementDTO ic) {
        Optional element;
        this.asExporter(sender);
        this.setAttribute(ATTR_NAME, ic.getText());
        this.setAttribute(ATTR_CONTRACT_CODE, ic.getCode());
        this.setAttribute(ATTR_CONTRACT_NAME, ic.getCodeSystemName());
        ICodeElementService service = CodeElementServiceHolder.getService();
        if (service != null && (element = service.createFromString(ic.getCodeSystemName(), ic.getCode(), CodeElementServiceHolder.emtpyContext())).isPresent() && element.get() instanceof IVerrechenbar) {
            IVerrechenbar iv = (IVerrechenbar)element.get();
            this.setAttribute(ATTR_MINUTES, Integer.toString(iv.getMinutes()));
            this.setAttribute(ATTR_COST, iv.getKosten(new TimeTool()).getCentsAsString());
            this.setAttribute(ATTR_PRICE, Integer.toString(iv.getTP(new TimeTool(), null)));
            this.add(new XidElement().asExporter(sender, iv));
        }
        return this;
    }

    public IVerrechenbar createObject(XChangeContainer home, Element el) {
        XidElement xide = (XidElement)this.getChild(ELEMENT_XID, XidElement.class);
        List<IPersistentObject> objs = xide.findObject();
        for (IPersistentObject po : objs) {
            if (!(po instanceof IVerrechenbar)) continue;
            return (IVerrechenbar)po;
        }
        Eigenleistung egl = new Eigenleistung(el.getAttributeValue(ATTR_CONTRACT_CODE), el.getAttributeValue(ATTR_NAME), el.getAttributeValue(ATTR_COST), el.getAttributeValue(ATTR_PRICE));
        return egl;
    }

    @Override
    public String getXMLName() {
        return XMLNAME;
    }
}

