/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.exchange.elements;

import ch.elexis.core.model.FallConstants;
import ch.elexis.core.ui.exchange.XChangeExporter;
import ch.elexis.core.ui.exchange.elements.ContactElement;
import ch.elexis.core.ui.exchange.elements.XChangeElement;
import ch.elexis.data.Fall;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Kontakt;
import ch.rgw.tools.TimeTool;

public class InsuranceElement
extends XChangeElement {
    public static final String XMLNAME = "insurance";
    public static final String ATTR_COMPANYREF = "companyref";
    public static final String ATTR_REASON = "reason";
    public static final String ATTR_DIAGNOSIS = "publicDiagnosis";
    public static final String ATTR_DATEFROM = "dateFrom";
    public static final String ATTR_DATEUNTIL = "dateUntil";

    @Override
    public String getXMLName() {
        return XMLNAME;
    }

    public InsuranceElement asExporter(XChangeExporter p, Konsultation k) {
        this.asExporter(p);
        Fall fall = k.getFall();
        Kontakt garant = fall.getGarant();
        this.setAttribute(ATTR_DATEFROM, new TimeTool(fall.getBeginnDatum()).toString(6));
        if (!fall.isOpen()) {
            this.setAttribute(ATTR_DATEUNTIL, new TimeTool(fall.getEndDatum()).toString(6));
        }
        this.setAttribute(ATTR_REASON, this.translateReason(fall.getGrund()));
        ContactElement eGarant = p.addContact(garant);
        this.setAttribute(ATTR_COMPANYREF, eGarant.getID());
        ContractElement eContract = new ContractElement();
        this.add(eContract);
        return this;
    }

    public String translateReason(String grund) {
        if (grund.equals(FallConstants.TYPE_ACCIDENT)) {
            return "accident";
        }
        if (grund.equals(FallConstants.TYPE_BIRTHDEFECT)) {
            return "birthdefect";
        }
        if (grund.equals(FallConstants.TYPE_DISEASE)) {
            return "disease";
        }
        if (grund.equals(FallConstants.TYPE_MATERNITY)) {
            return "maternity";
        }
        if (grund.equals(FallConstants.TYPE_PREVENTION)) {
            return "prevention";
        }
        return "other";
    }

    static class ContractElement
    extends XChangeElement {
        public static final String XMLNAME = "contract";
        public static final String ATTR_COUNTRY = "country";
        public static final String ATTR_NAME = "name";
        public static final String ATTR_CASEID = "caseID";

        ContractElement() {
        }

        @Override
        public String getXMLName() {
            return XMLNAME;
        }

        public ContractElement asExporter(XChangeExporter p, Fall fall) {
            this.asExporter(p);
            this.setAttribute(ATTR_COUNTRY, "CH");
            this.setAttribute(ATTR_NAME, fall.getAbrechnungsSystem());
            this.setAttribute(ATTR_CASEID, fall.getId());
            return this;
        }
    }
}

