/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.dialogs;

import ch.elexis.data.Bestellung;
import ch.elexis.data.Query;
import ch.rgw.tools.TimeTool;
import java.util.List;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.dialogs.SelectionDialog;

public class SelectBestellungDialog
extends SelectionDialog {
    private IStructuredContentProvider fContentProvider;
    private ILabelProvider fLabelProvider;
    private Object fInput;
    private TableViewer fTableViewer;
    private boolean fAddCancelButton = true;
    private int widthInChars = 55;
    private int heightInChars = 15;

    public SelectBestellungDialog(Shell parent) {
        super(parent);
    }

    protected Control createDialogArea(Composite container) {
        Composite parent = (Composite)super.createDialogArea(container);
        this.createMessageArea(parent);
        this.fTableViewer = new TableViewer(parent, this.getTableStyle());
        this.fTableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.addColumns();
        this.setComparator();
        this.fTableViewer.setInput((Object)this);
        this.fTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (SelectBestellungDialog.this.fAddCancelButton) {
                    SelectBestellungDialog.this.okPressed();
                }
            }
        });
        List initialSelection = this.getInitialElementSelections();
        if (initialSelection != null) {
            this.fTableViewer.setSelection((ISelection)new StructuredSelection(initialSelection));
        }
        GridData gd = new GridData(1808);
        gd.heightHint = this.convertHeightInCharsToPixels(this.heightInChars);
        gd.widthHint = this.convertWidthInCharsToPixels(this.widthInChars);
        Table table = this.fTableViewer.getTable();
        table.setLayoutData((Object)gd);
        table.setFont(container.getFont());
        table.setHeaderVisible(true);
        Query qbe = new Query(Bestellung.class);
        this.fTableViewer.setInput((Object)qbe.execute());
        return parent;
    }

    private void setComparator() {
        this.fTableViewer.setComparator(new ViewerComparator(){
            private TimeTool t1 = new TimeTool();
            private TimeTool t2 = new TimeTool();

            public int compare(Viewer viewer, Object b1, Object b2) {
                this.setTimeTool((Bestellung)b1, this.t1);
                this.setTimeTool((Bestellung)b2, this.t2);
                if (this.t1.after((Object)this.t2)) {
                    return -1;
                }
                if (this.t2.after((Object)this.t1)) {
                    return 1;
                }
                return 0;
            }

            private void setTimeTool(Bestellung bestellung, TimeTool timeTool) {
                try {
                    String[] i = bestellung.getId().split(":");
                    timeTool.set(i[1]);
                }
                catch (Exception e) {
                    timeTool.set("1.1.1970");
                }
            }
        });
    }

    private void addColumns() {
        TableViewerColumn closed = new TableViewerColumn(this.fTableViewer, 0);
        closed.getColumn().setWidth(50);
        closed.getColumn().setText("Abg.");
        closed.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Bestellung bestellung = (Bestellung)element;
                if (bestellung.isDone()) {
                    return "*";
                }
                return "";
            }
        });
        TableViewerColumn time = new TableViewerColumn(this.fTableViewer, 0);
        time.getColumn().setWidth(125);
        time.getColumn().setText("Datum");
        time.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){
            TimeTool date = new TimeTool();

            public String getText(Object element) {
                Bestellung bestellung = (Bestellung)element;
                String[] i = bestellung.getId().split(":");
                if (i.length > 1) {
                    this.date.set(i[1]);
                    return this.date.toString(0);
                }
                return "???";
            }
        });
        TableViewerColumn title = new TableViewerColumn(this.fTableViewer, 0);
        title.getColumn().setWidth(200);
        title.getColumn().setText("Titel");
        title.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Bestellung bestellung = (Bestellung)element;
                String[] i = bestellung.getId().split(":");
                if (i.length > 0) {
                    return i[0];
                }
                return "???";
            }
        });
    }

    protected int getTableStyle() {
        return 68356;
    }

    protected void okPressed() {
        IStructuredSelection selection = (IStructuredSelection)this.fTableViewer.getSelection();
        this.setResult(selection.toList());
        super.okPressed();
    }
}

