/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.dialogs;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.ui.Hub;
import ch.elexis.core.ui.text.ITextPlugin;
import ch.elexis.core.ui.text.TextContainer;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.Brief;
import ch.elexis.data.Kontakt;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class GenericPrintDialog
extends Dialog
implements ITextPlugin.ICallback {
    String title;
    String subject;
    TextContainer text;
    Brief brief;

    public GenericPrintDialog(Shell shell, String title, String subject) {
        super(shell);
        this.title = title;
        this.subject = subject;
    }

    public void create() {
        super.create();
        this.getShell().setText(this.title);
        this.getShell().setSize(900, 700);
        SWTHelper.center(Hub.plugin.getWorkbench().getActiveWorkbenchWindow().getShell(), this.getShell());
    }

    protected Control createDialogArea(Composite parent) {
        Composite ret = (Composite)super.createDialogArea(parent);
        ret.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, true));
        ret.setLayout((Layout)new FillLayout());
        this.text = new TextContainer(this.getShell());
        this.text.getPlugin().createContainer(ret, this);
        this.text.getPlugin().showMenu(true);
        this.text.getPlugin().showToolbar(true);
        this.brief = this.text.createFromTemplateName(null, "Liste", "Allg.", (Kontakt)CoreHub.actUser, this.subject);
        this.text.getPlugin().insertText("[Titel]", this.subject, 16384);
        return ret;
    }

    public void insertText(String pattern, String t) {
        this.text.getPlugin().insertText(pattern, t, 16384);
    }

    public void insertTable(String place, String[][] table, int[] cellWidths) {
        this.text.getPlugin().insertTable(place, 0, table, cellWidths);
    }

    @Override
    public void save() {
        this.text.saveBrief(this.brief, "Allg.");
    }

    @Override
    public boolean saveAs() {
        return false;
    }
}

