/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.compatibility;

import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.compatibility.ElexisFastViewUtil;
import java.util.List;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimBar;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimElement;
import org.eclipse.e4.ui.model.application.ui.menu.MToolControl;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

@Component(property={"event.topics=org/eclipse/e4/ui/LifeCycle/appStartupComplete"})
public class UiStartupHandler
implements EventHandler {
    public void handleEvent(Event event) {
        Object property = event.getProperty("org.eclipse.e4.data");
        if (property instanceof MApplication) {
            final MApplication application = (MApplication)property;
            final EModelService modelService = (EModelService)application.getContext().get(EModelService.class);
            UiDesk.asyncExec(new Runnable(){

                @Override
                public void run() {
                    UiStartupHandler.this.addMandantSelectionItem(application, modelService);
                    ElexisFastViewUtil.registerPerspectiveListener();
                }
            });
        }
    }

    private void addMandantSelectionItem(MApplication mApplication, EModelService eModelService) {
        MTrimBar trimbar = (MTrimBar)eModelService.find("org.eclipse.ui.main.toolbar", (MUIElement)mApplication);
        if (trimbar != null) {
            MTrimElement mTrimElement = null;
            int position = 0;
            int i = 0;
            List childrens = trimbar.getChildren();
            for (MTrimElement element : childrens) {
                if ("ch.elexis.core.ui.toolcontrol.mandantselection".equals(element.getElementId())) {
                    mTrimElement = element;
                }
                if (position == 0 && ("ch.elexis.toolbar1".equals(element.getElementId()) || "PerspectiveSpacer".equals(element.getElementId()))) {
                    position = i;
                }
                ++i;
            }
            if (mTrimElement == null) {
                MToolControl mToolControl = (MToolControl)eModelService.createModelElement(MToolControl.class);
                mToolControl.setElementId("ch.elexis.core.ui.toolcontrol.mandantselection");
                mToolControl.setContributionURI("bundleclass://ch.elexis.core.ui/ch.elexis.core.ui.coolbar.MandantSelectionContributionItem");
                mToolControl.setToBeRendered(true);
                mToolControl.setVisible(true);
                childrens.add(position, mToolControl);
            }
        }
    }
}

