/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.commands;

import ch.elexis.core.ui.commands.Messages;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.views.TextView;
import ch.elexis.core.ui.views.textsystem.model.TextTemplate;
import ch.elexis.data.Brief;
import ch.rgw.tools.ExHandler;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadTemplateCommand
extends AbstractHandler {
    public static String ID = "ch.elexis.core.ui.command.loadTemplate";
    private static Logger logger = LoggerFactory.getLogger(LoadTemplateCommand.class);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Brief template;
        block5: {
            IStructuredSelection strucSelection;
            Object firstElement;
            template = null;
            ISelection selection = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getActivePage().getSelection();
            if (selection != null && (firstElement = (strucSelection = (IStructuredSelection)selection).getFirstElement()) != null && firstElement instanceof TextTemplate) {
                TextTemplate textTemplate = (TextTemplate)firstElement;
                template = textTemplate.getTemplate();
            }
            if (template != null) break block5;
            SWTHelper.alert(Messages.LoadTemplateCommand_Error, Messages.LoadTemplateCommand_NoTextTemplate);
            return null;
        }
        try {
            IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            TextView textView = (TextView)activePage.showView("ch.elexis.TextView");
            if (!textView.openDocument(template)) {
                SWTHelper.alert(ch.elexis.core.ui.views.Messages.BriefAuswahlErrorHeading, ch.elexis.core.ui.views.Messages.BriefAuswahlCouldNotLoadText);
            }
        }
        catch (PartInitException e) {
            logger.error("Could not open TextView", (Throwable)e);
            ExHandler.handle((Throwable)e);
        }
        return null;
    }
}

