/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.ui.preferences;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.findings.IAllergyIntolerance;
import ch.elexis.core.findings.ICoding;
import ch.elexis.core.findings.ICondition;
import ch.elexis.core.findings.IFamilyMemberHistory;
import ch.elexis.core.findings.IFinding;
import ch.elexis.core.findings.IFindingsService;
import ch.elexis.core.findings.IObservation;
import ch.elexis.core.findings.migration.IMigratorService;
import ch.elexis.core.findings.ui.services.FindingsServiceComponent;
import ch.elexis.core.findings.ui.services.MigratorServiceComponent;
import ch.elexis.core.findings.util.model.TransientCoding;
import ch.elexis.core.ui.preferences.SettingsPreferenceStore;
import ch.elexis.data.Patient;
import ch.elexis.data.Query;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FindingsSettings
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private BooleanFieldEditor diagStructFieldEditor;
    private BooleanFieldEditor persAnamneseStructFieldEditor;
    private BooleanFieldEditor riskFactorStructFieldEditor;
    private BooleanFieldEditor famAnamneseStructFieldEditor;
    private BooleanFieldEditor allergyIntoleranceStructFieldEditor;

    public void init(IWorkbench workbench) {
        this.setPreferenceStore((IPreferenceStore)new SettingsPreferenceStore(CoreHub.globalCfg));
        this.setMessage("Globale Befunde Einstellungen");
        FindingsServiceComponent.getService().findById("", IObservation.class);
    }

    protected void createFieldEditors() {
        this.diagStructFieldEditor = new BooleanFieldEditor("diagnose/settings/useStructured", "Diagnosen strukturiert anzeigen", this.getFieldEditorParent());
        this.addField((FieldEditor)this.diagStructFieldEditor);
        this.persAnamneseStructFieldEditor = new BooleanFieldEditor("persanamnese/settings/useStructured", "Pers\u00f6nliche Anamnese strukturiert anzeigen", this.getFieldEditorParent());
        this.addField((FieldEditor)this.persAnamneseStructFieldEditor);
        this.riskFactorStructFieldEditor = new BooleanFieldEditor("riskfactor/settings/useStructured", "Risiken strukturiert anzeigen", this.getFieldEditorParent());
        this.addField((FieldEditor)this.riskFactorStructFieldEditor);
        this.famAnamneseStructFieldEditor = new BooleanFieldEditor("familyanamnese/settings/useStructured", "Familien Anamnese strukturiert anzeigen", this.getFieldEditorParent());
        this.addField((FieldEditor)this.famAnamneseStructFieldEditor);
        this.allergyIntoleranceStructFieldEditor = new BooleanFieldEditor("allergyintolerance/settings/useStructured", "Allergien strukturiert anzeigen", this.getFieldEditorParent());
        this.addField((FieldEditor)this.allergyIntoleranceStructFieldEditor);
    }

    private Logger getLogger() {
        return LoggerFactory.getLogger(FindingsSettings.class);
    }

    public void propertyChange(PropertyChangeEvent event) {
        super.propertyChange(event);
        if (event != null) {
            if (event.getSource() == this.diagStructFieldEditor) {
                this.diagPropertyChange(event);
            } else if (event.getSource() == this.persAnamneseStructFieldEditor) {
                this.persAnamnesePropertyChange(event);
            } else if (event.getSource() == this.riskFactorStructFieldEditor) {
                this.riskFactorPropertyChange(event);
            } else if (event.getSource() == this.famAnamneseStructFieldEditor) {
                this.famAnamnesePropertyChange(event);
            } else if (event.getSource() == this.allergyIntoleranceStructFieldEditor) {
                this.allergyIntolerancePropertyChange(event);
            }
        }
    }

    private void diagPropertyChange(PropertyChangeEvent event) {
        if (event.getNewValue().equals(Boolean.TRUE)) {
            if (MessageDialog.openConfirm((Shell)this.getShell(), (String)"Strukturierte Diagnosen", (String)"Bisher erfasste Text Diagnosen werden automatisch in strukturierte umgewandelt.\nWollen Sie wirklich von nun an strukturierte Diagnosen verwenden?")) {
                ProgressMonitorDialog progressDialog = new ProgressMonitorDialog(this.getShell());
                try {
                    progressDialog.run(true, true, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            Query query = new Query(Patient.class);
                            List patients = query.execute();
                            monitor.beginTask("Strukturierte Diagnosen erzeugen", patients.size());
                            IFindingsService findingsService = FindingsServiceComponent.getService();
                            IMigratorService migratorService = MigratorServiceComponent.getService();
                            for (Patient patient : patients) {
                                String diagnosen = patient.getDiagnosen();
                                List<IFinding> existing = this.getExistingDiagnoses(patient.getId(), findingsService);
                                if (diagnosen != null && !diagnosen.isEmpty() && existing.isEmpty()) {
                                    migratorService.migratePatientsFindings(patient.getId(), ICondition.class, null);
                                }
                                monitor.worked(1);
                                if (monitor.isCanceled()) break;
                            }
                            monitor.done();
                            Display.getDefault().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    MessageDialog.openInformation((Shell)FindingsSettings.this.getShell(), (String)"Strukturierte Diagnosen", (String)"Strukturierte Diagnosen erfolgreich erzeugt. Bitte starten sie Elexis neu um mit den strukturierten Diagnosen zu arbeiten.");
                                }
                            });
                        }

                        private List<IFinding> getExistingDiagnoses(String patientId, IFindingsService findingsService) {
                            return findingsService.getPatientsFindings(patientId, ICondition.class).stream().filter(condition -> condition.getCategory() == ICondition.ConditionCategory.PROBLEMLISTITEM).collect(Collectors.toList());
                        }
                    });
                }
                catch (InterruptedException | InvocationTargetException e) {
                    MessageDialog.openError((Shell)this.getShell(), (String)"Diagnosen konvertieren", (String)"Fehler beim erzeugen der strukturierten Diagnosen.");
                    this.getLogger().error("Error creating structured diagnosis", (Throwable)e);
                }
            } else {
                this.getPreferenceStore().setValue("diagnose/settings/useStructured", false);
                this.getShell().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        FindingsSettings.this.diagStructFieldEditor.load();
                    }
                });
            }
        } else if (MessageDialog.openConfirm((Shell)this.getShell(), (String)"Strukturierte Diagnosen", (String)"Bisher erfasste strukturierte Diagnosen werden nicht in Text umgewandelt.\nWollen Sie wirklich von nun an Text Diagnosen verwenden?")) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)"Text Diagnosen", (String)"Bitte starten sie Elexis neu um mit den Text Diagnosen zu arbeiten.");
        } else {
            this.getPreferenceStore().setValue("diagnose/settings/useStructured", true);
            this.getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    FindingsSettings.this.diagStructFieldEditor.load();
                }
            });
        }
    }

    private void persAnamnesePropertyChange(PropertyChangeEvent event) {
        if (event.getNewValue().equals(Boolean.TRUE)) {
            if (MessageDialog.openConfirm((Shell)this.getShell(), (String)"Strukturierte Pers\u00f6nliche Anamnese", (String)"Bisher erfasste Pers\u00f6nliche Anamnese Eintr\u00e4ge werden automatisch in strukturierte umgewandelt.\nWollen Sie wirklich von nun an strukturierte Pers\u00f6nliche Anamnese Eintr\u00e4ge verwenden?")) {
                ProgressMonitorDialog progressDialog = new ProgressMonitorDialog(this.getShell());
                try {
                    progressDialog.run(true, true, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            Query query = new Query(Patient.class);
                            List patients = query.execute();
                            monitor.beginTask("Strukturierte Pers\u00f6nliche Anamnese erzeugen", patients.size());
                            IFindingsService findingsService = FindingsServiceComponent.getService();
                            IMigratorService migratorService = MigratorServiceComponent.getService();
                            for (Patient patient : patients) {
                                String persAnamesis = patient.getPersAnamnese();
                                List<IFinding> existing = this.getExistingPersAnamnese(patient.getId(), findingsService);
                                if (persAnamesis != null && !persAnamesis.isEmpty() && existing.isEmpty()) {
                                    migratorService.migratePatientsFindings(patient.getId(), IObservation.class, (ICoding)new TransientCoding(IObservation.ObservationCode.ANAM_PERSONAL));
                                }
                                monitor.worked(1);
                                if (monitor.isCanceled()) break;
                            }
                            monitor.done();
                            Display.getDefault().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    MessageDialog.openInformation((Shell)FindingsSettings.this.getShell(), (String)"Strukturierte Pers\u00f6nliche Anamnese", (String)"Strukturierte Pers\u00f6nliche Anamnese erfolgreich erzeugt. Bitte starten sie Elexis neu um mit den strukturierten Pers\u00f6nliche Anamnese Eintr\u00e4gen zu arbeiten.");
                                }
                            });
                        }

                        private List<IFinding> getExistingPersAnamnese(String patientId, IFindingsService findingsService) {
                            return findingsService.getPatientsFindings(patientId, IObservation.class).stream().filter(oberservation -> {
                                if (oberservation.getCategory() == IObservation.ObservationCategory.SOCIALHISTORY) {
                                    for (ICoding code : oberservation.getCoding()) {
                                        if (!IObservation.ObservationCode.ANAM_PERSONAL.isSame(code)) continue;
                                        return true;
                                    }
                                }
                                return false;
                            }).collect(Collectors.toList());
                        }
                    });
                }
                catch (InterruptedException | InvocationTargetException e) {
                    MessageDialog.openError((Shell)this.getShell(), (String)"Pers\u00f6nliche Anamnese konvertieren", (String)"Fehler beim erzeugen der strukturierten Pers\u00f6nliche Anamnese Eintr\u00e4gen.");
                    this.getLogger().error("Error creating structured anamnesis personally", (Throwable)e);
                }
            } else {
                this.getPreferenceStore().setValue("persanamnese/settings/useStructured", false);
                this.getShell().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        FindingsSettings.this.persAnamneseStructFieldEditor.load();
                    }
                });
            }
        } else if (MessageDialog.openConfirm((Shell)this.getShell(), (String)"Strukturierte Pers\u00f6nliche Anamnese", (String)"Bisher erfasste strukturierte Pers\u00f6nliche Anamnese werden nicht in Text umgewandelt.\nWollen Sie wirklich von nun an Text Pers\u00f6nliche Anamnese verwenden?")) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)"Text Pers\u00f6nliche Anamnese", (String)"Bitte starten sie Elexis neu um mit den Text Pers\u00f6nliche Anamnese zu arbeiten.");
        } else {
            this.getPreferenceStore().setValue("persanamnese/settings/useStructured", true);
            this.getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    FindingsSettings.this.persAnamneseStructFieldEditor.load();
                }
            });
        }
    }

    private void riskFactorPropertyChange(PropertyChangeEvent event) {
        if (event.getNewValue().equals(Boolean.TRUE)) {
            if (MessageDialog.openConfirm((Shell)this.getShell(), (String)"Strukturierte Risiken", (String)"Bisher erfasste Risiken werden automatisch in strukturierte umgewandelt.\nWollen Sie wirklich von nun an strukturierte Risiken verwenden?")) {
                ProgressMonitorDialog progressDialog = new ProgressMonitorDialog(this.getShell());
                try {
                    progressDialog.run(true, true, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            Query query = new Query(Patient.class);
                            List patients = query.execute();
                            monitor.beginTask("Strukturierte Risiken erzeugen", patients.size());
                            IFindingsService findingsService = FindingsServiceComponent.getService();
                            IMigratorService migratorService = MigratorServiceComponent.getService();
                            for (Patient patient : patients) {
                                String risk = patient.getRisk();
                                List<IFinding> existing = this.getExistingRiskfactors(patient.getId(), findingsService);
                                if (risk != null && !risk.isEmpty() && existing.isEmpty()) {
                                    migratorService.migratePatientsFindings(patient.getId(), IObservation.class, (ICoding)new TransientCoding(IObservation.ObservationCode.ANAM_RISK));
                                }
                                monitor.worked(1);
                                if (monitor.isCanceled()) break;
                            }
                            monitor.done();
                            Display.getDefault().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    MessageDialog.openInformation((Shell)FindingsSettings.this.getShell(), (String)"Strukturierte Risiken", (String)"Strukturierte Risiken erfolgreich erzeugt. Bitte starten sie Elexis neu um mit den strukturierten Risiken zu arbeiten.");
                                }
                            });
                        }

                        private List<IFinding> getExistingRiskfactors(String patientId, IFindingsService findingsService) {
                            return findingsService.getPatientsFindings(patientId, IObservation.class).stream().filter(oberservation -> {
                                if (oberservation.getCategory() == IObservation.ObservationCategory.SOCIALHISTORY) {
                                    for (ICoding code : oberservation.getCoding()) {
                                        if (!IObservation.ObservationCode.ANAM_RISK.isSame(code)) continue;
                                        return true;
                                    }
                                }
                                return false;
                            }).collect(Collectors.toList());
                        }
                    });
                }
                catch (InterruptedException | InvocationTargetException e) {
                    MessageDialog.openError((Shell)this.getShell(), (String)"Risiken konvertieren", (String)"Fehler beim erzeugen der strukturierten Risiken Eintr\u00e4gen.");
                    this.getLogger().error("Error creating structured risk factors", (Throwable)e);
                }
            } else {
                this.getPreferenceStore().setValue("riskfactor/settings/useStructured", false);
                this.getShell().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        FindingsSettings.this.riskFactorStructFieldEditor.load();
                    }
                });
            }
        } else if (MessageDialog.openConfirm((Shell)this.getShell(), (String)"Strukturierte Risiken", (String)"Bisher erfasste strukturierte Risiken werden nicht in Text umgewandelt.\nWollen Sie wirklich von nun an Text Risiken verwenden?")) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)"Text Risiken", (String)"Bitte starten sie Elexis neu um mit den Text Risiken zu arbeiten.");
        } else {
            this.getPreferenceStore().setValue("riskfactor/settings/useStructured", true);
            this.getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    FindingsSettings.this.riskFactorStructFieldEditor.load();
                }
            });
        }
    }

    private void famAnamnesePropertyChange(PropertyChangeEvent event) {
        if (event.getNewValue().equals(Boolean.TRUE)) {
            if (MessageDialog.openConfirm((Shell)this.getShell(), (String)"Strukturierte Familien Anamnese", (String)"Bisher erfasste Familien Anamnese Eintr\u00e4ge werden automatisch in strukturierte umgewandelt.\nWollen Sie wirklich von nun an strukturierte Familien Anamnese Eintr\u00e4ge verwenden?")) {
                ProgressMonitorDialog progressDialog = new ProgressMonitorDialog(this.getShell());
                try {
                    progressDialog.run(true, true, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            Query query = new Query(Patient.class);
                            List patients = query.execute();
                            monitor.beginTask("Strukturierte Familien Anamnese erzeugen", patients.size());
                            IFindingsService findingsService = FindingsServiceComponent.getService();
                            IMigratorService migratorService = MigratorServiceComponent.getService();
                            for (Patient patient : patients) {
                                String famAnamesis = patient.getFamilyAnamnese();
                                List<IFamilyMemberHistory> existing = this.getExistingFamAnamnese(patient.getId(), findingsService);
                                if (famAnamesis != null && !famAnamesis.isEmpty() && existing.isEmpty()) {
                                    migratorService.migratePatientsFindings(patient.getId(), IFamilyMemberHistory.class, null);
                                }
                                monitor.worked(1);
                                if (monitor.isCanceled()) break;
                            }
                            monitor.done();
                            Display.getDefault().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    MessageDialog.openInformation((Shell)FindingsSettings.this.getShell(), (String)"Strukturierte Familien Anamnese", (String)"Strukturierte Familien Anamnese erfolgreich erzeugt. Bitte starten sie Elexis neu um mit den strukturierten Familien Anamnese Eintr\u00e4gen zu arbeiten.");
                                }
                            });
                        }

                        private List<IFamilyMemberHistory> getExistingFamAnamnese(String patientId, IFindingsService findingsService) {
                            return findingsService.getPatientsFindings(patientId, IFamilyMemberHistory.class);
                        }
                    });
                }
                catch (InterruptedException | InvocationTargetException e) {
                    MessageDialog.openError((Shell)this.getShell(), (String)"Familien Anamnese konvertieren", (String)"Fehler beim erzeugen der strukturierten Familien Anamnese Eintr\u00e4gen.");
                    this.getLogger().error("Error creating structured anamnesis family", (Throwable)e);
                }
            } else {
                this.getPreferenceStore().setValue("familyanamnese/settings/useStructured", false);
                this.getShell().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        FindingsSettings.this.famAnamneseStructFieldEditor.load();
                    }
                });
            }
        } else if (MessageDialog.openConfirm((Shell)this.getShell(), (String)"Strukturierte Familien Anamnese", (String)"Bisher erfasste strukturierte Familien Anamnese werden nicht in Text umgewandelt.\nWollen Sie wirklich von nun an Text Familien Anamnese verwenden?")) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)"Text Familien Anamnese", (String)"Bitte starten sie Elexis neu um mit den Text Familien Anamnese zu arbeiten.");
        } else {
            this.getPreferenceStore().setValue("familyanamnese/settings/useStructured", true);
            this.getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    FindingsSettings.this.famAnamneseStructFieldEditor.load();
                }
            });
        }
    }

    private void allergyIntolerancePropertyChange(PropertyChangeEvent event) {
        if (event.getNewValue().equals(Boolean.TRUE)) {
            if (MessageDialog.openConfirm((Shell)this.getShell(), (String)"Strukturierte Allergien", (String)"Bisher erfasste Allergien Eintr\u00e4ge werden automatisch in strukturierte umgewandelt.\nWollen Sie wirklich von nun an strukturierte Allergien Eintr\u00e4ge verwenden?")) {
                ProgressMonitorDialog progressDialog = new ProgressMonitorDialog(this.getShell());
                try {
                    progressDialog.run(true, true, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            Query query = new Query(Patient.class);
                            List patients = query.execute();
                            monitor.beginTask("Strukturierte Allergien erzeugen", patients.size());
                            IFindingsService findingsService = FindingsServiceComponent.getService();
                            IMigratorService migratorService = MigratorServiceComponent.getService();
                            for (Patient patient : patients) {
                                String allergies = patient.getAllergies();
                                List<IAllergyIntolerance> existing = this.getExistingAllergyIntolerance(patient.getId(), findingsService);
                                if (allergies != null && !allergies.isEmpty() && existing.isEmpty()) {
                                    migratorService.migratePatientsFindings(patient.getId(), IAllergyIntolerance.class, null);
                                }
                                monitor.worked(1);
                                if (monitor.isCanceled()) break;
                            }
                            monitor.done();
                            Display.getDefault().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    MessageDialog.openInformation((Shell)FindingsSettings.this.getShell(), (String)"Strukturierte Allergien", (String)"Strukturierte Allergien erfolgreich erzeugt. Bitte starten sie Elexis neu um mit den strukturierten Allergien Eintr\u00e4gen zu arbeiten.");
                                }
                            });
                        }

                        private List<IAllergyIntolerance> getExistingAllergyIntolerance(String patientId, IFindingsService findingsService) {
                            return findingsService.getPatientsFindings(patientId, IAllergyIntolerance.class);
                        }
                    });
                }
                catch (InterruptedException | InvocationTargetException e) {
                    MessageDialog.openError((Shell)this.getShell(), (String)"Allergien konvertieren", (String)"Fehler beim erzeugen der strukturierten Allergien Eintr\u00e4gen.");
                    this.getLogger().error("Error creating structured allergy intolerances", (Throwable)e);
                }
            } else {
                this.getPreferenceStore().setValue("allergyintolerance/settings/useStructured", false);
                this.getShell().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        FindingsSettings.this.allergyIntoleranceStructFieldEditor.load();
                    }
                });
            }
        } else if (MessageDialog.openConfirm((Shell)this.getShell(), (String)"Strukturierte Allergien", (String)"Bisher erfasste strukturierte Allergien werden nicht in Text umgewandelt.\nWollen Sie wirklich von nun an Text Allergien verwenden?")) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)"Text Allergien", (String)"Bitte starten sie Elexis neu um mit den Text Allergien zu arbeiten.");
        } else {
            this.getPreferenceStore().setValue("allergyintolerance/settings/useStructured", true);
            this.getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    FindingsSettings.this.allergyIntoleranceStructFieldEditor.load();
                }
            });
        }
    }
}

