/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.ui.composites;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ch.elexis.core.findings.ICoding;
import ch.elexis.core.findings.ui.composites.CodingSelectionComposite;
import ch.elexis.core.findings.ui.services.CodingServiceComponent;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.util.NatTableFactory;
import ch.elexis.core.ui.util.NatTableWrapper;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.nebula.widgets.nattable.data.IColumnAccessor;
import org.eclipse.nebula.widgets.nattable.data.IRowDataProvider;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.GlazedListsDataProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;

public class CodingListComposite
extends Composite {
    private NatTableWrapper natTableWrapper;
    private ToolBarManager toolbarManager;
    private CodingSelectionComposite selectionComposite;
    private EventList<ICoding> dataList = new BasicEventList();
    private CodingAdapter adapter;

    public CodingListComposite(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(2, false));
        this.selectionComposite = new CodingSelectionComposite(this, 0);
        this.selectionComposite.setLayoutData(new GridData(768));
        this.selectionComposite.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                if (selection instanceof StructuredSelection && !selection.isEmpty()) {
                    ICoding iCoding = (ICoding)((StructuredSelection)selection).getFirstElement();
                    List<ICoding> existingCoding = CodingListComposite.this.adapter.getCoding();
                    existingCoding.add(iCoding);
                    CodingListComposite.this.adapter.setCoding(existingCoding);
                    CodingListComposite.this.dataList.add((Object)iCoding);
                    CodingListComposite.this.natTableWrapper.getNatTable().refresh();
                }
            }
        });
        this.toolbarManager = new ToolBarManager();
        this.toolbarManager.add((IAction)new RemoveCodingAction());
        ToolBar toolbar = this.toolbarManager.createControl((Composite)this);
        toolbar.setLayoutData((Object)new GridData(131072, 128, false, false));
        toolbar.setBackground(parent.getBackground());
        this.natTableWrapper = NatTableFactory.createSingleColumnTable((Composite)this, (IRowDataProvider)new GlazedListsDataProvider(this.dataList, (IColumnAccessor)new IColumnAccessor<ICoding>(){

            public int getColumnCount() {
                return 1;
            }

            public Object getDataValue(ICoding coding, int arg1) {
                List codes;
                StringBuilder text = new StringBuilder();
                String display = coding.getDisplay();
                if ((display == null || display.isEmpty()) && (codes = CodingServiceComponent.getService().getAvailableCodes(coding.getSystem())) != null && !codes.isEmpty()) {
                    ICoding code = CodingListComposite.this.searchForCode(coding.getCode(), codes);
                    display = code != null ? code.getDisplay() : "?";
                }
                text.append("<strong>");
                text.append("[").append(coding.getCode()).append("]");
                text.append("</strong>");
                text.append(" ").append(display);
                return text.toString();
            }

            public void setDataValue(ICoding coding, int arg1, Object arg2) {
            }
        }), null);
        GridData tableGd = new GridData(1808);
        tableGd.horizontalSpan = 2;
        this.natTableWrapper.getNatTable().setLayoutData((Object)tableGd);
    }

    private ICoding searchForCode(String code, List<ICoding> codes) {
        for (ICoding iCoding : codes) {
            if (!iCoding.getCode().equals(code)) continue;
            return iCoding;
        }
        return null;
    }

    public void setInput(CodingAdapter adapter) {
        this.adapter = adapter;
        this.dataList.clear();
        this.dataList.addAll(adapter.getCoding());
        this.natTableWrapper.getNatTable().refresh();
    }

    public static interface CodingAdapter {
        public List<ICoding> getCoding();

        public void setCoding(List<ICoding> var1);
    }

    private class RemoveCodingAction
    extends Action {
        private RemoveCodingAction() {
        }

        public ImageDescriptor getImageDescriptor() {
            return Images.IMG_DELETE.getImageDescriptor();
        }

        public String getText() {
            return "entfernen";
        }

        public void run() {
            ISelection selection = CodingListComposite.this.natTableWrapper.getSelection();
            if (selection instanceof StructuredSelection && !selection.isEmpty()) {
                List list = ((StructuredSelection)selection).toList();
                list.stream().forEach(c -> {
                    List<ICoding> existing = CodingListComposite.this.adapter.getCoding();
                    existing.remove(c);
                    CodingListComposite.this.adapter.setCoding(existing);
                    CodingListComposite.this.dataList.remove(c);
                    CodingListComposite.this.natTableWrapper.getNatTable().refresh();
                });
            }
        }
    }
}

