/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.schematron.pure.binding;

import com.phloc.commons.ValueEnforcer;
import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.exceptions.InitializationException;
import com.phloc.schematron.pure.binding.IPSQueryBinding;
import com.phloc.schematron.pure.binding.SchematronBindException;
import com.phloc.schematron.pure.binding.xpath.PSXPathQueryBinding;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class PSQueryBindingRegistry {
    public static final String QUERY_BINDING_XSLT = "xslt";
    public static final String QUERY_BINDING_XSLT2 = "xslt2";
    public static final IPSQueryBinding DEFAULT_QUERY_BINDING = PSXPathQueryBinding.getInstance();
    private static final ReadWriteLock s_aRWLock = new ReentrantReadWriteLock();
    private static final Map<String, IPSQueryBinding> s_aMap = new HashMap<String, IPSQueryBinding>();
    private static final PSQueryBindingRegistry s_aInstance;

    private PSQueryBindingRegistry() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerQueryBinding(@Nonnull @Nonempty String string, @Nonnull IPSQueryBinding iPSQueryBinding) throws SchematronBindException {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Name");
        ValueEnforcer.notNull((Object)iPSQueryBinding, (String)"QueryBinding");
        s_aRWLock.writeLock().lock();
        try {
            if (s_aMap.containsKey(string)) {
                throw new SchematronBindException("A queryBinding with the name '" + string + "' is already registered!");
            }
            s_aMap.put(string, iPSQueryBinding);
        }
        finally {
            s_aRWLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static IPSQueryBinding getQueryBindingOfName(@Nullable String string) {
        if (string == null) {
            return DEFAULT_QUERY_BINDING;
        }
        s_aRWLock.readLock().lock();
        try {
            IPSQueryBinding iPSQueryBinding = s_aMap.get(string);
            return iPSQueryBinding;
        }
        finally {
            s_aRWLock.readLock().unlock();
        }
    }

    @Nonnull
    public static IPSQueryBinding getQueryBindingOfNameOrThrow(@Nullable String string) throws SchematronBindException {
        IPSQueryBinding iPSQueryBinding = PSQueryBindingRegistry.getQueryBindingOfName(string);
        if (iPSQueryBinding == null) {
            throw new SchematronBindException("No query binding implementation present for query binding '" + string + "'");
        }
        return iPSQueryBinding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    @ReturnsMutableCopy
    public static Map<String, IPSQueryBinding> getAllRegisteredQueryBindings() {
        s_aRWLock.readLock().lock();
        try {
            Map map = ContainerHelper.newMap(s_aMap);
            return map;
        }
        finally {
            s_aRWLock.readLock().unlock();
        }
    }

    static {
        try {
            PSQueryBindingRegistry.registerQueryBinding(QUERY_BINDING_XSLT, DEFAULT_QUERY_BINDING);
            PSQueryBindingRegistry.registerQueryBinding(QUERY_BINDING_XSLT2, DEFAULT_QUERY_BINDING);
        }
        catch (SchematronBindException schematronBindException) {
            throw new InitializationException((Throwable)schematronBindException);
        }
        s_aInstance = new PSQueryBindingRegistry();
    }
}

