/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.model.prescription;

import java.util.Arrays;

public class Methods {
    public static String[] getSignatureAsStringArray(String signature) {
        Object[] daytimeSignature = new String[4];
        Arrays.fill(daytimeSignature, "");
        if (signature != null) {
            String[] split;
            if (signature.matches("[0-9\u00bd\u00bc]+([xX][0-9]+(/[0-9]+)?|)")) {
                String[] split2 = signature.split("[xX]");
                if (split2.length > 0 && split2.length < 5) {
                    System.arraycopy(split2, 0, daytimeSignature, 0, split2.length);
                    return Methods.getDayTimeOrFreetextSignatureArray((String[])daytimeSignature);
                }
            } else if (signature.indexOf(45) != -1) {
                String[] split3 = signature.split("[-]");
                if (split3.length > 0 && split3.length < 5) {
                    System.arraycopy(split3, 0, daytimeSignature, 0, split3.length);
                    return Methods.getDayTimeOrFreetextSignatureArray((String[])daytimeSignature);
                }
            } else if (signature.indexOf("/") != -1 && (split = signature.split("[/]")).length > 0 && split.length < 5) {
                System.arraycopy(split, 0, daytimeSignature, 0, split.length);
                return Methods.getDayTimeOrFreetextSignatureArray((String[])daytimeSignature);
            }
            daytimeSignature[0] = signature;
        }
        return Methods.getDayTimeOrFreetextSignatureArray((String[])daytimeSignature);
    }

    private static String[] getDayTimeOrFreetextSignatureArray(String[] signature) {
        Object[] values = new String[4];
        Arrays.fill(values, "");
        String morn = signature[0];
        String noon = signature[1];
        String eve = signature[2];
        String night = signature[3];
        String doseExpr = "[0-9]*([,.]{1}[0-9]+)?([/]{1}[0-9]+([,.]{1}[0-9]+)?)?";
        if (morn.matches(doseExpr) && noon.matches(doseExpr) && eve.matches(doseExpr) && night.matches(doseExpr)) {
            if (morn.isEmpty() && noon.isEmpty() && eve.isEmpty() && night.isEmpty()) {
                return values;
            }
            values[0] = morn.isEmpty() ? "0" : morn;
            values[1] = noon.isEmpty() ? "0" : noon;
            values[2] = eve.isEmpty() ? "0" : eve;
            values[3] = night.isEmpty() ? "0" : night;
            return values;
        }
        String freetext = Methods.createFreetextString(morn, noon, eve, night);
        freetext.trim();
        values[0] = freetext;
        return values;
    }

    private static String createFreetextString(String ... values) {
        StringBuilder sb = new StringBuilder();
        String[] stringArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            String val = stringArray[n2];
            if (!val.isEmpty() && !sb.toString().isEmpty()) {
                sb.append("-");
            }
            sb.append(val);
            ++n2;
        }
        return sb.toString();
    }
}

