/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.data.dto;

import ch.elexis.core.data.interfaces.IFall;
import ch.elexis.core.data.interfaces.IVerrechenbar;
import ch.elexis.core.exceptions.ElexisException;
import ch.elexis.data.Verrechnet;
import ch.elexis.data.dto.FallDTO;
import ch.elexis.data.dto.KonsultationDTO;
import ch.rgw.tools.Money;
import ch.rgw.tools.TimeTool;

public class LeistungDTO {
    private final String id;
    private String code;
    private final String text;
    private int count;
    private IVerrechenbar iVerrechenbar;
    private long lastUpdate;
    private Verrechnet verrechnet;
    private int tp = 0;
    private double tpw = 1.0;
    private double scale1 = 1.0;
    private double scale2 = 1.0;

    public LeistungDTO(Verrechnet verrechnet) throws ElexisException {
        if (!verrechnet.exists()) {
            throw new ElexisException("Verrechnete Leistung wird ignoriert - Keine Leistung vorhanden [ID: " + verrechnet.getId() + "].", (Throwable)new Exception());
        }
        try {
            if (verrechnet.getLastUpdate() < 0L) {
                throw new Exception();
            }
        }
        catch (Exception e) {
            throw new ElexisException("Die verrechnete Leistung wird ignoriert - Datum der letzten Aktualisierung ist fehlerhaft [ID: " + verrechnet.getId() + "].", (Throwable)e);
        }
        this.verrechnet = verrechnet;
        this.lastUpdate = verrechnet.getLastUpdate();
        this.id = verrechnet.getId();
        this.code = verrechnet.getCode();
        this.text = verrechnet.getText();
        this.tp = Verrechnet.checkZero(verrechnet.get("VK_TP"));
        this.tpw = verrechnet.getTPW();
        this.count = verrechnet.getZahl();
        this.iVerrechenbar = verrechnet.getVerrechenbar();
    }

    public LeistungDTO(IVerrechenbar iVerrechenbar, IFall fall) {
        this.lastUpdate = System.currentTimeMillis();
        this.id = iVerrechenbar.getId();
        this.code = iVerrechenbar.getCode();
        this.text = iVerrechenbar.getText();
        this.tp = iVerrechenbar.getTP(new TimeTool(), fall);
        this.tpw = 1.0;
        this.scale1 = 1.0;
        this.scale2 = 1.0;
        this.count = 1;
        this.iVerrechenbar = iVerrechenbar;
    }

    public void calcPrice(KonsultationDTO konsultationDTO, FallDTO fallDTO) {
        if (this.getVerrechnet() != null) {
            this.tpw = this.getVerrechnet().getVerrechenbar().getFactor(new TimeTool(konsultationDTO.getDate()), fallDTO);
        } else if (this.iVerrechenbar != null) {
            this.tpw = this.iVerrechenbar.getFactor(new TimeTool(konsultationDTO.getDate()), fallDTO);
        }
        if (this.verrechnet != null) {
            this.scale1 = this.verrechnet.getPrimaryScaleFactor();
            this.scale2 = this.verrechnet.getSecondaryScaleFactor();
        }
    }

    public void setTp(int tp) {
        this.tp = tp;
    }

    public void setScale2(double scale2) {
        this.scale2 = scale2;
    }

    public double getScale2() {
        return this.scale2;
    }

    public Verrechnet getVerrechnet() {
        return this.verrechnet;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getCode() {
        return this.code;
    }

    public String getText() {
        return this.text;
    }

    public void setVerrechnet(Verrechnet verrechnet) {
        this.verrechnet = verrechnet;
    }

    public String getId() {
        return this.id;
    }

    public Money getPrice() {
        return new Money((int)((double)Math.round((double)this.tp * this.tpw) * this.scale1 * this.scale2 * (double)this.count));
    }

    public void setCount(int count) {
        this.count = count;
    }

    public int getCount() {
        return this.count;
    }

    public void setiVerrechenbar(IVerrechenbar iVerrechenbar) {
        this.iVerrechenbar = iVerrechenbar;
    }

    public IVerrechenbar getIVerrechenbar() {
        return this.iVerrechenbar;
    }

    public long getLastUpdate() {
        return this.lastUpdate;
    }

    public int getTp() {
        return this.tp;
    }

    public double getTpw() {
        return this.tpw;
    }
}

