/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.data;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.ElexisEvent;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.events.ElexisEventListenerImpl;
import ch.elexis.core.jdt.Nullable;
import ch.elexis.core.model.IPersistentObject;
import ch.elexis.data.Anwender;
import ch.elexis.data.Leistungsblock;
import ch.elexis.data.PersistentObjectFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VerrechenbarFavorites {
    public static final String USER_CFG_FAVORITES = "verrechenbar/favoriten";
    private static List<Favorite> favorites;
    private static Logger log;
    private static ElexisEventListenerImpl eeli_pat;

    static {
        log = LoggerFactory.getLogger(VerrechenbarFavorites.class);
        eeli_pat = new ElexisEventListenerImpl((Class)Anwender.class, 64){

            @Override
            public void run(ElexisEvent ev) {
                log.debug("User changed, nulling favorites.");
                favorites = null;
            }
        };
        ElexisEventDispatcher.getInstance().addListeners(eeli_pat);
    }

    public static List<Favorite> getFavorites() {
        if (favorites == null) {
            favorites = new ArrayList<Favorite>();
            String favs = CoreHub.userCfg.get(USER_CFG_FAVORITES, "");
            String[] entries = favs.split(";");
            int i = 0;
            while (i < entries.length) {
                String entry = entries[i];
                if (entry.contains(",")) {
                    String[] value = entry.split(",");
                    Favorite f = new Favorite(value[1], value[0], i);
                    favorites.add(f);
                }
                ++i;
            }
            Collections.sort(favorites);
        }
        return favorites;
    }

    public static void storeFavorites() {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < favorites.size()) {
            Favorite f = favorites.get(i);
            sb.append(String.valueOf(f.macroString) + "," + f.storeToString);
            if (i != favorites.size() - 1) {
                sb.append(";");
            }
            ++i;
        }
        CoreHub.userCfg.set(USER_CFG_FAVORITES, sb.toString());
        CoreHub.userCfg.flush();
    }

    public static void setFavorite(IPersistentObject po, boolean val) {
        Favorite fav = VerrechenbarFavorites.isFavorite(po);
        if (val) {
            if (fav != null) {
                return;
            }
            String storeToString = po instanceof Leistungsblock ? String.valueOf(Leistungsblock.class.getName()) + "::" + po.getId() : po.storeToString();
            VerrechenbarFavorites.getFavorites().add(new Favorite(storeToString, "", 0));
        } else {
            if (fav == null) {
                return;
            }
            VerrechenbarFavorites.getFavorites().remove(fav);
        }
        VerrechenbarFavorites.storeFavorites();
    }

    public static Favorite isFavorite(IPersistentObject po) {
        for (Favorite favorite : VerrechenbarFavorites.getFavorites()) {
            String comparator = "";
            comparator = po instanceof Leistungsblock ? String.valueOf(Leistungsblock.class.getName()) + "::" + po.getId() : po.storeToString();
            if (!comparator.equalsIgnoreCase(favorite.storeToString)) continue;
            return favorite;
        }
        return null;
    }

    @Nullable
    public static Favorite findFavoritByMacroForCurrentUser(@Nullable String macro) {
        if (macro == null) {
            return null;
        }
        for (Favorite favorite : VerrechenbarFavorites.getFavorites()) {
            if (!macro.equals(favorite.macroString)) continue;
            return favorite;
        }
        return null;
    }

    public static class Favorite
    implements Comparable<Favorite> {
        String storeToString;
        String macroString;
        int order;
        private PersistentObjectFactory pof = new PersistentObjectFactory();

        public Favorite(String storeToString, String macroString, int order) {
            this.storeToString = storeToString;
            this.macroString = macroString;
            this.order = order;
        }

        @Override
        public int compareTo(Favorite o) {
            return Integer.compare(this.order, o.order);
        }

        public String getStoreToString() {
            return this.storeToString;
        }

        public void setStoreToString(String storeToString) {
            this.storeToString = storeToString;
        }

        public String getMacroString() {
            if (this.storeToString.startsWith(Leistungsblock.class.getName())) {
                Leistungsblock po = (Leistungsblock)this.getPersistentObject();
                return po != null ? po.getMacro() : this.macroString;
            }
            return this.macroString;
        }

        public void setMacroString(String macroString) {
            if (this.storeToString.startsWith(Leistungsblock.class.getName())) {
                Leistungsblock po = (Leistungsblock)this.getPersistentObject();
                if (po != null) {
                    po.setMacro(macroString);
                } else {
                    log.warn("Could not set macroString " + macroString + " to Leistungsblock  as po is null.");
                }
            }
            this.macroString = macroString;
        }

        public int getOrder() {
            return this.order;
        }

        public void setOrder(int order) {
            this.order = order;
        }

        @Nullable
        public IPersistentObject getPersistentObject() {
            return this.pof.createFromString(this.storeToString);
        }
    }
}

