/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.data.service;

import ch.elexis.core.model.IOrder;
import ch.elexis.core.model.IOrderEntry;
import ch.elexis.core.model.IStockEntry;
import ch.elexis.core.services.IOrderService;
import ch.elexis.data.Artikel;
import ch.elexis.data.BestellungEntry;
import ch.elexis.data.Query;
import ch.elexis.data.StockEntry;
import java.util.List;

public class OrderService
implements IOrderService {
    public IOrderEntry findOpenOrderEntryForStockEntry(IStockEntry ise) {
        StockEntry se = (StockEntry)ise;
        Artikel article = se.getArticle();
        Query qre = new Query(BestellungEntry.class);
        qre.add("STOCK", "=", se.getStock().getId());
        qre.add("ARTICLE_TYPE", "=", article.getClass().getName());
        qre.add("ARTICLE_ID", "=", article.getId());
        qre.add("STATE", "<>", Integer.toString(3));
        List execute = qre.execute();
        if (!execute.isEmpty()) {
            return (IOrderEntry)execute.get(0);
        }
        return null;
    }

    public IOrderEntry addRefillForStockEntryToOrder(IStockEntry ise, IOrder order) {
        int toOrder;
        int current = ise.getCurrentStock();
        int max = ise.getMaximumStock();
        if (max == 0) {
            max = ise.getMinimumStock();
        }
        if ((toOrder = max - current) > 0) {
            return order.addEntry((Object)ise.getArticle(), ise.getStock(), ise.getProvider(), toOrder);
        }
        return null;
    }
}

