/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.data.server;

import com.google.gson.Gson;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;

@Provider
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class GsonProvider<T>
implements MessageBodyReader<T>,
MessageBodyWriter<T> {
    private Gson gson = new Gson();

    public Gson getGson() {
        return this.gson;
    }

    public void setGson(Gson gson) {
        this.validateGson(gson);
        this.gson = gson;
    }

    private void validateGson(Gson gson) {
        if (gson == null) {
            throw new IllegalArgumentException("gson must not be null");
        }
    }

    public long getSize(T t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return true;
    }

    public void writeTo(T object, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        Throwable throwable = null;
        Object var9_10 = null;
        try (OutputStream stream = entityStream;){
            entityStream.write(this.gson.toJson(object).getBytes("utf-8"));
            entityStream.flush();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return true;
    }

    public T readFrom(Class<T> type, Type gnericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        Throwable throwable = null;
        Object var8_9 = null;
        try (InputStreamReader reader = new InputStreamReader(entityStream, "UTF-8");){
            return (T)this.gson.fromJson((Reader)reader, type);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

