/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.eigenartikel;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.ElexisEvent;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.events.ElexisEventListener;
import ch.elexis.core.eigenartikel.Eigenartikel;
import ch.elexis.core.eigenartikel.acl.ACLContributor;
import ch.elexis.core.lock.types.LockResponse;
import ch.elexis.core.model.IPersistentObject;
import ch.elexis.core.ui.actions.CodeSelectorHandler;
import ch.elexis.core.ui.actions.ICodeSelectorTarget;
import ch.elexis.core.ui.actions.RestrictedAction;
import ch.elexis.core.ui.actions.ToggleVerrechenbarFavoriteAction;
import ch.elexis.core.ui.eigenartikel.EigenartikelTreeContentProvider;
import ch.elexis.core.ui.eigenartikel.EigenartikelTreeLabelProvider;
import ch.elexis.core.ui.eigenartikel.ShowEigenartikelProductsAction;
import ch.elexis.core.ui.events.ElexisUiEventListenerImpl;
import ch.elexis.core.ui.locks.LockResponseHelper;
import ch.elexis.core.ui.selectors.FieldDescriptor;
import ch.elexis.core.ui.util.viewers.CommonViewer;
import ch.elexis.core.ui.util.viewers.SelectorPanelProvider;
import ch.elexis.core.ui.util.viewers.SimpleWidgetProvider;
import ch.elexis.core.ui.util.viewers.ViewerConfigurer;
import ch.elexis.core.ui.views.codesystems.CodeSelectorFactory;
import ch.elexis.data.PersistentObject;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.slf4j.Logger;

public class EigenartikelSelector
extends CodeSelectorFactory {
    private CommonViewer cv;
    private UpdateEventListener updateEventListener;
    private ToggleVerrechenbarFavoriteAction tvfa = new ToggleVerrechenbarFavoriteAction();
    private ISelectionChangedListener selChangeListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            TreeViewer tv = (TreeViewer)event.getSource();
            StructuredSelection ss = (StructuredSelection)tv.getSelection();
            EigenartikelSelector.this.tvfa.updateSelection(ss.isEmpty() ? null : ss.getFirstElement());
            if (!ss.isEmpty()) {
                Eigenartikel ea = (Eigenartikel)ss.getFirstElement();
                ElexisEventDispatcher.fireSelectionEvent((PersistentObject)ea);
            } else {
                ElexisEventDispatcher.clearSelection(Eigenartikel.class);
            }
        }
    };
    private RestrictedAction rearrangePackagesAction = new RestrictedAction(ACLContributor.EIGENARTIKEL_MODIFY){
        boolean initialized;
        {
            this.initialized = false;
            this.setText("Umgruppierung aktivieren");
        }

        public void doRun() {
            if (this.initialized) {
                return;
            }
            EigenartikelSelector.this.cv.getViewerWidget().addDropSupport(3, new Transfer[]{TextTransfer.getInstance()}, (DropTargetListener)new ViewerDropAdapter((Viewer)EigenartikelSelector.this.cv.getViewerWidget()){

                public void dragEnter(DropTargetEvent event) {
                    event.detail = 1;
                }

                public void drop(DropTargetEvent event) {
                    String[] dl;
                    Eigenartikel target = (Eigenartikel)this.determineTarget(event);
                    String drp = (String)event.data;
                    String[] stringArray = dl = drp.split(",");
                    int n = dl.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Eigenartikel ea;
                        String obj = stringArray[n2];
                        PersistentObject dropped = CoreHub.poFactory.createFromString(obj);
                        if (dropped instanceof Eigenartikel && !(ea = (Eigenartikel)dropped).isProduct()) {
                            LockResponse lr = CoreHub.getLocalLockService().acquireLock((IPersistentObject)target);
                            if (lr.isOk()) {
                                Eigenartikel.copyProductAttributesToArticleSetAsChild((Eigenartikel)target, (Eigenartikel)ea);
                                CoreHub.getLocalLockService().releaseLock((IPersistentObject)target);
                                ElexisEventDispatcher.reload(Eigenartikel.class);
                            } else {
                                LockResponseHelper.showInfo((LockResponse)lr, (IPersistentObject)target, (Logger)log);
                            }
                        }
                        ++n2;
                    }
                }

                public boolean performDrop(Object data) {
                    return true;
                }

                public boolean validateDrop(Object target, int operation, TransferData transferType) {
                    Eigenartikel ea = (Eigenartikel)this.getSelectedObject();
                    Eigenartikel eaTarget = (Eigenartikel)target;
                    return eaTarget != null && eaTarget.isProduct() && ea != null && !ea.isProduct();
                }
            });
            this.initialized = true;
            this.setEnabled(!this.initialized);
        }
    };

    public ViewerConfigurer createViewerConfigurer(CommonViewer cv) {
        this.cv = cv;
        MenuManager menu = new MenuManager();
        menu.add((IAction)this.tvfa);
        menu.add((IAction)this.rearrangePackagesAction);
        cv.setContextMenu(menu);
        cv.setSelectionChangedListener(this.selChangeListener);
        EigenartikelTreeContentProvider eal = new EigenartikelTreeContentProvider(cv);
        ShowEigenartikelProductsAction seaoa = new ShowEigenartikelProductsAction(eal, this);
        this.rearrangePackagesAction.setEnabled(CoreHub.userCfg.get("ShowEigenartikelProductsAction.showProducts", false));
        FieldDescriptor[] lbName = new FieldDescriptor[]{new FieldDescriptor(EigenartikelTreeContentProvider.FILTER_KEY)};
        SelectorPanelProvider slp = new SelectorPanelProvider(lbName, true);
        slp.addActions(new IAction[]{seaoa});
        ViewerConfigurer.DefaultButtonProvider dbp = new ViewerConfigurer.DefaultButtonProvider();
        SimpleWidgetProvider swp = new SimpleWidgetProvider(0, 0, null);
        EigenartikelTreeLabelProvider alp = new EigenartikelTreeLabelProvider();
        this.updateEventListener = new UpdateEventListener(cv, this.getElementClass(), 28);
        ElexisEventDispatcher.getInstance().addListeners(new ElexisEventListener[]{this.updateEventListener});
        return new ViewerConfigurer((ViewerConfigurer.ICommonViewerContentProvider)eal, (LabelProvider)alp, (ViewerConfigurer.ControlFieldProvider)slp, (ViewerConfigurer.ButtonProvider)dbp, (ViewerConfigurer.WidgetProvider)swp);
    }

    public Class<? extends PersistentObject> getElementClass() {
        return Eigenartikel.class;
    }

    public void dispose() {
        ElexisEventDispatcher.getInstance().removeListeners(new ElexisEventListener[]{this.updateEventListener});
    }

    public String getCodeSystemName() {
        return "Eigenartikel";
    }

    protected CommonViewer.DoubleClickListener getDoubleClickListener() {
        return new CommonViewer.DoubleClickListener(){

            public void doubleClicked(PersistentObject obj, CommonViewer cv) {
                ICodeSelectorTarget target = CodeSelectorHandler.getInstance().getCodeSelectorTarget();
                if (target != null && obj instanceof Eigenartikel) {
                    List packages;
                    Eigenartikel article = (Eigenartikel)obj;
                    if (article.isProduct() && !(packages = article.getPackages()).isEmpty()) {
                        article = (Eigenartikel)packages.get(0);
                    }
                    target.codeSelected((PersistentObject)article);
                }
            }
        };
    }

    public void allowArticleRearrangement(boolean checked) {
        this.rearrangePackagesAction.setEnabled(checked);
    }

    private class UpdateEventListener
    extends ElexisUiEventListenerImpl {
        CommonViewer viewer;

        UpdateEventListener(CommonViewer viewer, Class<?> clazz, int mode) {
            super(clazz, mode);
            this.viewer = viewer;
        }

        public void runInUi(ElexisEvent ev) {
            if (!this.viewer.getViewerWidget().getControl().isDisposed()) {
                if (8 == ev.getType()) {
                    this.viewer.getViewerWidget().refresh(true);
                } else if (4 == ev.getType() && ev.getObject() != null) {
                    this.viewer.getViewerWidget().refresh((Object)ev.getObject(), true);
                }
            }
            if (16 == ev.getType()) {
                this.viewer.setSelection((Object)ev.getObject(), false);
            }
        }
    }
}

