/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.fhir.po.model;

import ch.elexis.core.findings.ICoding;
import ch.elexis.core.findings.IEncounter;
import ch.elexis.core.findings.IObservation;
import ch.elexis.core.findings.IObservationLink;
import ch.elexis.core.findings.ObservationComponent;
import ch.elexis.core.findings.fhir.po.model.AbstractFhirPersistentObject;
import ch.elexis.core.findings.fhir.po.model.ObservationLink;
import ch.elexis.core.findings.scripting.FindingsScriptingUtil;
import ch.elexis.core.findings.util.fhir.accessor.ObservationAccessor;
import ch.elexis.data.Query;
import ch.rgw.tools.VersionInfo;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.hl7.fhir.dstu3.model.DomainResource;
import org.hl7.fhir.instance.model.api.IBaseResource;

public class Observation
extends AbstractFhirPersistentObject
implements IObservation {
    protected static final String TABLENAME = "CH_ELEXIS_CORE_FINDINGS_OBSERVATION";
    protected static final String VERSION = "1.0.3";
    public static final String FLD_PATIENTID = "patientid";
    public static final String FLD_ENCOUNTERID = "encounterid";
    public static final String FLD_PERFORMERID = "performerid";
    public static final String FLD_TYPE = "type";
    public static final String FLD_REFERENCED = "referenced";
    public static final String FLD_FORMAT = "format";
    public static final String FLD_SCRIPT = "script";
    public static final String FLD_DECIMALPLACE = "decimalplace";
    public static final String FLD_ORIGINURI = "originuri";
    private static final String FORMAT_KEY_VALUE_SPLITTER = ":-:";
    private static final String FORMAT_SPLITTER = ":split:";
    private ObservationAccessor accessor = new ObservationAccessor();
    protected static final String createDB = "CREATE TABLE CH_ELEXIS_CORE_FINDINGS_OBSERVATION(ID\t\t\t\t\tVARCHAR(25) PRIMARY KEY,lastupdate \t\tBIGINT,deleted\t\t\tCHAR(1) default '0',type\t\t\t\tCHAR(8), referenced\t\t\tCHAR(1) default '0',patientid\t        VARCHAR(80),encounterid\t    VARCHAR(80),performerid\t    VARCHAR(80),originuri\t\t\tVARCHAR(255),decimalplace\t    VARCHAR(8),format \t\t\tTEXT,script \t\t\tTEXT,content      \t\tTEXT);CREATE INDEX CH_ELEXIS_CORE_FINDINGS_OBSERVATION_IDX1 ON CH_ELEXIS_CORE_FINDINGS_OBSERVATION (patientid);CREATE INDEX CH_ELEXIS_CORE_FINDINGS_OBSERVATION_IDX2 ON CH_ELEXIS_CORE_FINDINGS_OBSERVATION (encounterid);CREATE INDEX CH_ELEXIS_CORE_FINDINGS_OBSERVATION_IDX3 ON CH_ELEXIS_CORE_FINDINGS_OBSERVATION (originuri);INSERT INTO CH_ELEXIS_CORE_FINDINGS_OBSERVATION (ID, patientid) VALUES ('VERSION','1.0.3');";

    static {
        Observation.addMapping((String)TABLENAME, (String[])new String[]{FLD_PATIENTID, FLD_ENCOUNTERID, FLD_PERFORMERID, "content", FLD_TYPE, FLD_REFERENCED, FLD_FORMAT, FLD_SCRIPT, FLD_DECIMALPLACE, FLD_ORIGINURI});
        Observation version = Observation.load("VERSION");
        if (version.state() < 2) {
            Observation.createOrModifyTable((String)createDB);
        } else {
            VersionInfo vi = new VersionInfo(version.get(FLD_PATIENTID));
            if (vi.isOlder("1.0.1")) {
                Observation.createOrModifyTable((String)"ALTER TABLE CH_ELEXIS_CORE_FINDINGS_OBSERVATION ADD type CHAR(8);");
                Observation.createOrModifyTable((String)"ALTER TABLE CH_ELEXIS_CORE_FINDINGS_OBSERVATION ADD referenced CHAR(1) default '0';");
                version.set(FLD_PATIENTID, "1.0.1");
            }
            if (vi.isOlder("1.0.2")) {
                Observation.createOrModifyTable((String)"ALTER TABLE CH_ELEXIS_CORE_FINDINGS_OBSERVATION ADD format TEXT;");
                version.set(FLD_PATIENTID, "1.0.2");
            }
            if (vi.isOlder(VERSION)) {
                Observation.createOrModifyTable((String)"ALTER TABLE CH_ELEXIS_CORE_FINDINGS_OBSERVATION ADD decimalplace VARCHAR(8);");
                Observation.createOrModifyTable((String)"ALTER TABLE CH_ELEXIS_CORE_FINDINGS_OBSERVATION ADD script TEXT;");
                Observation.createOrModifyTable((String)"ALTER TABLE CH_ELEXIS_CORE_FINDINGS_OBSERVATION ADD originuri VARCHAR(255);");
                Observation.createOrModifyTable((String)"CREATE INDEX CH_ELEXIS_CORE_FINDINGS_OBSERVATION_IDX3 ON CH_ELEXIS_CORE_FINDINGS_OBSERVATION (originuri);");
                version.set(FLD_PATIENTID, VERSION);
            }
        }
    }

    public static Observation load(String id) {
        return new Observation(id);
    }

    protected Observation(String id) {
        super(id);
    }

    public Observation() {
    }

    public String getLabel() {
        return null;
    }

    protected String getTableName() {
        return TABLENAME;
    }

    public Optional<IEncounter> getEncounter() {
        return this.getEncounter(FLD_ENCOUNTERID);
    }

    public void setEncounter(IEncounter encounter) {
        this.setEncounter(encounter, FLD_ENCOUNTERID);
    }

    public String getPatientId() {
        return this.get(FLD_PATIENTID);
    }

    public void setPatientId(String patientId) {
        this.set(FLD_PATIENTID, patientId);
        Optional<IBaseResource> resource = this.loadResource();
        if (resource.isPresent()) {
            this.accessor.setPatientId((DomainResource)resource.get(), patientId);
            this.saveResource(resource.get());
        }
    }

    public List<IObservation> getSourceObservations(IObservationLink.ObservationLinkType type) {
        Query qbe = new Query(ObservationLink.class);
        qbe.add("targetid", "=", this.getId());
        qbe.add(FLD_TYPE, "=", type.name());
        qbe.orderBy(true, new String[]{"lastupdate"});
        List observationLinks = qbe.execute();
        ArrayList<IObservation> iObservations = new ArrayList<IObservation>();
        for (ObservationLink link : observationLinks) {
            String id = link.get("sourceid");
            iObservations.add(Observation.load(id));
        }
        return iObservations;
    }

    public void addSourceObservation(IObservation source, IObservationLink.ObservationLinkType type) {
        if (source != null && source.getId() != null && this.getId() != null) {
            ObservationLink observationLink = new ObservationLink();
            observationLink.set("targetid", this.getId());
            observationLink.set("sourceid", source.getId());
            observationLink.set(FLD_TYPE, type.name());
        }
    }

    public void removeSourceObservation(IObservation source, IObservationLink.ObservationLinkType type) {
        Query qbe = new Query(ObservationLink.class);
        qbe.add("targetid", "=", this.getId());
        qbe.add("sourceid", "=", source.getId());
        qbe.add(FLD_TYPE, "=", type.name());
        List observationLinks = qbe.execute();
        for (ObservationLink link : observationLinks) {
            link.delete();
        }
    }

    public List<IObservation> getTargetObseravtions(IObservationLink.ObservationLinkType type) {
        Query qbe = new Query(ObservationLink.class);
        qbe.add("sourceid", "=", this.getId());
        qbe.add(FLD_TYPE, "=", type.name());
        qbe.orderBy(true, new String[]{"lastupdate"});
        List observationLinks = qbe.execute();
        ArrayList<IObservation> iObservations = new ArrayList<IObservation>();
        for (ObservationLink link : observationLinks) {
            String id = link.get("targetid");
            iObservations.add(Observation.load(id));
        }
        return iObservations;
    }

    public void addTargetObservation(IObservation target, IObservationLink.ObservationLinkType type) {
        if (target != null && target.getId() != null && this.getId() != null) {
            ObservationLink observationLink = new ObservationLink();
            observationLink.set("targetid", target.getId());
            observationLink.set("sourceid", this.getId());
            observationLink.set(FLD_TYPE, type.name());
        }
    }

    public void removeTargetObservation(IObservation target, IObservationLink.ObservationLinkType type) {
        Query qbe = new Query(ObservationLink.class);
        qbe.add("sourceid", "=", this.getId());
        qbe.add("targetid", "=", target.getId());
        qbe.add(FLD_TYPE, "=", type.name());
        List observationLinks = qbe.execute();
        for (ObservationLink link : observationLinks) {
            link.delete();
        }
    }

    public Optional<LocalDateTime> getEffectiveTime() {
        Optional<IBaseResource> resource = this.loadResource();
        if (resource.isPresent()) {
            return this.accessor.getEffectiveTime((DomainResource)resource.get());
        }
        return Optional.empty();
    }

    public void setEffectiveTime(LocalDateTime time) {
        Optional<IBaseResource> resource = this.loadResource();
        if (resource.isPresent()) {
            this.accessor.setEffectiveTime((DomainResource)resource.get(), time);
            this.saveResource(resource.get());
        }
    }

    public IObservation.ObservationCategory getCategory() {
        Optional<IBaseResource> resource = this.loadResource();
        if (resource.isPresent()) {
            return this.accessor.getCategory((DomainResource)resource.get());
        }
        return IObservation.ObservationCategory.UNKNOWN;
    }

    public void setCategory(IObservation.ObservationCategory category) {
        Optional<IBaseResource> resource = this.loadResource();
        if (resource.isPresent()) {
            this.accessor.setCategory((DomainResource)resource.get(), category);
            this.saveResource(resource.get());
        }
    }

    public List<ICoding> getCoding() {
        Optional<IBaseResource> resource = this.loadResource();
        if (resource.isPresent()) {
            return this.accessor.getCoding((DomainResource)resource.get());
        }
        return Collections.emptyList();
    }

    public void setCoding(List<ICoding> coding) {
        Optional<IBaseResource> resource = this.loadResource();
        if (resource.isPresent()) {
            this.accessor.setCoding((DomainResource)resource.get(), coding);
            this.saveResource(resource.get());
        }
    }

    public void setNumericValue(BigDecimal bigDecimal, String unit) {
        Optional<IBaseResource> resource = this.loadResource();
        if (resource.isPresent()) {
            this.accessor.setNumericValue((DomainResource)resource.get(), bigDecimal, unit);
            this.saveResource(resource.get());
        }
    }

    public Optional<BigDecimal> getNumericValue() {
        Optional<IBaseResource> resource = this.loadResource();
        if (resource.isPresent()) {
            if (FindingsScriptingUtil.hasScript((IObservation)this)) {
                FindingsScriptingUtil.evaluate((IObservation)this);
                resource = this.loadResource();
            }
            return this.accessor.getNumericValue((DomainResource)resource.get());
        }
        return Optional.empty();
    }

    public Optional<String> getNumericValueUnit() {
        Optional<IBaseResource> resource = this.loadResource();
        if (resource.isPresent()) {
            return this.accessor.getNumericValueUnit((DomainResource)resource.get());
        }
        return Optional.empty();
    }

    public List<ObservationComponent> getComponents() {
        Optional<IBaseResource> resource = this.loadResource();
        if (resource.isPresent()) {
            return this.accessor.getComponents((DomainResource)resource.get());
        }
        return Collections.emptyList();
    }

    public void addComponent(ObservationComponent component) {
        Optional<IBaseResource> resource = this.loadResource();
        if (resource.isPresent()) {
            this.accessor.addComponent((DomainResource)resource.get(), component);
            this.saveResource(resource.get());
        }
    }

    public void updateComponent(ObservationComponent component) {
        Optional<IBaseResource> resource = this.loadResource();
        if (resource.isPresent()) {
            this.accessor.updateComponent((DomainResource)resource.get(), component);
            this.saveResource(resource.get());
        }
    }

    public void setStringValue(String value) {
        Optional<IBaseResource> resource = this.loadResource();
        if (resource.isPresent()) {
            this.accessor.setStringValue((DomainResource)resource.get(), value);
            this.saveResource(resource.get());
        }
    }

    public Optional<String> getStringValue() {
        Optional<IBaseResource> resource = this.loadResource();
        if (resource.isPresent()) {
            return this.accessor.getStringValue((DomainResource)resource.get());
        }
        return Optional.empty();
    }

    public void setObservationType(IObservation.ObservationType observationType) {
        if (observationType != null) {
            this.set(FLD_TYPE, observationType.name());
        }
    }

    public IObservation.ObservationType getObservationType() {
        String type = this.get(FLD_TYPE);
        return StringUtils.isNotEmpty((String)type) ? IObservation.ObservationType.valueOf((String)type) : null;
    }

    public boolean isReferenced() {
        return "1".equals(this.get(FLD_REFERENCED));
    }

    public void setReferenced(boolean referenced) {
        this.set(FLD_REFERENCED, referenced ? "1" : "0");
    }

    public void setComment(String comment) {
        Optional<IBaseResource> resource = this.loadResource();
        if (resource.isPresent()) {
            this.accessor.setComment((DomainResource)resource.get(), comment);
            this.saveResource(resource.get());
        }
    }

    public Optional<String> getComment() {
        Optional<IBaseResource> resource = this.loadResource();
        if (resource.isPresent()) {
            return this.accessor.getComment((DomainResource)resource.get());
        }
        return Optional.empty();
    }

    public void addFormat(String key, String value) {
        StringBuilder builder = new StringBuilder(this.get(FLD_FORMAT));
        String dbValue = this.getFormat(key);
        String dbKeyValue = String.valueOf(key) + FORMAT_KEY_VALUE_SPLITTER + dbValue;
        int idx = builder.indexOf(dbKeyValue);
        if (idx == -1) {
            if (builder.length() > 0) {
                builder.append(FORMAT_SPLITTER);
            }
            builder.append(String.valueOf(key) + FORMAT_KEY_VALUE_SPLITTER + value);
        } else {
            builder.replace(idx, idx + dbKeyValue.length(), String.valueOf(key) + FORMAT_KEY_VALUE_SPLITTER + value);
        }
        this.set(FLD_FORMAT, builder.toString());
    }

    public String getFormat(String key) {
        String[] splits;
        String format = Observation.checkNull((Object)this.get(FLD_FORMAT));
        if (format.contains(String.valueOf(key) + FORMAT_KEY_VALUE_SPLITTER) && (splits = format.split(String.valueOf(key) + FORMAT_KEY_VALUE_SPLITTER)).length > 1) {
            return splits[1].split(FORMAT_SPLITTER)[0];
        }
        return "";
    }

    public Optional<String> getScript() {
        String value = this.get(FLD_SCRIPT);
        if (value != null && !value.isEmpty()) {
            return Optional.of(value);
        }
        return Optional.empty();
    }

    public void setScript(String script) {
        this.set(FLD_SCRIPT, script);
    }

    public int getDecimalPlace() {
        String value = this.get(FLD_DECIMALPLACE);
        if (value != null && !value.isEmpty()) {
            return Integer.valueOf(value);
        }
        return -1;
    }

    public void setDecimalPlace(int value) {
        this.set(FLD_DECIMALPLACE, Integer.toString(value));
    }

    public Optional<String> getOriginUri() {
        String value = this.get(FLD_ORIGINURI);
        if (value != null && !value.isEmpty()) {
            return Optional.of(value);
        }
        return Optional.empty();
    }

    public void setOriginUri(String uri) {
        this.set(FLD_ORIGINURI, uri);
    }
}

