/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.fhir.po.codes;

import ch.elexis.core.findings.ICoding;
import ch.elexis.core.findings.ILocalCoding;
import ch.elexis.core.findings.codes.CodingSystem;
import ch.elexis.core.findings.util.model.TransientCoding;
import ch.elexis.data.PersistentObject;
import ch.rgw.tools.VersionInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class LocalCoding
extends PersistentObject
implements ICoding,
ILocalCoding {
    protected static final String TABLENAME = "CH_ELEXIS_CORE_FINDINGS_LOCALCODING";
    protected static final String VERSION = "1.0.0";
    public static final String FLD_CODE = "code";
    public static final String FLD_DISPLAY = "display";
    private static final String FLD_MAPPED = "mapped";
    protected static final String createDB = "CREATE TABLE CH_ELEXIS_CORE_FINDINGS_LOCALCODING(ID\t\t\t\t\tVARCHAR(25) PRIMARY KEY,lastupdate \t\tBIGINT,deleted\t\t\tCHAR(1) default '0',code\t            VARCHAR(25),display      \t\tTEXT,mapped   \t        TEXT);CREATE INDEX CH_ELEXIS_CORE_FINDINGS_LOCALCODING_IDX1 ON CH_ELEXIS_CORE_FINDINGS_LOCALCODING (code);INSERT INTO CH_ELEXIS_CORE_FINDINGS_LOCALCODING (ID, code) VALUES ('VERSION','1.0.0');";
    private static String MAPPED_SEPARATOR;
    private static String MAPPED_SEPARATOR_SPLITTER;
    private static String MAPPED_FIELD_SEPARATOR;

    static {
        LocalCoding.addMapping((String)TABLENAME, (String[])new String[]{"id", FLD_CODE, FLD_DISPLAY, FLD_MAPPED});
        LocalCoding version = LocalCoding.load("VERSION");
        if (version.state() < 2) {
            LocalCoding.createOrModifyTable((String)createDB);
        } else {
            VersionInfo vi = new VersionInfo(version.get(FLD_CODE));
            if (vi.isOlder(VERSION)) {
                version.set(FLD_CODE, VERSION);
            }
        }
        MAPPED_SEPARATOR = "||";
        MAPPED_SEPARATOR_SPLITTER = "\\|\\|";
        MAPPED_FIELD_SEPARATOR = "^";
    }

    public static LocalCoding load(String id) {
        return new LocalCoding(id);
    }

    protected LocalCoding(String id) {
        super(id);
    }

    public LocalCoding() {
    }

    public LocalCoding(ICoding coding) {
        this.create(null);
        this.set(new String[]{FLD_CODE, FLD_DISPLAY}, new String[]{coding.getCode(), coding.getDisplay()});
    }

    public String getSystem() {
        return CodingSystem.ELEXIS_LOCAL_CODESYSTEM.getSystem();
    }

    public String getCode() {
        return LocalCoding.checkNull((Object)this.get(FLD_CODE));
    }

    public String getDisplay() {
        return LocalCoding.checkNull((Object)this.get(FLD_DISPLAY));
    }

    public String getLabel() {
        return "[" + this.getCode() + "] " + this.getDisplay();
    }

    public List<ICoding> getMappedCodes() {
        String mappedString = LocalCoding.checkNull((Object)this.get(FLD_MAPPED));
        if (!mappedString.isEmpty()) {
            return this.getMappedCodingFromString(mappedString);
        }
        return Collections.emptyList();
    }

    public void setMappedCodes(List<ICoding> mappedCodes) {
        String encoded = "";
        if (mappedCodes != null && !mappedCodes.isEmpty()) {
            encoded = this.getMappedCodingAsString(mappedCodes);
        }
        this.set(FLD_MAPPED, encoded);
    }

    protected String getTableName() {
        return TABLENAME;
    }

    private String getMappedCodingAsString(List<ICoding> mappedCoding) {
        StringBuilder sb = new StringBuilder();
        for (ICoding iCoding : mappedCoding) {
            if (sb.length() > 0) {
                sb.append(MAPPED_SEPARATOR);
            }
            sb.append(this.getAsString(iCoding));
        }
        return sb.toString();
    }

    private String getAsString(ICoding coding) {
        return String.valueOf(coding.getSystem()) + MAPPED_FIELD_SEPARATOR + coding.getCode() + MAPPED_FIELD_SEPARATOR + coding.getDisplay();
    }

    private List<ICoding> getMappedCodingFromString(String encoded) {
        String[] codeStrings = encoded.split(MAPPED_SEPARATOR_SPLITTER);
        if (codeStrings != null && codeStrings.length > 0) {
            ArrayList<ICoding> ret = new ArrayList<ICoding>();
            String[] stringArray = codeStrings;
            int n = codeStrings.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                this.getCodingFromString(string).ifPresent(c -> {
                    boolean bl = ret.add((ICoding)c);
                });
                ++n2;
            }
            return ret;
        }
        return Collections.emptyList();
    }

    private Optional<ICoding> getCodingFromString(String encoded) {
        String[] codingParts = encoded.split("\\" + MAPPED_FIELD_SEPARATOR);
        if (codingParts != null && codingParts.length > 1) {
            if (codingParts.length == 2) {
                return Optional.of(new TransientCoding(codingParts[0], codingParts[1], ""));
            }
            if (codingParts.length == 3) {
                return Optional.of(new TransientCoding(codingParts[0], codingParts[1], codingParts[2]));
            }
        }
        return Optional.empty();
    }
}

