/*
 * Decompiled with CFR 0.152.
 */
package uk.org.lidalia.sysoutslf4j.context;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.org.lidalia.sysoutslf4j.context.SysOutOverSLF4J;

class LoggingSystemRegister {
    private static final Logger LOG = LoggerFactory.getLogger(SysOutOverSLF4J.class);
    private final Set<String> loggingSystemNameFragments = new CopyOnWriteArraySet<String>();

    void registerLoggingSystem(String packageName) {
        this.loggingSystemNameFragments.add(packageName);
        LOG.info("Package {} registered; all classes within it or subpackages of it will be allowed to print to System.out and System.err", (Object)packageName);
    }

    void unregisterLoggingSystem(String packageName) {
        if (this.loggingSystemNameFragments.remove(packageName)) {
            LOG.info("Package {} unregistered; all classes within it or subpackages of it will have System.out and System.err redirected to SLF4J", (Object)packageName);
        }
    }

    boolean isInLoggingSystem(String className) {
        boolean isInLoggingSystem = false;
        for (String packageName : this.loggingSystemNameFragments) {
            if (!className.startsWith(packageName)) continue;
            isInLoggingSystem = true;
            break;
        }
        return isInLoggingSystem;
    }

    LoggingSystemRegister() {
    }
}

