/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.xml;

import com.phloc.commons.ValueEnforcer;
import com.phloc.commons.annotations.CodingStyleguideUnaware;
import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.lang.EnumHelper;
import com.phloc.commons.lang.GenericReflection;
import com.phloc.commons.name.IHasName;
import com.phloc.commons.xml.EXMLParserPropertyType;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;

public enum EXMLParserProperty implements IHasName
{
    GENERAL_XML_STRING(EXMLParserPropertyType.GENERAL, "http://xml.org/sax/properties/xml-string", String.class),
    GENERAL_EXTERNAL_SCHEMALOCATION(EXMLParserPropertyType.GENERAL, "http://apache.org/xml/properties/schema/external-schemaLocation", String.class),
    GENERAL_EXTERNAL_NONAMESPACE_SCHEMALOCATION(EXMLParserPropertyType.GENERAL, "http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation", String.class),
    GENERAL_ROOT_ELEMENT_DECLARATION(EXMLParserPropertyType.GENERAL, "http://apache.org/xml/properties/validation/schema/root-element-declaration", QName.class),
    GENERAL_ROOT_TYPE_DECLARATION(EXMLParserPropertyType.GENERAL, "http://apache.org/xml/properties/validation/schema/root-type-definition", QName.class),
    GENERAL_INPUT_BUFFER_SIZE(EXMLParserPropertyType.GENERAL, "http://apache.org/xml/properties/input-buffer-size", Integer.class),
    GENERAL_LOCALE(EXMLParserPropertyType.GENERAL, "http://apache.org/xml/properties/locale", Locale.class),
    GENERAL_SECURITY_MANAGER(EXMLParserPropertyType.GENERAL, "http://apache.org/xml/properties/security-manager", "org.apache.xerces.util.SecurityManager"),
    DOM_CURRENT_ELEMENT_NODE(EXMLParserPropertyType.DOM, "http://apache.org/xml/properties/dom/current-element-node", Element.class),
    DOM_DOCUMENT_CLASS_NAME(EXMLParserPropertyType.DOM, "http://apache.org/xml/properties/dom/document-class-name", String.class),
    SAX_DECLARATION_HANDLER(EXMLParserPropertyType.SAX, "http://xml.org/sax/properties/declaration-handler", DeclHandler.class),
    SAX_LEXICAL_HANDLER(EXMLParserPropertyType.SAX, "http://xml.org/sax/properties/lexical-handler", LexicalHandler.class),
    SAX_DOM_NODE(EXMLParserPropertyType.SAX, "http://xml.org/sax/properties/dom-node", Node.class),
    SAX_XML_VERSION(EXMLParserPropertyType.SAX, "http://xml.org/sax/properties/document-xml-version", String.class);

    private static final Logger s_aLogger;
    private final EXMLParserPropertyType m_ePropertyType;
    private final String m_sName;
    private Class<?> m_aValueClass;
    @CodingStyleguideUnaware
    private boolean m_bWarnedOnce = false;
    private final String m_sValueClassName;

    private EXMLParserProperty(@Nonnull @Nonempty EXMLParserPropertyType eXMLParserPropertyType, String string2, String string3) {
        this.m_ePropertyType = eXMLParserPropertyType;
        this.m_sName = string2;
        this.m_aValueClass = GenericReflection.getClassFromNameSafe(string3);
        this.m_sValueClassName = string3;
    }

    private EXMLParserProperty(@Nonnull EXMLParserPropertyType eXMLParserPropertyType, String string2, Class<?> clazz) {
        this.m_ePropertyType = eXMLParserPropertyType;
        this.m_sName = string2;
        this.m_aValueClass = clazz;
        this.m_sValueClassName = clazz.getName();
    }

    @Nonnull
    public EXMLParserPropertyType getPropertyType() {
        return this.m_ePropertyType;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getName() {
        return this.m_sName;
    }

    @Nullable
    public Class<?> getValueClass() {
        return this.m_aValueClass;
    }

    @Nonnull
    @Nonempty
    public String getValueClassName() {
        return this.m_sValueClassName;
    }

    public void applyTo(@Nonnull XMLReader xMLReader, Object object) {
        ValueEnforcer.notNull(xMLReader, "Parser");
        if (this.m_ePropertyType != EXMLParserPropertyType.GENERAL && this.m_ePropertyType != EXMLParserPropertyType.SAX) {
            s_aLogger.warn("Parser property '" + this.name() + "' is not applicable for SAX parsers!");
        }
        try {
            xMLReader.setProperty(this.m_sName, object);
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
            if (!this.m_bWarnedOnce) {
                s_aLogger.warn("XML Parser does not recognize property '" + this.name() + "'");
                this.m_bWarnedOnce = true;
            }
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            s_aLogger.warn("XML Parser does not support property '" + this.name() + "'");
        }
    }

    public void applyTo(@Nonnull DocumentBuilderFactory documentBuilderFactory, Object object) {
        ValueEnforcer.notNull(documentBuilderFactory, "DocumentBuilderFactory");
        if (this.m_ePropertyType != EXMLParserPropertyType.GENERAL && this.m_ePropertyType != EXMLParserPropertyType.DOM) {
            s_aLogger.warn("Parser property '" + this.name() + "' is not applicable for DOM parsers!");
        }
        try {
            documentBuilderFactory.setAttribute(this.m_sName, object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            s_aLogger.warn("DOM parser does not support property '" + this.name() + "'");
        }
    }

    @Nullable
    public static EXMLParserProperty getFromNameOrNull(@Nullable String string) {
        return EnumHelper.getFromNameOrNull(EXMLParserProperty.class, string);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static List<EXMLParserProperty> getAllPropertiesOfType(@Nonnull EXMLParserPropertyType eXMLParserPropertyType) {
        ValueEnforcer.notNull(eXMLParserPropertyType, "PropertyType");
        ArrayList<EXMLParserProperty> arrayList = new ArrayList<EXMLParserProperty>();
        for (EXMLParserProperty eXMLParserProperty : EXMLParserProperty.values()) {
            if (eXMLParserProperty.getPropertyType() != eXMLParserPropertyType) continue;
            arrayList.add(eXMLParserProperty);
        }
        return arrayList;
    }

    static {
        s_aLogger = LoggerFactory.getLogger(EXMLParserProperty.class);
    }
}

