/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.compare;

import com.phloc.commons.ValueEnforcer;
import com.phloc.commons.compare.ESortOrder;
import java.io.Serializable;
import java.util.Comparator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class AbstractComparator<DATATYPE>
implements Comparator<DATATYPE>,
Serializable {
    private ESortOrder m_eSortOrder;
    private Comparator<? super DATATYPE> m_aNestedComparator;

    public AbstractComparator() {
        this(ESortOrder.DEFAULT, null);
    }

    public AbstractComparator(@Nonnull ESortOrder eSortOrder) {
        this(eSortOrder, null);
    }

    public AbstractComparator(@Nullable Comparator<? super DATATYPE> comparator) {
        this(ESortOrder.DEFAULT, comparator);
    }

    public AbstractComparator(@Nonnull ESortOrder eSortOrder, @Nullable Comparator<? super DATATYPE> comparator) {
        this.m_eSortOrder = ValueEnforcer.notNull(eSortOrder, "SortOrder");
        this.m_aNestedComparator = comparator;
    }

    @Nonnull
    public final AbstractComparator<DATATYPE> setSortOrder(@Nonnull ESortOrder eSortOrder) {
        this.m_eSortOrder = ValueEnforcer.notNull(eSortOrder, "SortOrder");
        return this;
    }

    @Nonnull
    public final ESortOrder getSortOrder() {
        return this.m_eSortOrder;
    }

    protected abstract int mainCompare(DATATYPE var1, DATATYPE var2);

    @Override
    public final int compare(DATATYPE DATATYPE, DATATYPE DATATYPE2) {
        int n = this.mainCompare(DATATYPE, DATATYPE2);
        if (n == 0 && this.m_aNestedComparator != null) {
            n = this.m_aNestedComparator.compare(DATATYPE, DATATYPE2);
        }
        return (this.m_eSortOrder.isAscending() ? 1 : -1) * n;
    }
}

