/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.codec;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.charset.CCharset;
import com.phloc.commons.charset.CharsetManager;
import com.phloc.commons.codec.AbstractCodec;
import com.phloc.commons.codec.DecoderException;
import com.phloc.commons.codec.EncoderException;
import com.phloc.commons.codec.IStringCodec;
import com.phloc.commons.string.StringHelper;
import java.nio.charset.Charset;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class AbstractRFC1522Codec
extends AbstractCodec
implements IStringCodec {
    protected static final char SEP = '?';
    protected static final String POSTFIX = "?=";
    protected static final String PREFIX = "=?";

    @Nonnull
    @Nonempty
    protected abstract String getRFC1522Encoding();

    @Nullable
    protected String encodeText(@Nullable String string, @Nonnull Charset charset) throws EncoderException {
        if (string == null) {
            return null;
        }
        byte[] byArray = this.encode(CharsetManager.getAsBytes(string, charset));
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(PREFIX).append(charset.name()).append('?').append(this.getRFC1522Encoding()).append('?').append(CharsetManager.getAsString(byArray, CCharset.CHARSET_US_ASCII_OBJ)).append(POSTFIX);
        return stringBuilder.toString();
    }

    @Override
    @Nullable
    public String decodeText(@Nullable String string) throws DecoderException {
        if (string == null) {
            return null;
        }
        if (!string.startsWith(PREFIX) || !string.endsWith(POSTFIX)) {
            throw new DecoderException("RFC 1522 violation: malformed encoded content");
        }
        int n = string.length() - 2;
        int n2 = 2;
        int n3 = string.indexOf(63, n2);
        if (n3 == n) {
            throw new DecoderException("RFC 1522 violation: charset token not found");
        }
        String string2 = string.substring(n2, n3);
        if (StringHelper.hasNoText(string2)) {
            throw new DecoderException("RFC 1522 violation: charset not specified");
        }
        Charset charset = CharsetManager.getCharsetFromNameOrNull(string2);
        if (charset == null) {
            throw new DecoderException("Failed to resolve charset '" + string2 + "'");
        }
        n2 = n3 + 1;
        if ((n3 = string.indexOf(63, n2)) == n) {
            throw new DecoderException("RFC 1522 violation: encoding token not found");
        }
        String string3 = string.substring(n2, n3);
        if (!this.getRFC1522Encoding().equalsIgnoreCase(string3)) {
            throw new DecoderException("This codec cannot decode " + string3 + " encoded content");
        }
        n2 = n3 + 1;
        n3 = string.indexOf(63, n2);
        byte[] byArray = CharsetManager.getAsBytes(string.substring(n2, n3), CCharset.CHARSET_US_ASCII_OBJ);
        byArray = this.decode(byArray);
        return CharsetManager.getAsString(byArray, charset);
    }
}

