/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.templateresolver;

import java.util.Map;
import org.thymeleaf.IEngineConfiguration;
import org.thymeleaf.templateresolver.AbstractConfigurableTemplateResolver;
import org.thymeleaf.templateresource.ClassLoaderTemplateResource;
import org.thymeleaf.templateresource.ITemplateResource;
import org.thymeleaf.util.ClassLoaderUtils;
import org.thymeleaf.util.Validate;

public class ClassLoaderTemplateResolver
extends AbstractConfigurableTemplateResolver {
    private final ClassLoader classLoader;

    public ClassLoaderTemplateResolver() {
        this(ClassLoaderUtils.getClassLoader(ClassLoaderTemplateResolver.class));
    }

    public ClassLoaderTemplateResolver(ClassLoader classLoader) {
        Validate.notNull(classLoader, "Class Loader cannot be null");
        this.classLoader = classLoader;
    }

    @Override
    protected ITemplateResource computeTemplateResource(IEngineConfiguration configuration, String ownerTemplate, String template, String resourceName, String characterEncoding, Map<String, Object> templateResolutionAttributes) {
        return new ClassLoaderTemplateResource(this.classLoader, resourceName, characterEncoding);
    }
}

