/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.medication.handlers;

import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.actions.CodeSelectorHandler;
import ch.elexis.core.ui.medication.views.MedicationTableViewerItem;
import ch.elexis.core.ui.medication.views.MedicationView;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.views.codesystems.LeistungenView;
import ch.elexis.data.Artikel;
import ch.elexis.data.Prescription;
import ch.rgw.tools.StringTool;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwitchMedicationHandler
extends AbstractHandler {
    private static final Logger log = LoggerFactory.getLogger(SwitchMedicationHandler.class);
    private static final String UPCASES_DASH_NR_PATTERN = "[A-Z-0-9]+";
    private static final String SPACE = "\\s";
    private static final String NUMBERS = "[0-9]+";
    private static MedicationView medicationView;
    private LeistungenView leistungenView;
    private Prescription originalPresc;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        MedicationTableViewerItem mtvItem;
        Prescription p;
        IStructuredSelection strucSelection;
        Object firstElement;
        ISelection selection = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getActivePage().getSelection();
        if (selection != null && (firstElement = (strucSelection = (IStructuredSelection)selection).getFirstElement()) instanceof MedicationTableViewerItem && (p = (mtvItem = (MedicationTableViewerItem)firstElement).getPrescription()) != null) {
            this.originalPresc = p;
            this.copyShortArticleNameToClipboard();
            this.openLeistungsView();
        }
        return null;
    }

    private void copyShortArticleNameToClipboard() {
        Artikel article = this.originalPresc.getArtikel();
        if (article == null) {
            return;
        }
        String fullName = article.getName();
        String[] nameParts = fullName.split(SPACE);
        StringBuilder sbFilterName = new StringBuilder();
        int i = 0;
        while (i < nameParts.length) {
            String s = nameParts[i];
            if (i > 0) {
                sbFilterName.append(" ");
            }
            if (s.matches(UPCASES_DASH_NR_PATTERN) && !s.matches(NUMBERS)) {
                sbFilterName.append(s);
            } else {
                if (i >= 2) break;
                sbFilterName.append(s);
            }
            ++i;
        }
        Clipboard cb = new Clipboard(UiDesk.getDisplay());
        TextTransfer textTransfer = TextTransfer.getInstance();
        cb.setContents((Object[])new String[]{sbFilterName.toString()}, new Transfer[]{textTransfer});
    }

    private void openLeistungsView() {
        medicationView = (MedicationView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("ch.elexis.core.ui.medication.views.MedicationView");
        try {
            if (StringTool.isNothing((Object)"ch.elexis.LeistungenView")) {
                log.debug("LeistungenView.ID empty or not found");
                SWTHelper.alert((String)"Fehler", (String)"LeistungenView.ID");
            }
            medicationView.getViewSite().getPage().showView("ch.elexis.LeistungenView");
            this.leistungenView = (LeistungenView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("ch.elexis.LeistungenView");
            CodeSelectorHandler csHandler = CodeSelectorHandler.getInstance();
            csHandler.setCodeSelectorTarget(medicationView.getMedicationComposite().getDropTarget());
            csHandler.getCodeSelectorTarget().registered(false);
            medicationView.getMedicationComposite().setDropChangePrescription(this.originalPresc);
            CTabItem[] cTabItemArray = this.leistungenView.ctab.getItems();
            int n = cTabItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                CTabItem cti = cTabItemArray[n2];
                if (cti.getText().equalsIgnoreCase("Artikelstamm")) {
                    this.leistungenView.setSelected(cti);
                    this.leistungenView.setFocus();
                    this.leistungenView.ctab.setSelection(cti);
                }
                ++n2;
            }
        }
        catch (Exception e) {
            log.error("Could not open LeistungenView from the MedicationView in order to switch medication", (Throwable)e);
        }
    }
}

